#!/bin/bash

cd $(dirname $0)
g_curPath="$PWD"
g_scriptName="$(basename $0)"
cd - >> /dev/null


source "${g_curPath}/log.sh" || { echo "source ${g_curPath}/lib/log.sh failed."; exit 130; }
source "${g_curPath}/error.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${g_curPath}/lib/error.sh failed."; exit 130; }
source "${g_curPath}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${g_curPath}/lib/version.sh failed."; exit 130; }

#V100R006C00及其补丁返回成功
function main()
{
    local srcVersion="$(get_src_version)"
    log INFO "get srcVersion is ${srcVersion}."
    if [[ -n "$(echo ${srcVersion} | grep "V100R006C00")"  || -n "$(echo ${srcVersion} | grep "V100R003C30")" ]];then
        return 0
    fi
    return 1
}

main $@
retValue=$?
exit ${retValue}
