#!/bin/bash
##############################################################
## @Company: HUAWEI Tech. Co., Ltd.
## @Filename func.sh
## @Usage . func.sh
## @Description 
##############################################################


LOG_FILE="/var/log/dsware/update_precheck.log"

[ -z "$OMA_PATH" ] && OMA_PATH="/opt/omm/oma/workspace/tools"
LOG_TOOL="$OMA_PATH/omm_log"

OMS_RUN_PATH="/opt/omm/oms/"

#ʾ
SHOW_MSG="YES"

##############################################################
## @Usage log
## @Return 0 : 
## @Description ¼־ļ
##############################################################
log()
{
    local subLv="$1" && shift
    local subTag="$1" && shift
    $LOG_TOOL "$LOG_FILE" "${subLv}" "$*" "[$subTag]($$)"
    return 0
}

##############################################################
## @Usage showMsg
## @Return 0 : 
## @Description ӡϢΪYESӡϢ
##############################################################
showMsg()
{
    [ "${SHOW_MSG}" = "NO" ] && { return 0; }
    log "$@"
    echo "$@"
}

##############################################################
## @Usage getFloatIp
## @Return 0 : succ
## @Description get float ip from tomcat server.xml
##############################################################
getFloatIp()
{
    local updaCfg="/opt/omm/oma/workspace/conf/upda.cfg"
    local floatIp=$(cat $updaCfg | grep "SERVERIP=" | awk -F '=' '{print $2}');
    
    echo "$floatIp"
    return 0
}

##############################################################
## @Usage getLocalIp
## @Return 0 : succ
## @Description get local ip from tomcat server.xml
##############################################################
getLocalIp()
{
    local updaCfg="/opt/omm/oma/workspace/conf/upda.cfg"
    local localIp=$(cat $updaCfg | grep "LOCALIP=" | awk -F '=' '{print $2}');

    echo "$localIp"
    return 0
}

#############################################################################
# FUNCTION   : decrpt
# DESCRIPTION: decrpt an encrption word
# INPUT      : encript word
# USAGE      : xxx=$(decrpt | awk '{print}')
#############################################################################
decrpt()
{

    #declare envs.wcc޸Կʽ
    local parmas="$1"
    local encType="AES256"
    local rootDir="${OMS_RUN_PATH}/workspace"
    local selfDir="${OMS_RUN_PATH}/workspace/tools/encrypt"
    local wcc=$(find ${rootDir}/lib/ -maxdepth 1 -name 'wc2frm*.jar')
    local log4j=$(find ${rootDir}/lib/ -maxdepth 1 -name 'log4j*.jar')
    local commons=$(find ${rootDir}/lib/ -maxdepth 1 -name 'commons-codec*.jar')
    local javaArgs="-Dbeetle.application.home.path=${rootDir}/security/config"
    local classpath="${wcc}:${log4j}:${commons}:${selfDir}/main.jar"
    local className="com.omm.encrypt.DecryptCommandWithoutParam"
    local java_cmd="${OMS_RUN_PATH}/jre/bin/java -cp ${classpath} ${javaArgs} ${className}"

    #check params
    if [ -z "$parmas" ]; then
        log "ERROR" "$g_scriptName:$LINENO(decrpt)" "encript word is necessary parameter.";         
        return 1
    fi
    
    #ϰ汾ļܽűΪ׼ֻҪ֧AES256_CBCʹô˼ģʽ
    local isSupCBC=$(${OMS_RUN_PATH}/tools/encrypt/encryptWithoutParam.sh | grep -w "AES256_CBC")
    if [ -n "$isSupCBC" ]; then
        encType="AES256_CBC"
    fi
    
    local result=`${java_cmd} 2>/dev/null <<EOF
strSrc:$parmas
encType:$encType
EOF`
    if [[ "$result" =~ "ERROR" ]]; then
        log "ERROR" "$g_scriptName:$LINENO(decrpt)" "encrypt parmas failed!"
        return 1
    fi
    if [[ "$result" =~ "ception" ]]; then
        log "ERROR" "$g_scriptName:$LINENO(decrpt)" "encrypt parmas cause exceptsion!"
        return 1
    fi
    if [ -z "$result" ]; then
        log "ERROR" "$g_scriptName:$LINENO(decrpt)" "encrypt parmas result is null!"
        return 1
    fi
    
    echo "$result"
    #log "INFO" "$g_scriptName:$LINENO(decrpt)" "Exit decrpt."
    return 0
}

##############################################################
## @Usage GetDBPassword 
## @Return 0 : 
## @Description ȡGSDBݿ
##############################################################
GetDBPassword()
{           
    #1.ж߽ű
    local getCipherPasswdTool="${OMS_RUN_PATH}/tools/getdbNameOrPasswd"
    [ -e "${getCipherPasswdTool}" ] || { log "ERROR" "$g_scriptName:$LINENO(alterschema)" "${getCipherPasswdTool} is not exist."; return 1; }

    local CipherPasswd=$(${getCipherPasswdTool} 2 | awk '{print '$1'}')
    if [ -z "${CipherPasswd}" ];then
        log "ERROR" "$g_scriptName:$LINENO(alterschema)" "OMS's DB CipherPasswd is empty."
        return 1; 
    fi 

    local DecryptPasswd=$(decrpt ${CipherPasswd} | awk '{print}') 
    if [ -z "${DecryptPasswd}" ];then
        log "ERROR" "$g_scriptName:$LINENO(alterschema)" "OMS's DecryptPasswd is empty."; 
        return 1; 
    fi

    echo ${DecryptPasswd};
    return 0;
}

