#!/bin/bash

[ -z "$(echo "${LD_LIBRARY_PATH}" | grep "/opt/dsware/agent/lib")" ] && { export LD_LIBRARY_PATH="/usr/lib64/:/opt/dsware/agent/lib:${LD_LIBRARY_PATH}"; }

LOG_FILE="/var/log/dsware/update_precheck.log"
LOG_LEVEL="ERROR"

LOG_LEVEL_MUST="MUST"
LOG_LEVEL_ERROR="ERROR"
LOG_LEVEL_WARN="WARN"
LOG_LEVEL_INFO="INFO"
LOG_LEVEL_DEBUG="DEBUG"

file_name="$(basename $0)"

function log()
{
    local log_level="$1"
    shift
    local log_msg="$@"
    local str_log="[$(date +'%Z %Y-%m-%d %H:%M:%S')][${file_name}][${FUNCNAME[1]}][${BASH_LINENO[0]}][${log_level}] ${log_msg}"
    echo "${str_log}"
    echo "${str_log}" >> ${LOG_FILE}
    
    return 0
}
