--------------------------------------------------------------------------------
--                   Copyright, 2012-2017, Huawei Tech. Co., Ltd.
--                             All Rights Reserved
--------------------------------------------------------------------------------

----------------------------
------执行超时时间定义------
----------------------------
local ONE_MINUTE = 1;
local TWO_MINUTES = 2;
local THREE_MINUTES = 3;
local FIVE_MINUTES = 5;
local EIGHT_MINUTES = 8;
local TWELE_MINUTES = 12;
local FIFTEEN_MINUTES = 15;
local SIXTY_MINUTES = 60;

----定义全局变量：检查是否成功;默认为true
CHECK_FLAG = true;

function CheckDswareVersion()
    local version_is_R6=false
    local retry_time=10
    local ret=0

    for i = 1, retry_time do
        ret = System("/opt/omm/oma/atoms/precheck/lib/check_is_R6_version.sh", THREE_MINUTES);
        LogText(LL_INFO, "execute check_is_R6_version.sh ret = " .. ret);
        -- 6.2及其后的版本返回true
        if (ret == 0) then
            version_is_R6=false
            break
        elseif (ret == 1) then
            version_is_R6=true
            break
        else  --非0非1，System命令执行失败，重试
            System("sleep 1", 1)
        end
    end

    return version_is_R6
end

function GetAtomGroupTbl(AtomGroupName)
    return g_AtomGroupsTbl[AtomGroupName]
end


function ClearManagerOutPutJson()
    LogText(LL_INFO, "Enter ClearManagerOutPutJson atom...");
    return System("rm -f /var/log/dsware/FSM_*_upgrade_precheck*", ONE_MINUTE);
end

function ClearAgentOutPutJson()
    LogText(LL_INFO, "Enter ClearAgentOutPutJson atom...");
    return System("rm -f /var/log/dsware/FSA_*_upgrade_precheck*", ONE_MINUTE);
end

function CheckResultFlag()
    LogText(LL_INFO, "Enter CheckResultFlag atom...");
    if (CHECK_FLAG == false) then
        LogText(LL_ERROR, "CHECK_FLAG is false");
        return 1
    end
    return 0
end

function ManagerCollectInfo()
    LogText(LL_INFO, "Enter ManagerCollectInfo atom...");
    System("/opt/omm/oma/atoms/precheck/FSM_CollectInfo.sh", THREE_MINUTES);
    return 0
end

function AgentCollectInfo()
    LogText(LL_INFO, "Enter AgentCollectInfo atom...");
    System("/opt/omm/oma/atoms/precheck/FSA_CollectInfo.sh", THREE_MINUTES);
    return 0
end

--------------------------------------Comm check------------------------------

function CheckOmaStatus()
    LogText(LL_INFO, "Enter CheckOmaStatus atom... " .. "NODE_TYPE=" .. g_UpdState.ParamList["NODE_TYPE"]);
    local ret = System("/opt/omm/oma/atoms/precheck/Comm_check_oma_status.sh " .. g_UpdState.ParamList["NODE_TYPE"], THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute Comm_check_oma_status.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckEncMode()
    LogText(LL_INFO, "Enter CheckEncMode atom... " .. "NODE_TYPE=" .. g_UpdState.ParamList["NODE_TYPE"]);
    local ret = System("/opt/omm/oma/atoms/precheck/Comm_check_enc_mode.sh " .. g_UpdState.ParamList["NODE_TYPE"], TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute Comm_check_enc_mode.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckOmaMonitor()
    LogText(LL_INFO, "Enter CheckOmaMonitor atom... " .. "NODE_TYPE=" .. g_UpdState.ParamList["NODE_TYPE"]);
    local ret = System("/opt/omm/oma/atoms/precheck/Comm_check_oma_monitor.sh " .. g_UpdState.ParamList["NODE_TYPE"], TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute Comm_check_oma_monitor.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckSysConfig()
    LogText(LL_INFO, "Enter CheckSysConfig atom... " .. "NODE_TYPE=" .. g_UpdState.ParamList["NODE_TYPE"]);
    local ret = System("/opt/omm/oma/atoms/precheck/Comm_check_sys_config.sh " .. g_UpdState.ParamList["NODE_TYPE"], TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute Comm_check_sys_config.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckCipherCfg()
    LogText(LL_INFO, "Enter CheckCipherCfg atom..." .. "NODE_TYPE=" .. g_UpdState.ParamList["NODE_TYPE"]);
    local ret = System("/opt/omm/oma/atoms/precheck/Comm_check_cipher_cfg.sh " .. g_UpdState.ParamList["NODE_TYPE"], TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute Comm_check_cipher_cfg.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckBackupDir()
    LogText(LL_INFO, "Enter CheckBackupDir atom..." .. "NODE_TYPE=" .. g_UpdState.ParamList["NODE_TYPE"]);
    local ret = System("/opt/omm/oma/atoms/precheck/Comm_check_backup_dir.sh " .. g_UpdState.ParamList["NODE_TYPE"], TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute Comm_check_backup_dir.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

---------------------------FSM check--------------------------------

function PreCheckOmsStatus()
    LogText(LL_INFO, "Enter PreCheckOmsStatus atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_oms_status.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_oms_status.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckGateway()
    LogText(LL_INFO, "Enter PreCheckGateway atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_gateway.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_gateway.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckUid()
    LogText(LL_INFO, "Enter PreCheckUid atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_uid.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_uid.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckAuditLog()
    LogText(LL_INFO, "Enter PreCheckAuditLog atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_audit_log.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_audit_log.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end


function PreCheckFSMDeployFSA()
    LogText(LL_INFO, "Enter PreCheckFSMDeployFSA atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_deploy_FSA.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_deploy_FSA.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckFSMDiskSpcae()
    LogText(LL_INFO, "Enter PreCheckFSMDiskSpcae atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_disk_space.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_disk_space.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckDoublePlane()
    LogText(LL_INFO, "Enter PreCheckDoublePlane atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_double_plane.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_double_plane.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckLockFile()
    LogText(LL_INFO, "Enter PreCheckLockFile atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_lock_file.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_lock_file.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckLogSize()
    LogText(LL_INFO, "Enter PreCheckLogSize atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_log_size.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_log_size.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckOSLanguage()
    LogText(LL_INFO, "Enter PreCheckOSLanguage atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_OS_language.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_OS_language.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckPoolSpace()
    LogText(LL_INFO, "Enter PreCheckPoolSpace atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_pool_space.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_pool_space.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckSnapshotNum()
    LogText(LL_INFO, "Enter PreCheckSnapshotNum atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_snapshot_num.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_snapshot_num.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckNonRoleNode()
    LogText(LL_INFO, "Enter PreCheckNonRoleNode atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_non_role_node.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_non_role_node.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckAlarm()
    LogText(LL_INFO, "Enter PreCheckAlarm atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_alarm.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_alarm.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckEulerVersion()
    LogText(LL_INFO, "Enter PreCheckEulerVersion atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_euler_version.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_euler_version.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckSftpBackupService()
    LogText(LL_INFO, "Enter PreCheckSftpBackupService atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_sftp_backup_service.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_sftp_backup_service.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckV1R6C20SPC300belong()
    LogText(LL_INFO, "Enter PreCheckV1R6C20SPC300belong atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_V1R6C20SPC300_belong.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_V1R6C20SPC300_belong.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckSubDBpassword()
    LogText(LL_INFO, "Enter PreCheckSubDBpassword atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_sub_db_password.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_sub_db_password.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckManagerStorageIpSame()
    LogText(LL_INFO, "Enter PreCheckManagerStorageIpSame atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_manager_storage_ip_same.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_manager_storage_ip_same.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckRemoveIPC()
    LogText(LL_INFO, "Enter PreCheckRemoveIPC atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_removeIPC.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_removeIPC.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckSUSE11SP4()
    LogText(LL_INFO, "Enter PreCheckSUSE11SP4 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_iptables.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_iptables.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckStorageMedium()
    LogText(LL_INFO, "Enter PreCheckStorageMedium atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_storage_medium_incompatible.sh", THREE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_storage_medium_incompatible.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckIOPS()
    LogText(LL_INFO, "Enter PreCheckIOPS atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_iops.sh", FIVE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_iops.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckNVDIMM()
    LogText(LL_INFO, "Enter PreCheckNVDIMM atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_nvdim.sh", FIVE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_nvdim.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckOmsCertificate()
    LogText(LL_INFO, "Enter PreCheckOmsCertificate atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_oms_certificate.sh", ONE_MINUTE);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_oms_certificate.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckIBPingGroup()
    LogText(LL_INFO, "Enter PreCheckIBPingGroup atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_IB_ping_group.sh", ONE_MINUTE);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_IB_ping_group.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function PreCheckPoolSecuritylevel()
    LogText(LL_INFO, "Enter PreCheckPoolSecuritylevel atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_check_pool_security_level.sh", ONE_MINUTE);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_check_pool_security_level.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

---------------------------FSA check-------------------------------------

function CheckDsaConfig()
    LogText(LL_INFO, "Enter CheckDsaConfig atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_DSA_config.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_DSA_config.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckDsaProcess()
    LogText(LL_INFO, "Enter CheckDsaProcess atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_DSA_process.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_DSA_process.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckES3000V5DiskLife()
    LogText(LL_INFO, "Enter CheckES3000V5DiskLife atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_es3000v5_disk_life.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_es3000v5_disk_life.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckDstatusProcess()
    LogText(LL_INFO, "Enter CheckDstatusProcess atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_Dstatus_process.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_Dstatus_process.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckKVS()
    LogText(LL_INFO, "Enter CheckKVS atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_kvs.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_kvs.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckMDC()
    LogText(LL_INFO, "Enter CheckMDC atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_mdc.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_mdc.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckOSD()
    LogText(LL_INFO, "Enter CheckOSD atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_osd.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_osd.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckVBS()
    LogText(LL_INFO, "Enter CheckVBS atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_vbs.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_vbs.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckZK()
    LogText(LL_INFO, "Enter CheckZK atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_zk.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_zk.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckSmioScript()
    LogText(LL_INFO, "Enter CheckSmioScript atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_smio_script.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_smio_script.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckZkWithoutMdc()
    LogText(LL_INFO, "Enter CheckZkWithoutMdc atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_zk_without_mdc.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_zk_without_mdc.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckBlockstorage()
    LogText(LL_INFO, "Enter CheckBlockstorage atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_blockstorage.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_blockstorage.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckChkconfigInfo()
    LogText(LL_INFO, "Enter CheckChkconfigInfo atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_chkconfig_info.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_chkconfig_info.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end


function CheckClusterId()
    LogText(LL_INFO, "Enter CheckClusterId atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_cluster_id.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_cluster_id.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckCpuNum()
    LogText(LL_INFO, "Enter CheckCpuNum atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_cpu_num.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_cpu_num.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckFSADiskSpace()
    LogText(LL_INFO, "Enter CheckFSADiskSpace atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_disk_space.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_disk_space.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckFSADiskInfo()
    LogText(LL_INFO, "Enter CheckFSADiskInfo atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_disk_info.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_disk_info.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckEbackup()
    LogText(LL_INFO, "Enter CheckEbackup atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_ebackup.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_ebackup.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckIbBond()
    LogText(LL_INFO, "Enter CheckIbBond atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_ib_bond.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_ib_bond.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckIbDevs()
    LogText(LL_INFO, "Enter CheckIbDevs atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_ib_devs.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_ib_devs.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckIbLib()
    LogText(LL_INFO, "Enter CheckIbLib atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_ib_lib.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_ib_lib.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckIscsiTransportKey()
    LogText(LL_INFO, "Enter CheckIscsiTransportKey atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_iscsi_transport_key.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_iscsi_transport_key.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckJBOD()
    LogText(LL_INFO, "Enter CheckJBOD atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_JBOD.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_JBOD.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckMdcUrl()
    LogText(LL_INFO, "Enter CheckMdcUrl atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_mdc_url.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_mdc_url.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckOpenSMconf()
    LogText(LL_INFO, "Enter CheckOpenSMconf atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_openSM_conf.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_openSM_conf.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckOracle()
    LogText(LL_INFO, "Enter CheckOracle atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_oracle.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_oracle.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckPartTransportKey()
    LogText(LL_INFO, "Enter CheckPartTransportKey atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_part_transport_key.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_part_transport_key.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckStorageIp()
    LogText(LL_INFO, "Enter CheckStorageIp atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_storage_ip.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_storage_ip.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckThirdLib()
    LogText(LL_INFO, "Enter CheckThirdLib atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_third_lib.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_third_lib.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckThirdSan()
    LogText(LL_INFO, "Enter CheckThirdSan atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_third_San.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_third_San.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckV3SSDcard()
    LogText(LL_INFO, "Enter CheckV3SSDcard atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_V3_SSDcard.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_V3_SSDcard.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckZkCfg()
    LogText(LL_INFO, "Enter CheckZkCfg atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_zk_cfg.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_zk_cfg.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckMemoryRemain()
    LogText(LL_INFO, "Enter CheckMemoryRemain atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_memory_remain.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_memory_remain.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckFSARaid()
    LogText(LL_INFO, "Enter CheckFSARaid atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_raid.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_raid.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckMegaLog()
    LogText(LL_INFO, "Enter CheckMegaLog atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_mega_log.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_mega_log.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckPtBanlance()
    LogText(LL_INFO, "Enter CheckMemoryRemain atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_pt_banlance.sh", FIVE_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_pt_banlance.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckKernelVersion()
    LogText(LL_INFO, "Enter CheckKernelVersion atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_kernel_version.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_kernel_version.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckUVP()
    LogText(LL_INFO, "Enter CheckUVP atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_UVP.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_UVP.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckVbsMetaDataVersion()
    LogText(LL_INFO, "Enter CheckVbsMetaDataVersion atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_vbs_metadata_version.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_vbs_metadata_version.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

function CheckIBDriver()
    LogText(LL_INFO, "Enter CheckIBDriver atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_ib_driver.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_ib_driver.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查是否有获取scsi3锁
function CheckScsi3Lock()
    LogText(LL_INFO, "Enter CheckScsi3Lock atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_scsi3_lock.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_scsi3_lock.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查是否有开启连接监控
function CheckNFConntrack()
    LogText(LL_INFO, "Enter CheckNFConntrack atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_check_nf_conntrack.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_check_nf_conntrack.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

---------------------------commit-------------------------------------

function FSACommit()
    LogText(LL_INFO, "Enter FSACommit atom...");
    return System("/opt/omm/oma/atoms/precheck/FSA_Commit.sh", TWO_MINUTES);
end

function FSMCommit()
    LogText(LL_INFO, "Enter FSMCommit atom...");
    return System("/opt/omm/oma/atoms/precheck/FSM_Commit.sh", TWO_MINUTES);
end

-- 检查FSM与FSA版本是否一致
function Comm_1001()
    LogText(LL_INFO, "Enter Comm_1001 atom..." .. "NODE_TYPE=" .. g_UpdState.ParamList["NODE_TYPE"]);
    local ret = System("/opt/omm/oma/atoms/precheck/Comm_1001.sh " .. g_UpdState.ParamList["NODE_TYPE"], TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute Comm_1001.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- FusionStorage存储bond是否包含了预期的IB网口
function Comm_1003()
    LogText(LL_INFO, "Enter Comm_1003 atom..." .. "NODE_TYPE=" .. g_UpdState.ParamList["NODE_TYPE"]);
    local ret = System("/opt/omm/oma/atoms/precheck/Comm_1003.sh " .. g_UpdState.ParamList["NODE_TYPE"], TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute Comm_1003.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 数据库一体机巡检项
function Comm_1004()
    LogText(LL_INFO, "Enter Comm_1004 atom..." .. "NODE_TYPE=" .. g_UpdState.ParamList["NODE_TYPE"]);
    local ret = System("/opt/omm/oma/atoms/precheck/Comm_1004.sh " .. g_UpdState.ParamList["NODE_TYPE"], TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute Comm_1004.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查FSM和FSA加密通道是否加密
function Comm_1002()
    LogText(LL_INFO, "Enter Comm_1002 atom..." .. "NODE_TYPE=" .. g_UpdState.ParamList["NODE_TYPE"]);
    local ret = System("/opt/omm/oma/atoms/precheck/Comm_1002.sh " .. g_UpdState.ParamList["NODE_TYPE"], TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute Comm_1002.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查CVM虚拟机内核版本是否加入FusionStorage安装内核白名单
function FSM_1101()
    LogText(LL_INFO, "Enter FSM_1101 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1101.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1101.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查CVM虚拟机存储网卡LRO功能是否关闭
function FSM_1102()
    LogText(LL_INFO, "Enter FSM_1102 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1102.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1102.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 升级后修改管理IP风险规避
function FSM_1103()
    LogText(LL_INFO, "Enter FSM_1103 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1103.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1103.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end
-- 检查网关信息是否正确
function FSM_1105()
    LogText(LL_INFO, "Enter FSM_1105 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1105.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1105.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查目录剩余空间
function FSM_1106()
    LogText(LL_INFO, "Enter FSM_1106 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1106.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1106.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查/etc/logrotate.conf权限
function FSM_1107()
    LogText(LL_INFO, "Enter FSM_1107 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1107.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1107.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查HA状态
function FSM_1108()
    LogText(LL_INFO, "Enter FSM_1108 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1108.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1108.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查是否存在紧急、严重告警
function FSM_1109()
    LogText(LL_INFO, "Enter FSM_1109 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1109.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1109.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检测备份文件是否存在
function FSM_1110()
    LogText(LL_INFO, "Enter FSM_1110 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1110.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1110.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 信息收集
function FSM_1111()
    LogText(LL_INFO, "Enter FSM_1111 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1111.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1111.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- FCC两个虚拟机在FusionCompute页面是否使用默认名称FCC01与FCC02
function FSM_1112()
    LogText(LL_INFO, "Enter FSM_1112 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1112.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1112.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查存储池剩余空间
function FSM_1113()
    LogText(LL_INFO, "Enter FSM_1113 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1113.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1113.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查FCC证书过期时间
function FSM_1114()
    LogText(LL_INFO, "Enter FSM_1114 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSM_1114.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSM_1114.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查g_net_crc_check_flag参数是否一致
function FSA_1202()
    LogText(LL_INFO, "Enter FSA_1202 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1202.sh ", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1202.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 排除DBN节点udisks内存泄漏风险
function FSA_1203()
    LogText(LL_INFO, "Enter FSA_1203 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1203.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1203.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查DBN节点hung_task_panic设置
function FSA_1204()
    LogText(LL_INFO, "Enter FSA_1204 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1204.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1204.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查数据库节点操作系统版本
function FSA_1205()
    LogText(LL_INFO, "Enter FSA_1205 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1205.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1205.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查IB网络MTU值
function FSA_1206()
    LogText(LL_INFO, "Enter FSA_1206 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1206.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1206.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end


-- 检查IB绑定网卡配置
function FSA_1207()
    LogText(LL_INFO, "Enter FSA_1207 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1207.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1207.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查服务器硬件类型
function FSA_1208()
    LogText(LL_INFO, "Enter FSA_1208 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1208.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1208.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查opensm强制扫描功能是否开启
function FSA_1209()
    LogText(LL_INFO, "Enter FSA_1209 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1209.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1209.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查服务器硬件类型
function FSA_1210()
    LogText(LL_INFO, "Enter FSA_1210 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1210.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1210.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查FusionCompute主机中fusioncube_Irq_Affinity.sh的文件属性
function FSA_1211()
    LogText(LL_INFO, "Enter FSA_1211 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1211.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1211.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查CSSD能容忍不能访问Voting Disks的时间
function FSA_1212()
    LogText(LL_INFO, "Enter FSA_1212 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1212.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1212.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查Oracle ASM心跳超时时间(_asm_hbeatiowait)
function FSA_1213()
    LogText(LL_INFO, "Enter FSA_1213 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1213.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1213.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查DBN节点sysctl.conf文件参数
function FSA_1214()
    LogText(LL_INFO, "Enter FSA_1214 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1214.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1214.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查DBN节点udevd磁盘配置
function FSA_1215()
    LogText(LL_INFO, "Enter FSA_1215 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1215.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1215.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 数据库节点挂载了FusionStorage卷做为文件系统，调整hang返回时间
function FSA_1216()
    LogText(LL_INFO, "Enter FSA_1216 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1216.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1216.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查是否存在第三方GPU驱动
function FSA_1217()
    LogText(LL_INFO, "Enter FSA_1217 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1217.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1217.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查融合节点的SSD驱动类型
function FSA_1218()
    LogText(LL_INFO, "Enter FSA_1218 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1218.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1218.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查getusedisk脚本导致dsware_agent异常重启问题
function FSA_1219()
    LogText(LL_INFO, "Enter FSA_1219 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1219.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1219.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查IB驱动固件版本
function FSA_1220()
    LogText(LL_INFO, "Enter FSA_1220 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1220.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1220.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查message日志
function FSA_1221()
    LogText(LL_INFO, "Enter FSA_1221 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1221.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1221.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end

-- 检查线缆降速，或线缆存在重传
function FSA_1222()
    LogText(LL_INFO, "Enter FSA_1222 atom...");
    local ret = System("/opt/omm/oma/atoms/precheck/FSA_1222.sh", TWO_MINUTES);
    if(ret ~= 0) then
        LogText(LL_ERROR, "execute FSA_1222.sh exit:" .. ret);
        CHECK_FLAG = false;
    end
    return ret;
end
-------------------------------------------------------------------------------
--------------------------------- AtomGroup表定义 start -----------------------
-------------------------------------------------------------------------------

-- 原子组表定义 (该表每次执行原子组时从lua文件加载一次)
g_AtomGroupsTbl =
{

    ManagerPreCheck =
    {
        entry = "ClearManagerOutPutJson",
        ClearManagerOutPutJson =
        {
            func = ClearManagerOutPutJson,
            retcode = {[0] = "ManagerCollectInfo", ['other'] = "ManagerCollectInfo"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        ManagerCollectInfo =
        {
            func = ManagerCollectInfo,
            retcode = {[0] = "CheckEncMode", ['other'] = "CheckEncMode"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckEncMode =
        {
            func = CheckEncMode,
            retcode = {[0] = "CheckOmaStatus", ['other'] = "CheckOmaStatus"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckOmaStatus =
        {
            func = CheckOmaStatus,
            retcode = {[0] = "CheckOmaMonitor", ['other'] = "CheckOmaMonitor"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckOmaMonitor =
        {
            func = CheckOmaMonitor,
            retcode = {[0] = "CheckSysConfig", ['other'] = "CheckSysConfig"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckSysConfig =
        {
            func = CheckSysConfig,
            retcode = {[0] = "CheckCipherCfg", ['other'] = "CheckCipherCfg"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckCipherCfg =
        {
            func = CheckCipherCfg,
            retcode = {[0] = "CheckBackupDir", ['other'] = "CheckBackupDir"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckBackupDir =
        {
            func = CheckBackupDir,
            retcode = {[0] = "PreCheckOmsStatus", ['other'] = "PreCheckOmsStatus"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckOmsStatus =
        {
            func = PreCheckOmsStatus,
            retcode = {[0] = "PreCheckOmsCertificate", ['other'] = "PreCheckOmsCertificate"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckOmsCertificate =
        {
            func = PreCheckOmsCertificate,
            retcode = {[0] = "PreCheckGateway", ['other'] = "PreCheckGateway"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckGateway =
        {
            func = PreCheckGateway,
            retcode = {[0] = "PreCheckIBPingGroup", ['other'] = "PreCheckIBPingGroup"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckIBPingGroup = {
            func = PreCheckIBPingGroup,
            retcode = {[0] = "PreCheckUid", ['other'] = "PreCheckUid"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckUid =
        {
            func = PreCheckUid,
            retcode = {[0] = "PreCheckAuditLog", ['other'] = "PreCheckAuditLog"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckAuditLog =
        {
            func = PreCheckAuditLog,
            retcode = {[0] = "PreCheckFSMDeployFSA", ['other'] = "PreCheckFSMDeployFSA"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckFSMDeployFSA =
        {
            func = PreCheckFSMDeployFSA,
            retcode = {[0] = "PreCheckFSMDiskSpcae", ['other'] = "PreCheckFSMDiskSpcae"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckFSMDiskSpcae =
        {
            func = PreCheckFSMDiskSpcae,
            retcode = {[0] = "PreCheckDoublePlane", ['other'] = "PreCheckDoublePlane"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckDoublePlane =
        {
            func = PreCheckDoublePlane,
            retcode = {[0] = "PreCheckLockFile", ['other'] = "PreCheckLockFile"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckLockFile =
        {
            func = PreCheckLockFile,
            retcode = {[0] = "PreCheckLogSize", ['other'] = "PreCheckLogSize"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckLogSize =
        {
            func = PreCheckLogSize,
            retcode = {[0] = "PreCheckOSLanguage", ['other'] = "PreCheckOSLanguage"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckOSLanguage =
        {
            func = PreCheckOSLanguage,
            retcode = {[0] = "PreCheckPoolSpace", ['other'] = "PreCheckPoolSpace"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckPoolSpace =
        {
            func = PreCheckPoolSpace,
            retcode = {[0] = "PreCheckSnapshotNum", ['other'] = "PreCheckSnapshotNum"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckSnapshotNum =
        {
            func = PreCheckSnapshotNum,
            retcode = {[0] = "PreCheckNonRoleNode", ['other'] = "PreCheckNonRoleNode"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckNonRoleNode =
        {
            func = PreCheckNonRoleNode,
            retcode = {[0] = "PreCheckAlarm", ['other'] = "PreCheckAlarm"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckAlarm =
        {
            func = PreCheckAlarm,
            retcode = {[0] = "PreCheckEulerVersion", ['other'] = "PreCheckEulerVersion"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckEulerVersion =
        {
            func = PreCheckEulerVersion,
            retcode = {[0] = "PreCheckSftpBackupService", ['other'] = "PreCheckSftpBackupService"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckSftpBackupService =
        {
            func = PreCheckSftpBackupService,
            retcode = {[0] = "PreCheckV1R6C20SPC300belong", ['other'] = "PreCheckV1R6C20SPC300belong"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckV1R6C20SPC300belong =
        {
            func = PreCheckV1R6C20SPC300belong,
            retcode = {[0] = "PreCheckSubDBpassword", ['other'] = "PreCheckSubDBpassword"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckSubDBpassword =
        {
            func = PreCheckSubDBpassword,
            retcode = {[0] = "PreCheckManagerStorageIpSame", ['other'] = "PreCheckManagerStorageIpSame"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckManagerStorageIpSame =
        {
            func = PreCheckManagerStorageIpSame,
            retcode = {[0] = "PreCheckRemoveIPC", ['other'] = "PreCheckRemoveIPC"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckRemoveIPC =
        {
            func = PreCheckRemoveIPC,
            retcode = {[0] = "PreCheckSUSE11SP4", ['other'] = "PreCheckSUSE11SP4"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckSUSE11SP4 =
        {
            func = PreCheckSUSE11SP4,
            retcode = {[0] = "PreCheckStorageMedium", ['other'] = "PreCheckStorageMedium"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckStorageMedium =
        {
            func = PreCheckStorageMedium,
            retcode = {[0] = "PreCheckIOPS", ['other'] = "PreCheckIOPS"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckIOPS =
        {
            func = PreCheckIOPS,
            retcode = {[0] = "PreCheckNVDIMM", ['other'] = "PreCheckNVDIMM"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckNVDIMM =
        {
            func = PreCheckNVDIMM,
            retcode = {[0] = "PreCheckPoolSecuritylevel", ['other'] = "PreCheckPoolSecuritylevel"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        PreCheckPoolSecuritylevel =
        {
            func = PreCheckPoolSecuritylevel,
            retcode = {[0] = "Comm_1001", ['other'] = "Comm_1001"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        Comm_1001 =
        {
            func = Comm_1001,
            retcode = {[0] = "Comm_1002", ['other'] = "Comm_1002"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        Comm_1002 =
        {
            func = Comm_1002,
            retcode = {[0] = "Comm_1003", ['other'] = "Comm_1003"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        Comm_1003 =
        {
            func = Comm_1003,
            retcode = {[0] = "Comm_1004", ['other'] = "Comm_1004"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        Comm_1004 =
        {
            func = Comm_1004,
            retcode = {[0] = "FSM_1101", ['other'] = "FSM_1101"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1101 =
        {
            func = FSM_1101,
            retcode = {[0] = "FSM_1102", ['other'] = "FSM_1102"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1102 =
        {
            func = FSM_1102,
            retcode = {[0] = "FSM_1103", ['other'] = "FSM_1103"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1103 =
        {
            func = FSM_1103,
            retcode = {[0] = "FSM_1105", ['other'] = "FSM_1105"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1105 =
        {
            func = FSM_1105,
            retcode = {[0] = "FSM_1106", ['other'] = "FSM_1106"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1106 =
        {
            func = FSM_1106,
            retcode = {[0] = "FSM_1107", ['other'] = "FSM_1107"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1107 =
        {
            func = FSM_1107,
            retcode = {[0] = "FSM_1108", ['other'] = "FSM_1108"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1108 =
        {
            func = FSM_1108,
            retcode = {[0] = "FSM_1109", ['other'] = "FSM_1109"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1109 =
        {
            func = FSM_1109,
            retcode = {[0] = "FSM_1110", ['other'] = "FSM_1110"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1110 =
        {
            func = FSM_1110,
            retcode = {[0] = "FSM_1111", ['other'] = "FSM_1111"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1111 =
        {
            func = FSM_1111,
            retcode = {[0] = "FSM_1112", ['other'] = "FSM_1112"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1112 =
        {
            func = FSM_1112,
            retcode = {[0] = "FSM_1113", ['other'] = "FSM_1113"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1113 =
        {
            func = FSM_1113,
            retcode = {[0] = "FSM_1114", ['other'] = "FSM_1114"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSM_1114 =
        {
            func = FSM_1114,
            retcode = {[0] = "CheckResultFlag", ['other'] = "CheckResultFlag"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckResultFlag =
        {
            func = CheckResultFlag,
            retcode = {[0] = "#SuccExit", ['other'] = "#SuccRbk"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
    },

    AgentPreCheck =
    {
        entry = "ClearAgentOutPutJson",
        ClearAgentOutPutJson =
        {
            func = ClearAgentOutPutJson,
            retcode = {[0] = "AgentCollectInfo", ['other'] = "AgentCollectInfo"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        AgentCollectInfo =
        {
            func = AgentCollectInfo,
            retcode = {[0] = "CheckEncMode", ['other'] = "CheckEncMode"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckEncMode =
        {
            func = CheckEncMode,
            retcode = {[0] = "CheckOmaStatus", ['other'] = "CheckOmaStatus"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckOmaStatus =
        {
            func = CheckOmaStatus,
            retcode = {[0] = "CheckOmaMonitor", ['other'] = "CheckOmaMonitor"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckOmaMonitor =
        {
            func = CheckOmaMonitor,
            retcode = {[0] = "CheckSysConfig", ['other'] = "CheckSysConfig"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckSysConfig =
        {
            func = CheckSysConfig,
            retcode = {[0] = "CheckCipherCfg", ['other'] = "CheckCipherCfg"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckCipherCfg =
        {
            func = CheckCipherCfg,
            retcode = {[0] = "CheckBackupDir", ['other'] = "CheckBackupDir"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckBackupDir =
        {
            func = CheckBackupDir,
            retcode = {[0] = "CheckDsaConfig", ['other'] = "CheckDsaConfig"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckDsaConfig =
        {
            func = CheckDsaConfig,
            retcode = {[0] = "CheckDsaProcess", ['other'] = "CheckDsaProcess"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckDsaProcess =
        {
            func = CheckDsaProcess,
            retcode = {[0] = "CheckES3000V5DiskLife", ['other'] = "CheckES3000V5DiskLife"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckES3000V5DiskLife =
        {
            func = CheckES3000V5DiskLife,
            retcode = {[0] = "CheckDstatusProcess", ['other'] = "CheckDstatusProcess"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckDstatusProcess =
        {
            func = CheckDstatusProcess,
            retcode = {[0] = "CheckKVS", ['other'] = "CheckKVS"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckKVS =
        {
            func = CheckKVS,
            retcode = {[0] = "CheckMDC", ['other'] = "CheckMDC"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckMDC =
        {
            func = CheckMDC,
            retcode = {[0] = "CheckOSD", ['other'] = "CheckOSD"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckOSD =
        {
            func = CheckOSD,
            retcode = {[0] = "CheckVBS", ['other'] = "CheckVBS"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckVBS =
        {
            func = CheckVBS,
            retcode = {[0] = "CheckZK", ['other'] = "CheckZK"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckZK =
        {
            func = CheckZK,
            retcode = {[0] = "CheckSmioScript", ['other'] = "CheckSmioScript"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckSmioScript =
        {
            func = CheckSmioScript,
            retcode = {[0] = "CheckZkWithoutMdc", ['other'] = "CheckZkWithoutMdc"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckZkWithoutMdc =
        {
            func = CheckZkWithoutMdc,
            retcode = {[0] = "CheckBlockstorage", ['other'] = "CheckBlockstorage"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckBlockstorage =
        {
            func = CheckBlockstorage,
            retcode = {[0] = "CheckChkconfigInfo", ['other'] = "CheckChkconfigInfo"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckChkconfigInfo =
        {
            func = CheckChkconfigInfo,
            retcode = {[0] = "CheckClusterId", ['other'] = "CheckClusterId"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckClusterId =
        {
            func = CheckClusterId,
            retcode = {[0] = "CheckCpuNum", ['other'] = "CheckCpuNum"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckCpuNum =
        {
            func = CheckCpuNum,
            retcode = {[0] = "CheckFSADiskSpace", ['other'] = "CheckFSADiskSpace"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckFSADiskSpace =
        {
            func = CheckFSADiskSpace,
            retcode = {[0] = "CheckFSADiskInfo", ['other'] = "CheckFSADiskInfo"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckFSADiskInfo=
        {
            func = CheckFSADiskInfo,
            retcode = {[0] = "CheckEbackup", ['other'] = "CheckEbackup"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckEbackup =
        {
            func = CheckEbackup,
            retcode = {[0] = "CheckIbBond", ['other'] = "CheckIbBond"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckIbBond =
        {
            func = CheckIbBond,
            retcode = {[0] = "CheckIbDevs", ['other'] = "CheckIbDevs"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckIbDevs =
        {
            func = CheckIbDevs,
            retcode = {[0] = "CheckIbLib", ['other'] = "CheckIbLib"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckIbLib =
        {
            func = CheckIbLib,
            retcode = {[0] = "CheckIscsiTransportKey", ['other'] = "CheckIscsiTransportKey"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckIscsiTransportKey =
        {
            func = CheckIscsiTransportKey,
            retcode = {[0] = "CheckJBOD", ['other'] = "CheckJBOD"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckJBOD =
        {
            func = CheckJBOD,
            retcode = {[0] = "CheckMdcUrl", ['other'] = "CheckMdcUrl"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckMdcUrl =
        {
            func = CheckMdcUrl,
            retcode = {[0] = "CheckOpenSMconf", ['other'] = "CheckOpenSMconf"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckOpenSMconf =
        {
            func = CheckOpenSMconf,
            retcode = {[0] = "CheckOracle", ['other'] = "CheckOracle"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckOracle =
        {
            func = CheckOracle,
            retcode = {[0] = "CheckPartTransportKey", ['other'] = "CheckPartTransportKey"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckPartTransportKey =
        {
            func = CheckPartTransportKey,
            retcode = {[0] = "CheckStorageIp", ['other'] = "CheckStorageIp"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckStorageIp =
        {
            func = CheckStorageIp,
            retcode = {[0] = "CheckThirdLib", ['other'] = "CheckThirdLib"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckThirdLib =
        {
            func = CheckThirdLib,
            retcode = {[0] = "CheckThirdSan", ['other'] = "CheckThirdSan"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckThirdSan =
        {
            func = CheckThirdSan,
            retcode = {[0] = "CheckV3SSDcard", ['other'] = "CheckV3SSDcard"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckV3SSDcard =
        {
            func = CheckV3SSDcard,
            retcode = {[0] = "CheckZkCfg", ['other'] = "CheckZkCfg"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckZkCfg =
        {
            func = CheckZkCfg,
            retcode = {[0] = "CheckMemoryRemain", ['other'] = "CheckMemoryRemain"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckMemoryRemain =
        {
            func = CheckMemoryRemain,
            retcode = {[0] = "CheckFSARaid", ['other'] = "CheckFSARaid"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckFSARaid =
        {
            func = CheckFSARaid,
            retcode = {[0] = "CheckMegaLog", ['other'] = "CheckMegaLog"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckMegaLog =
        {
            func = CheckMegaLog,
            retcode = {[0] = "CheckPtBanlance", ['other'] = "CheckPtBanlance"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckPtBanlance=
        {
            func = CheckPtBanlance,
            retcode = {[0] = "CheckKernelVersion", ['other'] = "CheckKernelVersion"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckKernelVersion=
        {
            func = CheckKernelVersion,
            retcode = {[0] = "CheckUVP", ['other'] = "CheckUVP"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckUVP=
        {
            func = CheckUVP,
            retcode = {[0] = "CheckVbsMetaDataVersion", ['other'] = "CheckVbsMetaDataVersion"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckVbsMetaDataVersion=
        {
            func = CheckVbsMetaDataVersion,
            retcode = {[0] = "CheckIBDriver", ['other'] = "CheckIBDriver"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckIBDriver=
        {
            func = CheckIBDriver,
            retcode = {[0] = "CheckScsi3Lock", ['other'] = "CheckScsi3Lock"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckScsi3Lock=
        {
            func = CheckScsi3Lock,
            retcode = {[0] = "CheckNFConntrack", ['other'] = "CheckNFConntrack"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckNFConntrack=
        {
            func = CheckNFConntrack,
            retcode = {[0] = "Comm_1001", ['other'] = "Comm_1001"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        Comm_1001 =
        {
            func = Comm_1001,
            retcode = {[0] = "Comm_1002", ['other'] = "Comm_1002"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        Comm_1002 =
        {
            func = Comm_1002,
            retcode = {[0] = "Comm_1003", ['other'] = "Comm_1003"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        Comm_1003 =
        {
            func = Comm_1003,
            retcode = {[0] = "Comm_1004", ['other'] = "Comm_1004"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        Comm_1004 =
        {
            func = Comm_1004,
            retcode = {[0] = "FSA_1202", ['other'] = "FSA_1202"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1202 =
        {
            func = FSA_1202,
            retcode = {[0] = "FSA_1203", ['other'] = "FSA_1203"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1203 =
        {
            func = FSA_1203,
            retcode = {[0] = "FSA_1204", ['other'] = "FSA_1204"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1204 =
        {
            func = FSA_1204,
            retcode = {[0] = "FSA_1205", ['other'] = "FSA_1205"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1205 =
        {
            func = FSA_1205,
            retcode = {[0] = "FSA_1206", ['other'] = "FSA_1206"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1206 =
        {
            func = FSA_1206,
            retcode = {[0] = "FSA_1207", ['other'] = "FSA_1207"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1207 =
        {
            func = FSA_1207,
            retcode = {[0] = "FSA_1208", ['other'] = "FSA_1208"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1208 =
        {
            func = FSA_1208,
            retcode = {[0] = "FSA_1209", ['other'] = "FSA_1209"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1209 =
        {
            func = FSA_1209,
            retcode = {[0] = "FSA_1210", ['other'] = "FSA_1210"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1210 =
                {
                    func = FSA_1210,
                    retcode = {[0] = "FSA_1211", ['other'] = "FSA_1211"},
                    retstate = {[0] = "#Succ"},
                    progress = 100,
                },
        FSA_1211 =
        {
            func = FSA_1211,
            retcode = {[0] = "FSA_1212", ['other'] = "FSA_1212"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1212 =
        {
            func = FSA_1212,
            retcode = {[0] = "FSA_1213", ['other'] = "FSA_1213"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1213 =
        {
            func = FSA_1213,
            retcode = {[0] = "FSA_1214", ['other'] = "FSA_1214"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1214 =
        {
            func = FSA_1214,
            retcode = {[0] = "FSA_1215", ['other'] = "FSA_1215"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1215 =
        {
            func = FSA_1215,
            retcode = {[0] = "FSA_1216", ['other'] = "FSA_1216"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1216 =
        {
            func = FSA_1216,
            retcode = {[0] = "FSA_1217", ['other'] = "FSA_1217"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1217 =
        {
            func = FSA_1217,
            retcode = {[0] = "FSA_1218", ['other'] = "FSA_1218"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1218 =
        {
            func = FSA_1218,
            retcode = {[0] = "FSA_1219", ['other'] = "FSA_1219"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1219 =
        {
            func = FSA_1219,
            retcode = {[0] = "FSA_1220", ['other'] = "FSA_1220"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1220 =
        {
            func = FSA_1220,
            retcode = {[0] = "FSA_1221", ['other'] = "FSA_1221"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        FSA_1221 =
        {
            func = FSA_1221,
            retcode = {[0] = "FSA_1222", ['other'] = "FSA_1222"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
         FSA_1222 =
        {
            func = FSA_1222,
            retcode = {[0] = "CheckResultFlag", ['other'] = "CheckResultFlag"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
        CheckResultFlag =
        {
            func = CheckResultFlag,
            retcode = {[0] = "#SuccExit", ['other'] = "#SuccRbk"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
    },

    FSMCommit =
    {
        entry = "FSMCommit",
        FSMCommit =
        {
            func = FSMCommit,
            retcode = {[0] = "#SuccExit", ['other'] = "#SuccRbk"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
    },

    FSACommit =
    {
        entry = "FSACommit",
        FSACommit =
        {
            func = FSACommit,
            retcode = {[0] = "#SuccExit", ['other'] = "#SuccRbk"},
            retstate = {[0] = "#Succ"},
            progress = 100,
        },
    },

}

-------------------------------------------------------------------------------
--------------------------------- AtomGroup表定义 end -------------------------
-------------------------------------------------------------------------------
