--------------------------------------------------------------------------------
--                   Copyright, 2012-2017, Huawei Tech. Co., Ltd.
--                             All Rights Reserved
--------------------------------------------------------------------------------
-- Project Code    : FusionStorage BLock
-- File name       : upd_flows.lua
-- Description     : FusionStorage Serverļ
--------------------------------------------------------------------------------

-- 
g_PRO_Const =
{
    TASK_TYPE_PRECHECK = "Precheck",
    TASK_TYPE_UPDATE = "Update",
    TASK_TYPE_ROLLBACK = "Rollback",
    TASK_TYPE_COMMIT = "Commit",
    TASK_TYPE_ACTIVE = "Active",
    TASK_TYPE_DEACTIVE = "deActive",
    ["Precheck"] = 0,
    ["Update"] = 1,
    ["Rollback"] = 2,
    ["Commit"] = 3,
    ["Active"] = 4,
    ["deActive"] = 5,

    FLOW_NAME_PRECHECK = "PRECHECK",
    FLOW_NAME_UPDATE = "UPDATE",
    FLOW_NAME_ROLLBACK = "ROLLBACK",
    FLOW_NAME_COMMIT = "COMMIT",
    FLOW_NAME_ACTIVE = "ACTIVE",
    FLOW_NAME_DEACTIVE = "DEACTIVE",
    ["PRECHECK"] = 0,
    ["UPDATE"] = 1,
    ["ROLLBACK"] = 2,
    ["COMMIT"] = 3,
    ["ACTIVE"] = 4,
    ["DEACTIVE"] = 5,

    NODE_TYPE_MANAGER = "Manager",
    NODE_TYPE_AGENT = "Agent",
    ["Manager"] = 0,
    ["Agent"] = 1,

    LOGIC_NODE_TYPE_NODE = "NONE",
    LOGIC_NODE_TYPE_FSM = "FSM",
    LOGIC_NODE_TYPE_MDC = "MDC",
    LOGIC_NODE_TYPE_OSD = "OSD",
    LOGIC_NODE_TYPE_CLIENT = "Client",
    LOGIC_NODE_TYPE_ALL = "ALL",
    ["FSM"] = 0,
    ["MDC"] = 1,
    ["OSD"] = 2,
    ["Client"] = 3,
    ["ALL"] = 4,

    DSWARE_SERVICE_STOPPED = "stopped",
    DSWARE_SERVICE_STARTED ="started",

    UPGRADE_MODE_ONLINE = "online",
    UPGRADE_MODE_OFFLINE ="offline",
    ["online"] = 0,
    ["offline"] = 1,

    CUR_NODE_LIST_KEY_FSM = "fsm",
    CUR_NODE_LIST_KEY_MDC = "mdc",
    CUR_NODE_LIST_KEY_CLIENT = "client",
    CUR_NODE_LIST_KEY_OSD = "osd",

    CUR_NODE_LIST_NODE_NUM_MAX = 1000,

    CODE_OTHER_NODE_FAILED = "5300",
    CODE_CLUSTER_STATUS_ABNORMAL = "5301",
    CODE_POOL_STATUS_ABNORMAL = "5302",
    CODE_VOLUME_IS_ATTACHED = "5303",
    CODE_MDC_BIND = "5304",
    CODE_BATCH_INNER_ERROR = "5305",
    CODE_SERVICE_STOPPED = "5306",
    CODE_SERVICE_STARTED = "5307",
    CODE_CHECK_INNER_ERROR = "5308",
    CODE_GENERATE_CONFIG_ERROR = "5309",
    CODE_NEED_ROLLBACK_CLIENT_METADATA = "5310",
    CODE_NEED_ROLLBACK_MESSAGE_VERSION = "5311",
    CODE_NEED_UPGRADE_CLIENT_METADATA = "5312",
    CODE_NEED_UPGRADE_MESSAGE_VERSION = "5313",
    CODE_NOT_SUPPORT_MULTI_VBS_OFFLINE = "5314",
    CODE_CHECK_UPGRADE_MODE_FAIL = "5057",
    CODE_BACKUP_METADATA_FAIL = "5315",
    CODE_SELECT_ALL_ZK_OFFLINE = "5316",
    MAX_NODE_INFILE = 500,
    CLIENT_WINDOW_SIZE = 500,
    NODE_NUMBER_PER_SUBLIST = 50,
    OP_NOT_EXECUTED = 0,
    OP_BE_EXECUTED = 1,
    CODE_BASE_OFFSET = 51000
}

-- Flowִ״̬Ϣ
-- NodeList=ExecNodeList+SuccNodeList+FailNodeList+AutoRbkSuccNodeList+WaitingNodeList
-- صCurNodeListӦǵ÷֮ǰWaitingNodeListӼбвظĽڵ
g_PRO_UpdState =
{
    TaskControl = "",       -- 
                            -- continue, ִ,   Flow Ч(ΪִеFlow), CurNodeList Ч(ΪִFlowĽڵ), WaitingNodeList Ч
                            -- pause, ͣ,          Flow Ч, CurNodeList Ч, WaitingNodeList Ч(:洢״̬δִOSDڵ㲻ִ)
                            -- succStop, ɹ,   Flow Ч, CurNodeList Ч, WaitingNodeList Ч
                            -- failStop, ʧܽ,   Flow Ч, CurNodeList Ч, WaitingNodeList Ч(:FSMʧܵµȴִMDCڵ㲻ִ)
    NodeType = "",          -- ǰڵĽڵ
    LogicNodeType = "",     -- ǰڵ߼ڵ
    UpgradeMode = "",       -- ǰڵģʽ
    SyncFlow = false,       -- ǰڵִFlowʱǷִͬFlowAG
    BindFlagForUpdate = false,       -- ǰڵִFlowʱǷִ
    BindFlagForAutoRollback = false,       -- ǰڵִFlowʱǷִԶ
    BindFlagForRollback = false,       -- ǰڵִFlowʱǷִл
    
    -- --start--
    Flow = "",               -- Flow
    NodeList = {},          -- Flowнڵб
                            -- {[ip*100+tp*10+ltp]={ip(IPַ),tp(ڵ),ltp(߼ڵ),st(״̬),rt(ǰԭִн),bt(ʼʱ),et(ʱ),pr(), ag(ԭ)},{}}
    ExecNodeList = {},      -- ǰִеĽڵб
                            -- {[ip*100+tp*10+ltp]={ip(ڵIP),tp(ڵ),ltp(߼ڵ),code()},{}}
    SuccNodeList = {},      -- FlowִгɹĽڵб
                            -- {[ip*100+tp*10+ltp]={ip(IPַ),tp(ڵ),ltp(߼ڵ),rt(ԭִн)}, {}}
    FailNodeList = {},      -- FlowִʧܵĽڵб(AutoRbkSuccNodeListĽڵ)
                            -- {[ip*100+tp*10+ltp]={ip(IPַ),tp(ڵ),ltp(߼ڵ),rt(ԭִн)}, {}}
    AutoRbkSuccNodeList = {}, -- FlowִʧܵԶ˳ɹĽڵб
    TaskInfo = {},
    -- --end--
    
    CurNodeList = {},       -- ִĽڵбɲƷip,tp,ltp
                            -- {[ip*100+tp*10+ltp]={ip(IPַ),tp(ڵ),ltp(߼ڵ),rt(ԭִн)}, {}}
                            -- Ϊбһ߼ڵͻ֣ڶΪkey
                            -- һֶΣomm_resume
                            -- ڵ㲻g_PRO_UpdState.CurNodeListNodelistнڵ״̬ΪִУҪڵ¼뵽curnodelistִ
                            -- ڶֶΣCurInfo
                            -- NeedWaitAG һҪִͬеAG
                            -- NeedWait ȴִͬAGĽڵ
                            -- SyncExecAG ִͬеAGExcuteNodeType AtomGroupName timeout
                            -- SyncEnd 1 ʾǰͬAGִ
                            -- ExeCount ManagerִеĽڵֻһ
                            -- AtuoRbk Ƿʧܻ
    WaitingNodeList = {},   -- FlowʱִFlowĽڵб, TaskControl=pause  failedStop ʱЧ
                            -- {[ip*100+tp*10+ltp]={ip(ڵIP),tp(ڵ),ltp(߼ڵ),code()},{}}
    UpdParamList = {},      -- ǰڵĲб,
    ExecLogicType = g_PRO_Const.LOGIC_NODE_TYPE_NODE,     -- ǰִб߼ڵͣĽڵͱִеıһ
}

-- ȥԼԪݱݽ棬־û
g_ExecResult =
{
    CheckUpgradeMode = g_PRO_Const.OP_NOT_EXECUTED,
    CheckServiceStatus = g_PRO_Const.OP_NOT_EXECUTED,
    ActiveUpgrade = g_PRO_Const.OP_NOT_EXECUTED,
    deActiveUpgrade = g_PRO_Const.OP_NOT_EXECUTED,
    FSM =
    {
        BackUpMngtMeta = g_PRO_Const.OP_NOT_EXECUTED,
    },
    MDC =
    {
        BackUpMngtMeta = g_PRO_Const.OP_NOT_EXECUTED,
    },
    OSD =
    {
        BackUpMngtMeta = g_PRO_Const.OP_NOT_EXECUTED,
    },
    CLIENT =
    {
        BackUpMngtMeta = g_PRO_Const.OP_NOT_EXECUTED,
    },
}

--FSMδg_CurNodeListClientڵ㣬´ηֱʹ
g_RemainClientNode = {};

--================== UPD Framwork Const ========================================
-- ATOM_GROUP_EXEC_RET_INIT = -1;    --ԭִн: δִ
-- ڴг
--================== UPD Framwork Const ========================================


--================== UPD Framwork API ==========================================
--------------------------------------------------------------------------------
-- Func Name       : LogText(level, message)
-- Description     : ־ӡ
-- Caution         : עLuaʹ
-- Input           : level: ־, LL_DEBUG, LL_INFO, LL_WARN, LL_ERROR, LL_NOTICE
--                   message: ӡϢ
-- Output          : 
-- Return          : 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : System(cmd, timeout)
-- Description     : ִϵͳ
-- Caution         : עLuaʹ
-- Input           : cmd: ַ
--                   timeout: ִгʱʱ䣬λΪ
-- Output          : 
-- Return          : 0-127 -- ӽ̵ķֵ 128 -- ӽ쳣
--                   129 -- ӽ̳ʱ 130 -- ڲ
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- TaskʼϢ(UPDSñڵݶ)
-- Ϣ߷͵йвı䣬OMMܸ
--  g_TaskInfo =
--  {
--      ID = "",        -- IDUPDWSĽӿߴݵrequestִйв
--      TaskType = "",  -- ͣUPDWSĽӿߴݵrequestִйв
--      Nodes = {},     -- ĲUPDWSĽӿߴݵrequestִйв
--                      -- {{NodeList="192.168.40.7,192.1168.40.8,192.168.40.9", NodeType="Agent", LogicNodeType="MDC", UpgradeMode="online", AutoBatch="true", ParamList="key1=value1,key2=value2"},{}}
--                      -- LogicNodeType ߼ڵ FSMMDCOSDClient
--                      -- NodeList ߼ڵ͵ĽڵIPб 192.168.40.7,192.168.40.8,192.168.40.9
--                      -- NodeType ߼ڵͶӦĽڵ ManagerAgent
--                      -- UpgradeMode ģʽ
--                      -- AutoBatch ǷɲƷη OMMùģ
--                      -- ParamList б OMMùģ
--  }
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
--FSMϢ, UPD-Serverʱ
--  g_ClusterInfo =
--  {
--      ActiveNode = "",
--      SlaveNode  = "",  --ΪʱʾΪFSM
--  }
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Ϣ
--  g_Config =
--  {
--    msg_retry_times = 60,          -- ϢԴ
--    msg_retry_interval = 5        -- ϢԼ
--  }
--------------------------------------------------------------------------------


function GetFlowTimeout_BatTsk(FlowName)
    local timeout = 0
    if (g_UpdateFlowsTbl[FlowName].timeout ~= nil) then
        timeout = g_UpdateFlowsTbl[FlowName].timeout
    end
    return timeout;
end

function CheckDswareVersion()
    local version_is_R6=false
    local retry_time=10
    local ret=0

    for i = 1, retry_time do
        ret = System("/opt/omm/oma/atoms/precheck/lib/check_is_R6_version.sh", 3);
        LogText(LL_INFO, "execute check_is_R6_version.sh ret = " .. ret);
        -- 6.2İ汾true
        if (ret == 0) then
            version_is_R6=false
            break
        elseif (ret == 1) then
            version_is_R6=true
            break
        else  --01Systemִʧܣ
            System("sleep 1", 1)
        end
    end

    return version_is_R6
end

function GetIndexValue(ip, tp, ltp)
    index = ip2int(ip)*100 + g_PRO_Const[tp]*10 + g_PRO_Const[ltp]
    LogText(LL_NOTICE, "GetIndexValue index = "..index.." "..ip.." "..ip2int(ip).." "..g_PRO_Const[tp].." "..g_PRO_Const[ltp])
    return index
end

--------------------------------------------------------------------------------
-- Func Name       : GetLTPValue
-- Description     : ܵãȡ߼ڵͶӦıʶ
-- Input           : LogicNodeType ߼ڵ
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function GetLTPValue(LogicNodeType)
    LogText(LL_NOTICE, "GetLtpValue "..g_PRO_Const[LogicNodeType]);
    return g_PRO_Const[LogicNodeType];
end

--------------------------------------------------------------------------------
-- Func Name       : GetNTPValue
-- Description     : ܵãȡڵͶӦıʶ
-- Input           : NodeType ڵ
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function GetNTPValue(NodeType)
    LogText(LL_NOTICE, "GetNtpValue "..g_PRO_Const[NodeType]);
    return g_PRO_Const[NodeType];
end

function getLuaTableLength(t)
    if (nil == t) then
        return 0;
    end
    local l = 0;
    for k, v in pairs(t) do
        l = l + 1;
    end
    return l;
end

-- g_PRO_UpdState.WaitingNodeListƳaddNodeList
function RemoveFromWaitingNodeList(addNodeList)
    for k,_ in pairs(addNodeList) do
        LogText(LL_NOTICE, "RemoveFromWaitingNodeList "..k)
        g_PRO_UpdState.WaitingNodeList[k] = nil;
    end
end

function GetNodeNumOfNodeList(todoNodeList)
    if (nil == todoNodeList) then
        return 0;
    end
    local l = 0;
    for _,NodeList in pairs(todoNodeList) do
        l = l + getLuaTableLength(NodeList);
    end
    return l;
end

function LogicNodeTypeIsInNodeList(todoCurNodeList,logicNodeType)
    if (nil == todoCurNodeList) then
        return false;
    end

    for _,NodeList in pairs(todoCurNodeList) do
        for k,n in pairs(NodeList) do
            if (n.ltp == g_PRO_Const[logicNodeType]) then
                return true;
            end
        end
    end
    return false;
end

function IsinNodeList(todoCurNodeList,k)
    for _,NodeList in pairs(todoCurNodeList) do
        if (NodeList[k] ~= nil) then
            return true;
        end
    end
    return false;
end

--жĳ߼ڵͣǷܹз
function CanBatchNodeByLTP(LogicNodeType)
    if (g_PRO_UpdState.ExecLogicType == LogicNodeType) then
        return true
    end

    if (g_PRO_UpdState.ExecLogicType == g_PRO_Const.LOGIC_NODE_TYPE_NODE) then
        return true
    end

    return false
end

-- жϵǰǷܹ÷ʧܱ־
function CanSetFailStop()
    -- ֻеǰûнڵִУʧܵʱ򣬲ʧܱ־
    if (g_PRO_UpdState.ExecLogicType == g_PRO_Const.LOGIC_NODE_TYPE_NODE) then
        return true
    end

    return false
end

--------------------------------------------------------------------------------
-- Func Name       : Table2String
-- Description     : tableתstring
-- Caution         : 
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.02.07
--    Modification : 
--------------------------------------------------------------------------------
function Table2String(paramTable)

    if (paramTable == nil) then
        return "{}"
    end

    local param = "{";
    for key, value in pairs(paramTable) do
        param = param .. key .. "='" .. value .. "',";
    end
    param = param .. "}";
    return param;
end

--------------------------------------------------------------------------------
-- Func Name       : GetFlowInfoByLtp_BatTsk
-- Description     : װԭӦϢ
-- Caution         : 
-- Input           : FlowName 
--                   LogicNodeType ߼ڵ
--                   UpgradeMode ģʽ
-- Output          :
-- Return          : ָ͵Ϣ
--------------------------------------------------------------------------------
function GetFlowInfoByLtp_BatTsk(FlowName, LogicNodeType, UpgradeMode)
    local ltpInfo = ""
    local upgAgNum = 0
    local rbkAgNum = 0
    local tbl = nil

    --UpgradeModeǰ顢ύ
    if ("" == UpgradeMode) then
        tbl = g_UpdateFlowsTbl[FlowName][LogicNodeType]
    else
        tbl = g_UpdateFlowsTbl[FlowName][LogicNodeType][UpgradeMode]
    end
    upgAgNum = #tbl.upd

    --ֻ̲лԭ
    if ("UPDATE" == FlowName) then
        rbkAgNum = #tbl.rbk
    end

    --װ̵ԭϢ
    if (0 ~= upgAgNum) then
        for i = 1, upgAgNum do
            local agName = tbl.upd[i].AtomGroupName
            local agProgress = tbl.upd[i].progress
            ltpInfo = ltpInfo..agName.."="..agProgress..","
        end
    end

    if (0 ~= rbkAgNum) then
        for i = 1, rbkAgNum do
            local agName = tbl.rbk[i].AtomGroupName
            local agProgress = tbl.rbk[i].progress
            ltpInfo = ltpInfo..agName.."="..agProgress..","
        end
    end

    local ltpInfoNum = #ltpInfo
    if (0 ~= ltpInfoNum) then
        ltpInfo = string.sub(ltpInfo, 1 , -2)
    end

    LogText(LL_DEBUG, "ltpInfo = "..ltpInfo)
    return ltpInfo
end

--------------------------------------------------------------------------------
-- Func Name       : GetFlowInfo_BatTsk
-- Description     : ܵãװ̶ӦĽ
-- Caution         :
-- Input           : FlowName 
-- Output          :
-- Return          : ǰ̵Ϣ
--------------------------------------------------------------------------------
function GetFlowInfo_BatTsk(FlowName)
    LogText(LL_NOTICE, "FlowName = "..FlowName)

    --ƴӸ߼ڵ͵ԭơȺͳʱʱ
    local info = ""
    if ("PRECHECK" == FlowName) or ("COMMIT" == FlowName) then
        LogText(LL_NOTICE, "fsmInfo PRECHECK")
        local fsmInfo = GetFlowInfoByLtp_BatTsk(FlowName, "FSM", "")
        local mdcInfo = GetFlowInfoByLtp_BatTsk(FlowName, "MDC", "")
        local osdInfo = GetFlowInfoByLtp_BatTsk(FlowName, "OSD", "")
        local clientInfo = GetFlowInfoByLtp_BatTsk(FlowName, "Client", "")
        info = "FSM:"..fsmInfo.."|".."MDC:"..mdcInfo.."|".."OSD:"..osdInfo.."|".."Client:"..clientInfo
    end

    LogText(LL_DEBUG, "info = "..info)
    return info
end

g_Init =
{
    UpgradeMode = {},               --{["MDC"]="online",}
    ParamList = {},                 --{["MDC"]="k1=v1,k2=v2",}
    SyncFlow = {},                  --{["MDC"]=true,}
    BindFlagForUpdate = {},         --{["MDC"]=true,}
    BindFlagForAutoRollback = {},   --{["MDC"]=true,}
    BindFlagForRollback = {},       --{["MDC"]=true,}
    FlushOsdFlag = {},              --{["OSD"]=true,}
    StopAppFlag = {},               --{["Client"]=true,}
    OsdNodeListByPool = {},
    OsdNodeListWithPool = {},
    --osdڵʱ¼ִзűʧܵĴ
    Batch_shell_failed_times = 0,
    --osdڵʱʶҪʱгִзűʧܵı־
    Batch_shell_failed_flag = 0,
    --osdڵʱ¼Ϊյ
    Get_Node_List_Osd_Null_times = 0,
};

function GetPoolidKey(Poolids)
    local PoolidKey = "";
    if (Poolids == nil) or (Poolids == "") then
        LogText(LL_WARN, "Poolids tbl is blank.");
        return nil;
    end
    for _, id in pairs(Poolids) do
        if (PoolidKey == "") then
            PoolidKey = PoolidKey .. id;
        else
            PoolidKey = PoolidKey .. "_" .. id;
        end
    end
    LogText(LL_INFO, "PoolidKey = "..PoolidKey)
    return PoolidKey;
end

function GetOneIpFromNodeList(NodeList)
    if (NodeList == nil) or (NodeList == "") then
        LogText(LL_WARN, "NodeList tbl is blank.");
        return nil;
    end
    for _, Node in pairs(NodeList) do
        if (Node ~= nil) then
            return Node.ip;
        end
    end
    return nil;
end



function IsinCurNodeList(CurNodeList,k)
    for _,NodeList in pairs(CurNodeList) do
        if (NodeList[k] ~= nil) then
            return true;
        end
    end
    return false;
end

--ͣĬΪipv4 
g_Network_Type = "ipv4";

-- ȡڵipͣipv4  ipv6
function getNetworkType()
    LogText(LL_INFO, "begin to get network type from upds.cfg")
    local updsCfg = "/opt/omm/oms/workspace/conf/upds/upds.cfg";
    local f = io.open(updsCfg, "r");
    if (nil ~= f) then
        local cfg = f:read("*all");
        f:close();
        for value in string.gmatch(cfg, "p_manager_ip_family=([%w]*)") do
            g_Network_Type = value;
            LogText(LL_INFO, "get network type from upds.cfg: p_manager_ip_family=" .. value)
            break;
        end
    else
        LogText(LL_ERROR, "Can not open upds.cfg file")
    end  
end

g_Init_Flag = false;

-- ʼ߼ڵģʽб󶨱ʶ
function init()
    -- ȡִнڵ߼ڵͣʱʹ
    if (0 ~= getLuaTableLength(g_PRO_UpdState.ExecNodeList)) then
        for _, Node in pairs(g_PRO_UpdState.ExecNodeList) do
            if (Node ~= nil) then
                g_PRO_UpdState.ExecLogicType = Node.ltp
                break
            end
        end
    else
        g_PRO_UpdState.ExecLogicType = g_PRO_Const.LOGIC_NODE_TYPE_NODE
    end
    LogText(LL_INFO, "+++++ g_PRO_UpdState.ExecLogicType:" .. g_PRO_UpdState.ExecLogicType)

    -- ʼΪtrue״̬ǼִвҴִĽڵ㲻Ϊգ˵ִУҪִгʼ
    if (g_Init_Flag == true and g_PRO_UpdState.TaskControl == g_Const.TASK_CONTROL_CONTINUE and 0 ~= getLuaTableLength(g_PRO_UpdState.ExecNodeList)) then
        return;
    end
    
    -- ȡڵipͣipv4  ipv6
    getNetworkType()
    
    -- ˵updsոռlua/ͣg_PRO_UpdState.WaitingNodeListƻΪ³ʼĲg_PRO_UpdState.WaitingNodeList
    for _,n in pairs(g_TaskInfo.Nodes) do
        local paramList = n.ParamList
        if (paramList == nil) then
            paramList = "";
        end
        LogText(LL_INFO, "init UpgradeMode = "..n.UpgradeMode)
        if (n.UpgradeMode == nil) then
            g_Init.UpgradeMode[n.LogicNodeType] = "";
        else
            g_Init.UpgradeMode[n.LogicNodeType] = n.UpgradeMode;
            paramList = "UPGRADE_MODE=" .. n.UpgradeMode .. "," .. paramList;
        end
        LogText(LL_INFO, "init UpgradeMode = "..g_Init.UpgradeMode[n.LogicNodeType])
        paramList = "LOGIC_NODE_TYPE=" .. n.LogicNodeType .. "," .. paramList;
        paramList = "NODE_TYPE=" .. n.NodeType .. "," .. paramList;
        g_Init.ParamList[n.LogicNodeType] = paramList;

        local syncFlow = "false";
        local bindFlagForUpdateMDC = "false";
        local bindFlagForAutoRollbackMDC = "false";
        local bindFlagForRollbackMDC = "false";
        local flushOsdFlag = "false";
        local stopAppFlag = "false";
        for k,v in string.gmatch(paramList, "%s*([%w_]+)%s*=%s*(%w+)%s*") do
            if (k == "MDC_ALL" and v == "Y") then
                bindFlagForUpdateMDC = "true";
                syncFlow = "true";
            end
            if (k == "OSD_META_FLUSH" and v == "Y") then
                flushOsdFlag = "true";
            end
            if (k == "STOP_APP" and v == "Y") then
                stopAppFlag = "true";
            end
        end
        if (n.LogicNodeType == g_PRO_Const.LOGIC_NODE_TYPE_MDC) then
            g_Init.SyncFlow[n.LogicNodeType] = syncFlow;
            g_Init.BindFlagForUpdate[n.LogicNodeType] = bindFlagForUpdateMDC;
            g_Init.BindFlagForAutoRollback[n.LogicNodeType] = bindFlagForAutoRollbackMDC;
            g_Init.BindFlagForRollback[n.LogicNodeType] = bindFlagForRollbackMDC;
        else
            g_Init.SyncFlow[n.LogicNodeType] = "false";
            g_Init.BindFlagForUpdate[n.LogicNodeType] = "false";
            g_Init.BindFlagForAutoRollback[n.LogicNodeType] = "false";
            g_Init.BindFlagForRollback[n.LogicNodeType] = "false";
        end
        if (n.LogicNodeType == g_PRO_Const.LOGIC_NODE_TYPE_OSD) then
            g_Init.FlushOsdFlag[n.LogicNodeType] = flushOsdFlag;
        else
            g_Init.FlushOsdFlag[n.LogicNodeType] = "false";
        end
        if (n.LogicNodeType == g_PRO_Const.LOGIC_NODE_TYPE_CLIENT) then
            g_Init.StopAppFlag[n.LogicNodeType] = stopAppFlag;
        else
            g_Init.StopAppFlag[n.LogicNodeType] = "false";
        end
    end

    if (nil == g_PRO_UpdState.TaskControl or "" == g_PRO_UpdState.TaskControl) then
        g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE;
    end


    --ʼ g_Init.OsdNodeListByPool  g_Init.OsdNodeListWithPool
--    initForBatchOsdNodes()
    g_PRO_UpdState.WaitingNodeList = {};
    for k,n in pairs(g_PRO_UpdState.NodeList) do
        --LogText(LL_INFO, "k = "..k)
        --LogText(LL_INFO, "SuccNodeList = "..Table2String(g_PRO_UpdState.SuccNodeList[k]))
        --LogText(LL_INFO, "FailNodeList = "..Table2String(g_PRO_UpdState.FailNodeList[k]))
        if (g_PRO_UpdState.SuccNodeList[k] == nil and g_PRO_UpdState.FailNodeList[k] == nil and g_PRO_UpdState.AutoRbkSuccNodeList[k] == nil and g_PRO_UpdState.ExecNodeList[k] == nil) then
            local node = {};
            node.ip = n.ip;
            node.tp = n.tp;
            node.ltp = n.ltp;
            node.code = "";
            g_PRO_UpdState.WaitingNodeList[k] = node;
        end
    end

    g_Init.Batch_shell_failed_times = 0;
    g_Init.Get_Node_List_Osd_Null_times = 0;
    g_Init.Batch_shell_failed_flag = 0;

    g_Init_Flag = true;
end

-- g_PRO_UpdState.WaitingNodeListлȡһ߼ڵ͵ĽڵбȡĽڵбʽg_PRO_UpdState.CurNodeListʽͬ
function GetNodeListFromWaitingNodeList(logicNodeType)
    local nodeList = {};
    for k,n in pairs(g_PRO_UpdState.WaitingNodeList) do
        --LogText(LL_INFO, "GetNodeListFromWaitingNodeList n.ltp = "..n.ltp)
        if (n.ltp == g_PRO_Const[logicNodeType]) then
            local node = {};
            node.ip = n.ip;
            node.tp = n.tp;
            node.ltp = n.ltp;
            node.state = ATOM_GROUP_EXEC_RET_INIT;
            nodeList[k] = node;
        end
    end
    return nodeList;
end

-- g_PRO_UpdState.WaitingNodeListƳg_PRO_UpdState.CurNodeList
function RemoveCurNodeListFromWaitingNodeList(addNodeList)
    for k,_ in pairs(addNodeList) do
        g_PRO_UpdState.WaitingNodeList[k] = nil;
    end
end

-- g_PRO_UpdState.WaitingNodeListָ߼ڵ͵Ľڵcode
function SetWaitingNodeListCode(logicNodeType, code)
    for k,_ in pairs(g_PRO_UpdState.WaitingNodeList) do
        if (logicNodeType == g_PRO_Const.LOGIC_NODE_TYPE_ALL or g_PRO_Const[logicNodeType] == g_PRO_UpdState.WaitingNodeList[k].ltp) then
            g_PRO_UpdState.WaitingNodeList[k].code = code;
        end
    end
end

function GetNodeNumOfCurNodeList(CurNodeList)
    if (nil == CurNodeList) then
        return 0;
    end
    local l = 0;
    for _,NodeList in pairs(CurNodeList) do
        l = l + getLuaTableLength(NodeList);
    end
    return l;
end

function LogicNodeTypeIsInCurNodeList(CurNodeList,logicNodeType)
    if (nil == CurNodeList) then
        return false;
    end

    for _,NodeList in pairs(CurNodeList) do
        for k,n in pairs(NodeList) do
            if (n.ltp == g_PRO_Const[logicNodeType]) then
                return true;
            end
        end
    end
    return false;
end


-- g_PRO_UpdState
function SetResult(nodeType, logicNodeType, addNodeList , addNodeListKey)
    LogText(LL_INFO, "Enter SetResult"..nodeType.."  "..logicNodeType)

    local NodeNumOfCurNodeList = getLuaTableLength(g_PRO_UpdState.ExecNodeList)
    local addNodeListTmp = {};
    local numOfTmpList = 0;
    if (g_PRO_Const.CUR_NODE_LIST_NODE_NUM_MAX <= NodeNumOfCurNodeList) then
        LogText(LL_NOTICE, "NodeNumOfCurNodeList more than "..g_PRO_Const.CUR_NODE_LIST_NODE_NUM_MAX)
        return;
    elseif (g_PRO_Const.CUR_NODE_LIST_NODE_NUM_MAX < NodeNumOfCurNodeList + getLuaTableLength(addNodeList)) then
        for k,Node in pairs(addNodeList) do
            if (numOfTmpList < g_PRO_Const.CUR_NODE_LIST_NODE_NUM_MAX - NodeNumOfCurNodeList) then
                addNodeListTmp[k] = Node;
                numOfTmpList = numOfTmpList + 1;
            else
                break;
            end
        end
    end

    g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE;
    g_PRO_UpdState.NodeType = nodeType;
    g_PRO_UpdState.LogicNodeType = logicNodeType;
    g_PRO_UpdState.UpgradeMode = g_Init.UpgradeMode[logicNodeType];
    -- g_PRO_UpdState.UpdParamList = g_Init.ParamList[logicNodeType];
    g_PRO_UpdState.SyncFlow = g_PRO_Const[g_Init.SyncFlow[logicNodeType]];
    g_PRO_UpdState.BindFlagForUpdate = g_PRO_Const[g_Init.BindFlagForUpdate[logicNodeType]];
    g_PRO_UpdState.BindFlagForAutoRollback = g_PRO_Const[g_Init.BindFlagForAutoRollback[logicNodeType]];
    g_PRO_UpdState.BindFlagForRollback = g_PRO_Const[g_Init.BindFlagForRollback[logicNodeType]];

    if (0 == numOfTmpList) then
        g_PRO_UpdState.CurNodeList[addNodeListKey] = addNodeList;
        RemoveCurNodeListFromWaitingNodeList(addNodeList);
    else
        g_PRO_UpdState.CurNodeList[addNodeListKey] = addNodeListTmp;
        RemoveCurNodeListFromWaitingNodeList(addNodeListTmp);
    end

    -- MDC˵ĳʱʱΪ3
    if (logicNodeType ==g_PRO_Const.LOGIC_NODE_TYPE_MDC and (g_PRO_UpdState.Flow == g_PRO_Const.FLOW_NAME_UPDATE or g_PRO_UpdState.Flow == g_PRO_Const.FLOW_NAME_ROLLBACK)) then
        g_Config.msg_retry_times = 18
        g_Config.msg_retry_interval = 5
    else
        g_Config.msg_retry_times = 60
        g_Config.msg_retry_interval = 5
    end
    return;
end


-- ͨshellų̋ȡһڵ㣬ָ߼ڵ͵Ľڵблȡһ
function BatchNodeByShell(clusterType, nodeIpList, upgradeMode, paramKey, paramValue)
    LogText(LL_INFO, "clusterType=" .. clusterType);
    LogText(LL_INFO, "nodeIpList=" .. nodeIpList);
    LogText(LL_INFO, "upgradeMode=" .. upgradeMode);
    LogText(LL_INFO, "paramKey=" .. paramKey);
    LogText(LL_INFO, "paramValue=" .. paramValue);
    local resultCode = 0;
    local resultIpList = "";
    local resultFile = "/opt/omm/oms/flow/agent/findOneBatchNodes.out";
    local cmd = "/opt/omm/oms/flow/agent/findOneBatchNodes.sh";
    cmd = cmd .. " " .. clusterType;
    cmd = cmd .. " " .. nodeIpList;
    cmd = cmd .. " " .. upgradeMode;
    cmd = cmd .. " " .. paramKey;
    cmd = cmd .. " " .. paramValue;


    resultCode = System(cmd, 5);

    LogText(LL_INFO, "execute [" .. cmd .. "], resultCode=" .. resultCode);
    if (resultCode == 0)
    then
        g_Init.Batch_shell_failed_flag = g_Init.Batch_shell_failed_flag * 0;
        --g_Init.Batch_shell_failed_times = 0,
    else
        g_Init.Batch_shell_failed_flag = g_Init.Batch_shell_failed_flag * 1;
    end

    if (resultCode ~= 0) then
        if ((clusterType == string.lower(g_PRO_Const.LOGIC_NODE_TYPE_MDC)) and (upgradeMode == "offline")) then
            return tonumber(g_PRO_Const.CODE_SELECT_ALL_ZK_OFFLINE);
        else
            return tonumber(g_PRO_Const.CODE_BATCH_INNER_ERROR);
        end
    end

    local f = io.open(resultFile, "r");
    if (nil == f) then
        LogText(LL_ERROR, "Can not open findOneBatchNodes result file " .. resultFile);
        return tonumber(g_PRO_Const.CODE_BATCH_INNER_ERROR);
    end
    local txt = f:read("*all");
    f:close();
    LogText(LL_INFO, "g_Network_Type is "..g_Network_Type)
    if (g_Network_Type == "ipv4") then
        for k,v in string.gmatch(txt, "([%w_]+)=([%d%.,]*)") do
            if (k == "resultCode") then
                LogText(LL_INFO, "get from resultFile, resultCode=" .. v);
                resultCode = tonumber(v);
            end
            if (k == "resultIpList") then
                LogText(LL_INFO, "get from resultFile, resultIpList=" .. v);
                resultIpList = v;
            end
        end
    elseif (g_Network_Type == "ipv6") then
        for k,v in string.gmatch(txt, "([%w_]+)=([%w%:,]*)") do
            if (k == "resultCode") then
                LogText(LL_INFO, "get from resultFile, resultCode=" .. v);
                resultCode = tonumber(v);
            end
            if (k == "resultIpList") then
                LogText(LL_INFO, "get from resultFile, resultIpList=" .. v);
                resultIpList = v;
            end
        end
    else
        LogText(LL_ERROR, "g_Network_Type is not ipv4 or ipv6");
        return tonumber(g_PRO_Const.CODE_BATCH_INNER_ERROR);
    end
    LogText(LL_INFO, "get from resultFile, resultCode=" .. resultCode .. ", resultIpList=" .. resultIpList);
    return resultCode, resultIpList;
end
 

-- ָ߼ڵ͵Ľڵбз
function BatchNode(nodeType, logicNodeType, nodeList)
    LogText(LL_INFO, "nodeType=" .. nodeType);
    LogText(LL_INFO, "logicNodeType=" .. logicNodeType);
    local nodeIpList = "";
    local clusterType = string.lower(logicNodeType);
    local upgradeMode = g_Init.UpgradeMode[logicNodeType];
    local paramKey = "";
    local paramValue = "";
    for _,n in pairs(nodeList) do
        --LogText(LL_INFO, "n.ip=" .. n.ip);
        if (nodeIpList == "") then
            nodeIpList = n.ip;
        else
            nodeIpList = nodeIpList .. "," .. n.ip;
        end
    end
    LogText(LL_INFO, "nodeIpList=" .. nodeIpList);

    local ret = false;
    local code = g_PRO_Const.CODE_BATCH_INNER_ERROR;
    local resultNodeList = {};
    if (logicNodeType == g_PRO_Const.LOGIC_NODE_TYPE_MDC) then
        paramKey = "bindFlag";
        paramValue = g_Init.BindFlagForUpdate[logicNodeType];
    elseif (logicNodeType == g_PRO_Const.LOGIC_NODE_TYPE_OSD) then
        paramKey = "flushFlag";
        paramValue = g_Init.FlushOsdFlag[logicNodeType];
    elseif (logicNodeType == g_PRO_Const.LOGIC_NODE_TYPE_CLIENT) then
        paramKey = "vscFlag";
        paramValue = g_Init.StopAppFlag[logicNodeType];
    else
        LogText(LL_INFO, "ret=" .. ((ret and "true") or "false") .. ", code=" .. code .. ", resultNodeList length=" .. getLuaTableLength(resultNodeList));
        return ret,code,resultNodeList;
    end

    local resultCode = nil;
    local resultIpList = nil;
    resultCode,resultIpList = BatchNodeByShell(clusterType, nodeIpList, upgradeMode, paramKey, paramValue);
    if (resultCode == 0) then
        ret = true;
        code = tostring(resultCode);
        LogText(LL_INFO, "g_Network_Type is "..g_Network_Type)
        if (g_Network_Type == "ipv4") then
            for ip in string.gmatch(resultIpList, "[%d%.]+,?") do
                local ip = string.gsub(ip,",","");
                --LogText(LL_INFO, "ip=" .. ip);
                local nodeKey = ip2int(ip) * 100 + g_PRO_Const[nodeType] * 10 + g_PRO_Const[logicNodeType];
                --LogText(LL_INFO, "nodeKey=" .. nodeKey);
                local node = nodeList[nodeKey];
                if (node ~= nil) then
                    resultNodeList[nodeKey] = node;
                else
                    ret = false;
                    code = g_PRO_Const.CODE_BATCH_INNER_ERROR;
                    LogText(LL_INFO, "ret=" .. ((ret and "true") or "false") .. ", code=" .. code .. ", resultNodeList length=" .. getLuaTableLength(resultNodeList));
                    return ret,code,resultNodeList;
                end
            end
        else
            for ip in string.gmatch(resultIpList, "[%w%:]+,?") do
                local ip = string.gsub(ip,",","");
                local nodeKey = ip2int(ip) * 100 + g_PRO_Const[nodeType] * 10 + g_PRO_Const[logicNodeType];
                local node = nodeList[nodeKey];
                if (node ~= nil) then
                    resultNodeList[nodeKey] = node;
                else
                    ret = false;
                    code = g_PRO_Const.CODE_BATCH_INNER_ERROR;
                    LogText(LL_INFO, "ret=" .. ((ret and "true") or "false") .. ", code=" .. code .. ", resultNodeList length=" .. getLuaTableLength(resultNodeList));
                    return ret,code,resultNodeList;
                end
            end
        end

        LogText(LL_INFO, "ret=" .. ((ret and "true") or "false") .. ", code=" .. code .. ", resultNodeList length=" .. getLuaTableLength(resultNodeList));
        if (0 == getLuaTableLength(resultNodeList)) then
            ret = false;
            if (logicNodeType == g_PRO_Const.LOGIC_NODE_TYPE_MDC) then
                code = g_PRO_Const.CODE_CLUSTER_STATUS_ABNORMAL;
            elseif (logicNodeType == g_PRO_Const.LOGIC_NODE_TYPE_OSD) then
                code = g_PRO_Const.CODE_POOL_STATUS_ABNORMAL;
            elseif (logicNodeType == g_PRO_Const.LOGIC_NODE_TYPE_CLIENT) then
                code = g_PRO_Const.CODE_VOLUME_IS_ATTACHED;
            end
        end
        LogText(LL_INFO, "ret=" .. ((ret and "true") or "false") .. ", code=" .. code .. ", resultNodeList length=" .. getLuaTableLength(resultNodeList));
    else
        ret = false;
        code = tostring(resultCode);
        LogText(LL_INFO, "ret=" .. ((ret and "true") or "false") .. ", code=" .. code .. ", resultNodeList length=" .. getLuaTableLength(resultNodeList));
    end

    return ret,code,resultNodeList;
end

function Division(FullString, Separator)
    local startIndex = 1
    local splitArray = {}

    local lastIndex = string.find(FullString, Separator, startIndex)
    if not lastIndex then
        splitArray[1] = string.sub(FullString, startIndex, string.len(FullString))
        return splitArray
    end

    splitArray[1] = string.sub(FullString, startIndex, lastIndex - 1)
    splitArray[2] = string.sub(FullString, lastIndex + 1, string.len(FullString))
    return splitArray
end

function splitParam(inputParamList)
    local pList = Split(inputParamList, ",")
    LogText(LL_INFO, "paramList = "..Table2String(pList))

    if (pList ~= nil) then
        for _, param in pairs(pList) do
            local kv = Division(param, "=")
            LogText(LL_INFO, "Node = "..Table2String(kv))
            local key = kv[1]
            local value = kv[2]
            g_PRO_UpdState.UpdParamList[key] = value
        end
    end
end

-- ύз
function GetNodeListForPrecheckOrCommit(fsmNodeList, mdcNodeList, osdNodeList, clientNodeList)
    -- FSMڵ㻹δִǰύһִFSMڵ
    if (0 ~= getLuaTableLength(fsmNodeList)) then
        SetResult(g_PRO_Const.NODE_TYPE_MANAGER, g_PRO_Const.LOGIC_NODE_TYPE_FSM, fsmNodeList, g_PRO_Const.CUR_NODE_LIST_KEY_FSM);
        return;
    end

    -- MDCڵ㻹δִǰύڶִMDCڵ
    if (0 ~= getLuaTableLength(mdcNodeList)) then
        if (CanBatchNodeByLTP(g_PRO_Const.LOGIC_NODE_TYPE_MDC) == false) then
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE
            return
        end

        SetResult(g_PRO_Const.NODE_TYPE_AGENT, g_PRO_Const.LOGIC_NODE_TYPE_MDC, mdcNodeList, g_PRO_Const.CUR_NODE_LIST_KEY_MDC);
        -- MDC󳡾£ʼĲʺMDCύҪУһ
        g_PRO_UpdState.SyncFlow = false;
        g_PRO_UpdState.BindFlagForUpdate = false;
        return;
    end

    -- Clientڵ㻹δִǰύִClientڵ
    if (0 ~= getLuaTableLength(clientNodeList)) then
        if (CanBatchNodeByLTP(g_PRO_Const.LOGIC_NODE_TYPE_CLIENT) == false) then
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE
            return
        end

        SetResult(g_PRO_Const.NODE_TYPE_AGENT, g_PRO_Const.LOGIC_NODE_TYPE_CLIENT, clientNodeList, g_PRO_Const.CUR_NODE_LIST_KEY_CLIENT);
        return;
    end

    -- OSDڵ㻹δִǰύִOSDڵ
    if (0 ~= getLuaTableLength(osdNodeList)) then
        if (CanBatchNodeByLTP(g_PRO_Const.LOGIC_NODE_TYPE_OSD) == false) then
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE
            return
        end

        SetResult(g_PRO_Const.NODE_TYPE_AGENT, g_PRO_Const.LOGIC_NODE_TYPE_OSD, osdNodeList, g_PRO_Const.CUR_NODE_LIST_KEY_OSD);
        return;
    end

    -- ɹ
    if (0 == getLuaTableLength(g_PRO_UpdState.WaitingNodeList) and 0 == getLuaTableLength(g_PRO_UpdState.ExecNodeList)) then
        g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_STOP_SUCC;
    end

    return;
end

-- ʧܽڵбǷĳ߼ڵ͵Ľڵ
function checkFailedNodeList(logicNodeType)
    -- ʧԶʧܣ߻ʧ
    for _, Node in pairs(g_PRO_UpdState.FailNodeList) do
        if (Node.ltp == g_PRO_Const[logicNodeType]) then
            LogText(LL_INFO, "FailNode = "..Table2String(Node))
            return true;
        end
    end

    -- ʧԶ˳ɹ
    for _, Node in pairs(g_PRO_UpdState.AutoRbkSuccNodeList) do
        if (Node.ltp == g_PRO_Const[logicNodeType]) then
            LogText(LL_INFO, "AutoRbkSuccNode = "..Table2String(Node))
            return true;
        end
    end

    return false;
end



-- ˣз
function GetNodeListForRollback(fsmNodeList, mdcNodeList, osdNodeList, clientNodeList)
    local resultCode = 0;
    
    -- Clientڵ㻹δִлˣһִClientڵ
    if (0 ~= getLuaTableLength(clientNodeList)) then
        GetNodeListClient(clientNodeList);
        -- ҪһClientڵΪգһδִл˵OSDڵ㣬Ҫһܻ˵OSDڵ
        -- ִֹֹһClient˾ִһCLient
        if ((false == LogicNodeTypeIsInCurNodeList(g_PRO_UpdState.CurNodeList,g_PRO_Const.LOGIC_NODE_TYPE_CLIENT)) and (0 ~= getLuaTableLength(osdNodeList))) then
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE;
        else
            return;
        end
    end

    -- OSDڵ㻹δִлˣڶִOSDڵ
    if (0 ~= getLuaTableLength(osdNodeList)) then
        if (CanBatchNodeByLTP(g_PRO_Const.LOGIC_NODE_TYPE_OSD) == false) then
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE
            return
        end

        GetNodeListOsd(osdNodeList);
        return;
    end

    -- ûڵҪˣ򲻼
    if (0 == getLuaTableLength(g_PRO_UpdState.WaitingNodeList) and 0 == getLuaTableLength(g_PRO_UpdState.ExecNodeList)) then
        g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_STOP_SUCC;
        return;
    end

    -- Clientʧܣ򲻼
    if (checkFailedNodeList(g_PRO_Const.LOGIC_NODE_TYPE_CLIENT)) then
        LogText(LL_ERROR, g_PRO_Const.LOGIC_NODE_TYPE_CLIENT .. " node rollback failed, can not rollback other nodes.")
        if (CanSetFailStop() == true) then
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_STOP_FAIL;
            SetWaitingNodeListCode(g_PRO_Const.LOGIC_NODE_TYPE_ALL, g_PRO_Const.CODE_OTHER_NODE_FAILED);
        else
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE;
        end
        return;
    end

    -- OSDʧܣ򲻼
    if (checkFailedNodeList(g_PRO_Const.LOGIC_NODE_TYPE_OSD)) then
        LogText(LL_ERROR, g_PRO_Const.LOGIC_NODE_TYPE_OSD .. " node rollback failed, can not rollback other nodes.")
        if (CanSetFailStop() == true) then
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_STOP_FAIL;
            SetWaitingNodeListCode(g_PRO_Const.LOGIC_NODE_TYPE_ALL, g_PRO_Const.CODE_OTHER_NODE_FAILED);
        else
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE;
        end
        return;
    end

    -- MDCڵ㻹δִлˣִMDCڵ
    if (0 ~= getLuaTableLength(mdcNodeList)) then
        if (CanBatchNodeByLTP(g_PRO_Const.LOGIC_NODE_TYPE_MDC) == false) then
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE
            return
        end

        GetNodeListMdc(mdcNodeList);
        return;
    end

    -- ûڵҪˣ򲻼
    if (0 == getLuaTableLength(g_PRO_UpdState.WaitingNodeList) and 0 == getLuaTableLength(g_PRO_UpdState.ExecNodeList)) then
        g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_STOP_SUCC;
        return;
    end

    -- MDCʧܣ򲻼
    if (checkFailedNodeList(g_PRO_Const.LOGIC_NODE_TYPE_MDC)) then
        LogText(LL_ERROR, g_PRO_Const.LOGIC_NODE_TYPE_MDC .. " node update failed, can not update other nodes.")
        if (CanSetFailStop() == true) then
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_STOP_FAIL;
            SetWaitingNodeListCode(g_PRO_Const.LOGIC_NODE_TYPE_ALL, g_PRO_Const.CODE_OTHER_NODE_FAILED);
        else
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE;
        end
        return;
    end

    -- FSMڵ㻹δִлˣִFSMڵ
    if (0 ~= getLuaTableLength(fsmNodeList)) then
        if (CanBatchNodeByLTP(g_PRO_Const.LOGIC_NODE_TYPE_FSM) == false) then
            g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_CONTINUE
            return
        end

        SetResult(g_PRO_Const.NODE_TYPE_MANAGER, g_PRO_Const.LOGIC_NODE_TYPE_FSM, fsmNodeList, g_PRO_Const.CUR_NODE_LIST_KEY_FSM);
        return;
    end

    -- ɹ
    if (0 == getLuaTableLength(g_PRO_UpdState.WaitingNodeList) and 0 == getLuaTableLength(g_PRO_UpdState.ExecNodeList)) then
        g_PRO_UpdState.TaskControl = g_Const.TASK_CONTROL_STOP_SUCC;
    end

    return;
end

-- nodelist = execlist + succlist + faillist + autorbklist + watinglist
--÷֮ǰģصcurlistӦwatinglistӼбвظĽڵ
function prepareTransToGlobalState(flowname,taskinfo,nodelist,execlist,succlist,faillist,autorbklist)

    g_PRO_UpdState.Flow = flowname;
    g_PRO_UpdState.ExecNodeList = execlist;
    g_PRO_UpdState.NodeList = nodelist;
    g_PRO_UpdState.SuccNodeList = succlist;
    g_PRO_UpdState.FailNodeList = faillist;
    g_PRO_UpdState.AutoRbkSuccNodeList = autorbklist;
    g_PRO_UpdState.TaskInfo = taskinfo;
    g_PRO_UpdState.CurNodeList = {};
end


function getReturnResult()
    local subCurNodeList = {}
    local agtbl = {}
    local curlist_configList = {}
    local nodeList = {}

    LogText(LL_INFO, "g_PRO_UpdState.Flow=" .. g_PRO_UpdState.Flow .. "  g_PRO_UpdState.LogicNodeType=" .. g_PRO_UpdState.LogicNodeType)
    LogText(LL_INFO,"g_PRO_UpdState.TaskControl == "..g_PRO_UpdState.TaskControl)

    -- g_PRO_UpdState.CurNodeList ΪʱsubCurNodeListΪգκγԱ
    if (0 == GetNodeNumOfCurNodeList(g_PRO_UpdState.CurNodeList)) then
        LogText(LL_INFO, "CurNodeList has no member, just return")
        return g_PRO_UpdState.TaskControl, g_PRO_UpdState.WaitingNodeList, subCurNodeList;
    end

    -- ȡԭб
    if ("PRECHECK" == g_PRO_UpdState.Flow) or ("COMMIT" == g_PRO_UpdState.Flow) then
        agtbl = g_UpdateFlowsTbl[g_PRO_UpdState.Flow][g_PRO_UpdState.LogicNodeType]
    end

    --ȡcurlist_config
    curlist_configList["NodeType"] = g_PRO_UpdState.NodeType
    curlist_configList["LogicNodeType"] = g_PRO_UpdState.LogicNodeType
    curlist_configList["ParamList"] = g_Init.ParamList[g_PRO_UpdState.LogicNodeType]
    curlist_configList["SyncFlow"] = g_PRO_UpdState.SyncFlow
    curlist_configList["BindFlagForUpdate"] = g_PRO_UpdState.BindFlagForUpdate
    curlist_configList["BindFlagForRollback"] = g_PRO_UpdState.BindFlagForRollback
    curlist_configList["BindFlagForAutoRollback"] = g_PRO_UpdState.BindFlagForAutoRollback

    --VBSڵ
    if (g_PRO_Const.LOGIC_NODE_TYPE_CLIENT ~= g_PRO_UpdState.LogicNodeType) then
        local subNodeList = {}
        for k, n in pairs(g_PRO_UpdState.CurNodeList) do
            subNodeList = {}
            for kk,kn in pairs(n) do
                local node = {};
                node["ip"] = kn.ip;
                node["tp"] = kn.tp;
                node["ltp"] = kn.ltp;
                LogText(LL_INFO, "getReturnResult n.ip="..kn.ip .." n.tp=" .. g_PRO_UpdState.NodeType .. " n.ltp=" .. g_PRO_UpdState.LogicNodeType)
                local key = GetIndexValue(kn.ip,g_PRO_UpdState.NodeType,g_PRO_UpdState.LogicNodeType);
                subNodeList[key] = node;
            end
            subNodeList["agtbl"] = agtbl
            subNodeList["curlist_config"] = curlist_configList
            table.insert(subCurNodeList, subNodeList)
        end
    else
        for k, n in pairs(g_PRO_UpdState.CurNodeList) do
            for kk,kn in pairs(n) do
                local node = {};
                node["ip"] = kn.ip;
                node["tp"] = kn.tp;
                node["ltp"] = kn.ltp;
                LogText(LL_INFO, "getReturnResult n.ip="..kn.ip .." n.tp=" .. g_PRO_UpdState.NodeType .. " n.ltp=" .. g_PRO_UpdState.LogicNodeType)
                local key = GetIndexValue(kn.ip,g_PRO_UpdState.NodeType,g_PRO_UpdState.LogicNodeType);
                nodeList[key] = node;
            end
        end

        --ÿsublistзʮڵ
        local i = 0
        local subNodeList = {}
        for k, n in pairs(nodeList) do
            i = i + 1
            subNodeList[k] = n
            if (i == g_PRO_Const.NODE_NUMBER_PER_SUBLIST) then  --ʮڵ㣬װб
                subNodeList["agtbl"] = agtbl
                subNodeList["curlist_config"] = curlist_configList
                table.insert(subCurNodeList, subNodeList)
                i = 0
                subNodeList = {}
                LogText(LL_INFO, "+++++ insert an sublist")
            end
        end

        --Ĳһбڵ
        if (i ~= 0) then
            subNodeList["agtbl"] = agtbl
            subNodeList["curlist_config"] = curlist_configList
            table.insert(subCurNodeList, subNodeList)
            LogText(LL_INFO, "+++++ insert last several node: " .. i)
        end
    end

    -- debug start
    --for k,n in pairs(g_PRO_UpdState.WaitingNodeList) do
        --LogText(LL_INFO,"WaitingNodeList: key == "..k)
    --end
    local waitingNumOfNodes = getLuaTableLength(g_PRO_UpdState.WaitingNodeList)
    LogText(LL_INFO,"WaitingNodeList: there are " .. waitingNumOfNodes .. " nodes in waitingList.")

    for k,n in pairs(subCurNodeList) do
        LogText(LL_INFO,"subCurNodeList: key == "..k)
      for kn,nn in pairs(n) do
            LogText(LL_INFO,"subCurNodeList: value == " .. kn)
      end
    end
    -- debug end
    return g_PRO_UpdState.TaskControl,g_PRO_UpdState.WaitingNodeList,subCurNodeList;
end


-- FlowǰִеϢȡһڵ
function GetBatchNodeList(flowname,taskinfo,nodelist,execlist,succlist,faillist,autorbklist)
    -- lua֮ǰĴ룬תȫֱ޶ȵļд޸
    prepareTransToGlobalState(flowname,taskinfo,nodelist,execlist,succlist,faillist,autorbklist)
    
    -- ʼ߼ڵģʽб󶨱ʶ
    init()
    
    local nodeType = nil;
    local logicNodeType = nil;
    local curNodeList = nil;
    -- WaitingNodeListȡ߼ڵб
    local fsmNodeList = GetNodeListFromWaitingNodeList(g_PRO_Const.LOGIC_NODE_TYPE_FSM);
    local mdcNodeList = GetNodeListFromWaitingNodeList(g_PRO_Const.LOGIC_NODE_TYPE_MDC);
    local osdNodeList = GetNodeListFromWaitingNodeList(g_PRO_Const.LOGIC_NODE_TYPE_OSD);
    local clientNodeList = GetNodeListFromWaitingNodeList(g_PRO_Const.LOGIC_NODE_TYPE_CLIENT);

    -- 飬1FSMڵ㣬2MDCڵ㣬4OSDڵ㣬3Clientнڵ
    -- ύ1FSMڵ㣬2MDCڵ㣬4OSDڵ㣬3Clientнڵ
    if (g_PRO_UpdState.Flow == g_PRO_Const.FLOW_NAME_PRECHECK) then
        LogText(LL_INFO, "FLOW_NAME_PRECHECK ")
        GetNodeListForPrecheckOrCommit(fsmNodeList, mdcNodeList, osdNodeList, clientNodeList);
        return getReturnResult();
    end
    local resultCode = 0;
    if (g_PRO_UpdState.Flow == g_PRO_Const.FLOW_NAME_COMMIT) then
        LogText(LL_INFO, "FLOW_NAME_COMMIT ")
        GetNodeListForPrecheckOrCommit(fsmNodeList, mdcNodeList, osdNodeList, clientNodeList);
        return getReturnResult();
    end

end

function HasAtomGroup(activeNodeIp, slaveNodeIp, nodeIp, FlowName, atomGroupName)
    local ag_upd = nil
    local ag_rbk = nil
    local orignActive = nil
    if ("PRECHECK" == FlowName) or ("COMMIT" == FlowName) then
        ag_upd = g_UpdateFlowsTbl[FlowName][g_PRO_Const.LOGIC_NODE_TYPE_FSM].upd
        if (g_UpdateFlowsTbl[FlowName][g_PRO_Const.LOGIC_NODE_TYPE_FSM].rbk ~= nil) then
            ag_rbk = g_UpdateFlowsTbl[FlowName][g_PRO_Const.LOGIC_NODE_TYPE_FSM].rbk
        end
    end

    for i = 1, #ag_upd do
        if (ag_upd[i].AtomGroupName == atomGroupName) then
            LogText(LL_NOTICE, "ip " .. nodeIp .. ",AtomGroup " .. atomGroupName .. " is found in ag_upd.");
            orignActive = ag_upd[i].OriginActive
        end
    end

    if (ag_rbk ~= nil) then
        for i = 1, #ag_rbk do
            if (ag_rbk[i].AtomGroupName == atomGroupName) then
                LogText(LL_NOTICE, "ip " .. nodeIp .. ", AtomGroup " .. atomGroupName .. " is found in ag_rbk.");
                orignActive = ag_rbk[i].OriginActive
            end
        end
    end

    if (nil == orignActive) then
        LogText(LL_NOTICE, "AtomGroup " .. atomGroupName .. " is not found.");
        return false
    end
    if (nodeIp == activeNodeIp) then
        return orignActive
    elseif (nodeIp == slaveNodeIp) then
        return not orignActive
    end
    return false
end

-------------------------------------------------------------------------------
--------------------------------- Flowִ end ----------------------------
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--------------------------------- Flow start ----------------------------
-------------------------------------------------------------------------------

-- Flow (ñÿִTaskʱluaļһ)
g_UpdateFlowsTbl =
{
    PRECHECK =
    {
        timeout = 30,
        FSM =
        {
            isRbk = false,
            upd =
            {
                -- FSMڵ㻷
                {AtomGroupName = "ManagerPreCheck", progress = 100, timeout = 20},
            },
        },
        MDC =
        {
            isRbk = false,
            upd =
            {
                -- FSAڵ㻷
                {AtomGroupName = "AgentPreCheck", progress = 100, timeout = 20},
            },
        },
        OSD =
        {
            isRbk = false,
            upd =
            {
                -- FSAڵ㻷
                {AtomGroupName = "AgentPreCheck", progress = 100, timeout = 20},
            },
        },
        Client =
        {
            isRbk = false,
            upd =
            {
                -- FSAڵ㻷
                {AtomGroupName = "AgentPreCheck", progress = 100, timeout = 20},
            },
        },
    },

    COMMIT =
    {
        timeout = 10,
        FSM =
        {
            isRbk = false,
            upd =
            {
                -- FSMļ
                {AtomGroupName = "FSMCommit", progress = 100, timeout = 10},

            },
        },
        MDC =
        {
            isRbk = false,
            upd =
            {
                -- FSAļ
                {AtomGroupName = "FSACommit", progress = 100, timeout = 10},
            },
        },
        OSD =
        {
            isRbk = false,
            upd =
            {
                -- FSAļ
                {AtomGroupName = "FSACommit", progress = 100, timeout = 10},
            },
        },
        Client =
        {
            isRbk = false,
            upd =
            {
                -- FSAļ
                {AtomGroupName = "FSACommit", progress = 100, timeout = 10},
            },
        },
    },

}

-------------------------------------------------------------------------------
--------------------------------- Flow end ------------------------------
-------------------------------------------------------------------------------
