--------------------------------------------------------------------------------
--                   Copyright, 2012-2013, Huawei Tech. Co., Ltd.
--                             All Rights Reserved
--------------------------------------------------------------------------------
-- Project Code    : OMM UPD V1.0
-- File name       : upd_atoms.lua
-- Description     : DSware Agentļ
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : ReturnWithOffset
-- Description     : Ϊԭӵķֵƫ
-- Caution         : OMMά, ޸
-- Input           : retֵ offsetƫ
-- Output          :
-- Return          : ƫ֮ķֵ
--------------------------------------------------------------------------------
-- Example         :
--                  function func()
--                      local ret=System("xxx.sh", timeout)
--                      return ReturnWithOffset(ret, offset)
--                  end
--------------------------------------------------------------------------------
function ReturnWithOffset(ret, offset)
    return ret + offset - OFFSET
end

--------------------------------------------------------------------------------
-- Func Name       : Serialize
-- Description     : лLua Table
-- Caution         : OMMά, ޸
-- Input           : o: Lua֧number/string/boolean/tabl/nil⼸
-- Output          :
-- Return          : رлַ֮
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : ļ
--------------------------------------------------------------------------------
function Serialize(o)
    local s = "";
    local t = type(o);
    if t == "number" then
        s = s .. o;
    elseif t == "string" then
        s = s .. string.format("%q", o);
    elseif t == "boolean" then
        s = s .. tostring(o);
    elseif t == "table" then
        s = s .. "{\n";
        for k,v in pairs(o) do
            s = s .. " [" .. Serialize(k) .. "] = " .. Serialize(v) .. ",\n";
        end

        s = s .. "}\n";
    elseif t == nil then
        return nil;
    else
       LogText(LL_ERROR, "Cannot serialize type: " .. type(o));
    end

    return s;
end

function Split(FullString, Separator)  
    local startIndex = 1  
    local splitIndex = 1  
    local splitArray = {}  
    while true do  
       local lastIndex = string.find(FullString, Separator, startIndex)  
       if not lastIndex then  
            splitArray[splitIndex] = string.sub(FullString, startIndex, string.len(FullString))  
            break  
       end  
       splitArray[splitIndex] = string.sub(FullString, startIndex, lastIndex - 1)  
       startIndex = lastIndex + string.len(Separator)  
       splitIndex = splitIndex + 1  
    end  
    return splitArray  
end 

function Division(FullString, Separator)
    local startIndex = 1
    local splitArray = {}

    local lastIndex = string.find(FullString, Separator, startIndex)  
    if not lastIndex then
        splitArray[1] = string.sub(FullString, startIndex, string.len(FullString))
        return splitArray
    end
    
    splitArray[1] = string.sub(FullString, startIndex, lastIndex - 1)  
    splitArray[2] = string.sub(FullString, lastIndex + 1, string.len(FullString))
    return splitArray
end

--滻еĲ
--------------------------------------------------------------------------------
-- Func Name       :
-- Description     :
-- Caution         :
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : ļ
--------------------------------------------------------------------------------
function ReplaceParam(Cmd)
    LogText(LL_INFO, "Replace param for cmd: " .. Cmd);

    local p = "";
    local W = "";
    for w in string.gmatch(Cmd, "%$%b()") do                --ƥ: $()
        W = string.gsub(w, "%W", "%%%1");                   --תеַ
        p = string.sub(w, 3, -2);
        Cmd = string.gsub(Cmd, W, g_UpdState.ParamList[p]); --滻
    end

    LogText(LL_INFO, "Replaced cmd: " .. Cmd);
    return Cmd;
end


-- tableתstring
function Table2String(paramTable)
    
    if (paramTable == nil) then
        return "{}"
    end

    local param = "{"
    for key, value in pairs(paramTable) do
        param = param .. key .. "='" .. value .. "',"
    end
    param = param .. "}"
    return param
end

-- ϵͳȡ
function Popen(command)
    local handle = io.popen(command)
    local result = handle:read("*a")
    handle:close()
    
    return result
end


--ϵͳ fsync ʹڴеˢӲ,ʧ
--ʹSystemֹfsyncס
function Fsync()
    LogText(LL_NOTICE, "Sync memery data to disk.");
    local ret;
    local cmd = "fsync /opt/omm/tmp/upd_state_atoms.lua";
    ret=System(cmd, 2);
    LogText(LL_NOTICE, "End to sync memery data to disk, result is " .. ret);
end