
--================== UPD Framwork API ==========================================
--------------------------------------------------------------------------------
-- Func Name       : LogText(level, message)
-- Description     : ־ӡ
-- Caution         : עLuaʹ
-- Input           : level: ־, LL_DEBUG, LL_INFO, LL_WARN, LL_ERROR, LL_NOTICE
--                   message: ӡϢ
-- Output          : 
-- Return          : 
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : ExecAtomGroup(flow_id, atom_group, node_ip, time_out, param_list)
-- Description     : ֪ͨڵִָAtomGroup
-- Caution         : עLuaʹ
-- Input           : atom_group: string ִеAtomGroup
--                   node_ip: string ڵIPַ
--                   timeout: int AtomGroupĳʱʱ,ȡAtomʱʱ
--                   param_list: string ServerഫݵAgentĲб
-- Output          : 
-- Return          : Ϣͽ, 0 -- ɹ -1 -- ʧ
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : System(cmd, timeout)
-- Description     : ִϵͳ
-- Caution         : עLuaʹ
-- Input           : cmd: ַ
--                   timeout: ִгʱʱ䣬λΪ
-- Output          : 
-- Return          : 0-127 -- ӽ̵ķֵ 128 -- ӽ쳣
--                   129 -- ӽ̳ʱ 130 -- ڲ
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : SyncState(file_name)
-- Description     : ͬ״̬ļ
-- Caution         : עLuaʹ
-- Input           : file_name: ͬ״̬ļȫ·
-- Output          : 
-- Return          : 
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : ReportAtomExecResult(node_ip, atom_group, atom, result, progress)
-- Description     : ϱԭִн
-- Caution         : עLuaʹ
-- Input           : node_ip: ڵIPַ    atom_group: AtomGroup
--                   atom: Atom           result: Atomִн
--                   progress: ǰAtomGroupִеĽ
-- Output          : 
-- Return          : ϱϢǷɹ 0 -- ɹ 1 -- ʧ
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.01.07
--    Modification : 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : ReportAtomGroup{flow_id, node_ip, atom_group, result}
-- Description     : ϱԭִн
-- Caution         : עLuaʹ
-- Input           : node_ip: ڵIPַ    atom_group: AtomGroup
--                   flow_id: ID           result: Atom groupִн
-- Output          : 
-- Return          : ϱϢǷɹ 0 -- ɹ 1 -- ʧ
--------------------------------------------------------------------------------
-- History         :
--  1 Date         : 2013.06.17
--    Modification : 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Func Name       : Serialize
-- Description     : LuaлΪַ
-- Caution         : OMMά, ޸
-- Input           : o: Lua֧number/string/boolean/tabl/nil⼸
-- Output          :
-- Return          : رлַ֮
--------------------------------------------------------------------------------
function Serialize(o)
    local s = "";
    local t = type(o);
    if (t == "number") then
        s = s .. o;
    elseif (t == "string") then
        s = s .. string.format("%q", o);
    elseif (t == "boolean") then
        s = s .. tostring(o);
    elseif (t == "table") then
        s = s .. "{\n";
        for k,v in pairs(o) do
            s = s .. " [" .. Serialize(k) .. "] = " .. Serialize(v) .. ",\n";
        end

        s = s .. "}\n";
    elseif t == nil then
        s = nil;
    else
        s = nil;
        LogText(LL_ERROR, "Cannot serialize type: " .. type(o));
    end

    return s;
end

--------------------------------------------------------------------------------
-- Func Name       : Table2String
-- Description     : tableתstring
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function Table2String(paramTable)

    if (paramTable == nil) then
        return "{}"
    end

    local param = "{";
    for key, value in pairs(paramTable) do
        param = param .. key .. "='" .. value .. "',";
    end
    param = param .. "}";
    return param;
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_SaveLua
-- Description     : ־ûLuaбϢ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_SaveLua(saveFile, saveContent)
    if (nil == saveFile or "" == saveFile) then
        LogText(LL_ERROR, "Param saveFile is empty.")
        return 0
    end
    
    if (nil == saveContent or "" == saveContent) then
        LogText(LL_ERROR, "Param saveContent is empty.")
        return 0
    end

    local s = Serialize(saveContent)
    LogText(LL_DEBUG, "Serialized saveContent:\n" .. s)

    local f = io.open(saveFile, "w+")
    if (nil == f) then
        LogText(LL_WARN, "Can not open node state file" .. saveFile)
        return 0
    end
    f:write(s);
    f:flush();
    f:close();
    
    if (g_UpdFrame_Const.HASingleMode == UpdFrame_GetHAMode()) then
        return SyncFile(saveFile)
    end
    
    return 0
end

--------------------------------------------------------------------------------
-- Func Name       : UpdFrame_LoadLua
-- Description     : ӳ־ûLuaмϢ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_LoadLua(loadFile)
    local f = io.open(loadFile, "r");
    if (nil == f) then
        LogText(LL_WARN, "Can not read file " .. loadFile .. ".");
        return nil;
    end
    
    local s = f:read("*all");
    f:close();
    if (s == nil) or (s == "") then
        LogText(LL_WARN, "File " .. loadFile .. "is blank.");
        return nil;
    end
    
    LogText(LL_INFO, "UpdFrame_LoadLua " .. s);
    s = "return " .. s;
    local func = loadstring(s);
    return func
end

--------------------------------------------------------------------------------
-- Func Name       : SaveLuaState
-- Description     : ־ûLuaбϢ
-- Caution         : OMMά, ޸
-- Input           :
-- Output          :
-- Return          :
--------------------------------------------------------------------------------
function UpdFrame_GetHAMode()
    if ("" ~= g_ClusterInfo.SlaveNode and nil ~= g_ClusterInfo.SlaveNode) then
        return g_UpdFrame_Const.HASingleMode
    else
        return g_UpdFrame_Const.HADoubleMode
    end
end

--------------------------------------------------------------------------------
-- Func Name       : to_s32
-- Description     : ֵתΪеs32ʽǰindexֵΪ[ip*100+tp*10+ltp]
--                   Ѿs32ıʾΧʹ
-- Caution         : OMMά, ޸
-- Input           : uNum ԭֵ
-- Output          :
-- Return          : תs32ֵ
--------------------------------------------------------------------------------
function to_s32(uNum)
    local tmp = uNum
    if (tmp >= 256 * 256 * 256 * 128) then
        return -(256 * 256 * 256 * 256  - tmp)
    else
        return tmp
    end
end

--------------------------------------------------------------------------------
-- Func Name       : Split
-- Description     : ַָ
-- Caution         : OMMά, ޸
-- Input           : FullString ԭַ
--                   Separator ָ
-- Output          :
-- Return          : ָı
--------------------------------------------------------------------------------
function Split(FullString, Separator)
    local startIndex = 1
    local splitIndex = 1
    local splitArray = {}
    while true do
        local lastIndex = string.find(FullString, Separator, startIndex)
        if not lastIndex then
            splitArray[splitIndex] = string.sub(FullString, startIndex, string.len(FullString))
            break
        end
        splitArray[splitIndex] = string.sub(FullString, startIndex, lastIndex - 1)
        startIndex = lastIndex + string.len(Separator)
        splitIndex = splitIndex + 1
    end
    return splitArray
end