#!/bin/sh

# Copyright (c) 2010-2012 Huawei.
# All rights reserved.
#


# Changelog:
#   * 2011-9-16 
#     Update the baseinfo xml for ISM service tool.
#   * 2011-6-10
#     Create script.


DEVICE="HDP3500E"
PRO_NAME=$(basename $0)
PRO_VERSION=1.23

RET=0

# MUST SET VARIABLE
INSPECT_CMD=hdpinspect
CHECK_ITEMS=
ACTION=
CHECK_ARG_STR="-f ism"

PRODUCT_NAME=''
PRODUCT_VERSION=''
TOOLS_VER='None'

PF=/etc/sysconfig/hsconfig
[ -f $PF ] && . $PF

G_CHECK_RESULT_FILE=/tmp/integration_result

function get_version_info ()
{
    local L_SPC003_VERSION_CMD='/bin/hdpversion'
    local L_SPC002_VERSION_FILE='/etc/hdp3500e-release'
   
    if [ -e "${L_SPC002_VERSION_FILE}" -a ! -e "${L_SPC003_VERSION_CMD}" ] ; then
        PRODUCT_NAME=`cat /etc/hdp3500e-release | sed -n '1p'`
        PRODUCT_VERSION=`cat /etc/hdp3500e-release | sed -n '2p' | awk -F= '{gsub(/^[ \t]+/,"",$2); print $2}'`
        if [ -f '/hdp3500e/bin/maintenance/hdpinspect' ]; then
            INSPECT_CMD='/hdp3500e/bin/maintenance/hdpinspect'
        fi
        # Get TOOLs info
        TOOLS_VER=`/hdp3500e/bin/install/hdpconfigwizard  -v | awk  '{print $2}'`
    elif [ ! -e "${L_SPC002_VERSION_FILE}" -a -x "${L_SPC003_VERSION_CMD}" ] ; then
        PRODUCT_NAME=`${L_SPC003_VERSION_CMD} | sed -n "/OceanStor/p"`
        PRODUCT_VERSION=`${L_SPC003_VERSION_CMD} | sed -n '2p' | awk -F'=' '{print $2}' | tr -d '\ '`
        if [ -f '/hdp3500e/bin/maintenance/hdpinspect' ]; then
            INSPECT_CMD='/hdp3500e/bin/maintenance/hdpinspect'
        fi
        TOOLS_VER=`/opt/ism/om/scripts/hdp_manage -v | tr -d '\ '`
    fi
}

function show_basic_info()
{
    rm $G_CHECK_RESULT_FILE 2>/dev/null
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"\"?>" >>$G_CHECK_RESULT_FILE
    echo "<device>" >>$G_CHECK_RESULT_FILE
    echo "    <sysinfo>" >>$G_CHECK_RESULT_FILE	    
    # Get base info
    echo "        <field name=\""Product_Name"\">$PRODUCT_NAME</field>" >>$G_CHECK_RESULT_FILE
    echo "        <field name=\""Device_Model"\">$DEVICE</field>" >>$G_CHECK_RESULT_FILE
    echo "        <field name=\""Product_Version"\">$PRODUCT_VERSION</field>" >>$G_CHECK_RESULT_FILE

    #check dmidecode  tool
    local Manufacturer='Huawei Technologies Co., Ltd'
    dmidecode -t chassis >/dev/null
    if [ $? -ne 0 ]; then
        echo "[EE] dmidecode is not found or Get FRU information failed."
        Manufacturer='None'
        Serial='None'
    else
        Serial=`dmidecode -t chassis | grep "Serial Numbe"| awk -F ':' '{print $2}' | tr -d '\ '`
    fi
    echo "        <field name=\""Serial_Number"\">$Serial</field>" >>$G_CHECK_RESULT_FILE

    OS1=`grep SUSE /etc/SuSE-release`
    OS2=`grep PATCHLEVEL /etc/SuSE-release | awk '{print $1,$3}'`
    OS_INFO="$OS1 $OS2"

    # Get NBU info
    NBU_VER_F=/usr/openv/netbackup/version

    if [ -f $NBU_VER_F ]; then
        NBU_VER=`sed -ne '/VERSION/s@VERSION[[:blank:]]*\(.*\)@\1@p' $NBU_VER_F`
    fi

    # Get snmp version
    SNMP_VER=$( (/etc/init.d/hdpsnmpd version | cut -d' ' -f2) 2> /dev/null)
    echo ${SNMP_VER} | grep '^[0-9]' > /dev/null 2>&1 || SNMP_VER=""

    echo "        <field name=\""Backup_Software"\">$NBU_VER</field>" >>$G_CHECK_RESULT_FILE
    echo "        <field name=\""Operation_System"\">$OS_INFO</field>" >>$G_CHECK_RESULT_FILE
    echo "        <field name=\""Tools_Version"\">$TOOLS_VER</field>" >>$G_CHECK_RESULT_FILE
    echo "        <field name=\""HDPSNMPD_Version"\">$SNMP_VER</field>" >>$G_CHECK_RESULT_FILE
    echo "        <field name=\""Manufacturer"\">$Manufacturer</field>" >>$G_CHECK_RESULT_FILE
    echo "    </sysinfo>" >>$G_CHECK_RESULT_FILE
    echo "</device>" >>$G_CHECK_RESULT_FILE
    cat $G_CHECK_RESULT_FILE
}    

function usage ()
{
    cat <<EOF
Inspect uitility for $DEVICE.
Usage: $PRO_NAME [OPTION] [CHECK_ID]

    -c ID
        check the item specified by ID

    -l | --list
        list supported check

    -v  output version information and exit
    -h  display this help and exit

EOF

    [ "$#" -eq 0 ] && RET=0 || RET=$1

    exit $RET
}


function run_check ()
{
    if [ "X$CHECK_ITEMS" = "X " ]; then
        echo "You have not specified any CHECK ID for -c option."
        echo "For help, use -h options."
        exit 1
    fi
    if [ "X$CHECK_ITEMS" = "X baseinfo" ] || [ "X$CHECK_ITEMS" = "X f1" ]; then
	show_basic_info
    else
    	for x in $CHECK_ITEMS; do
        	$INSPECT_CMD -c $x $CHECK_ARG_STR
        	let RET+=$?
        	echo
    	done
    fi
}


function parse_option ()
{
    while [ -n "$1" ]; do
        case "$1" in

            -c|--check)
                shift
                echo "$1"  | grep -E '[^a-zA-Z0-9-]+'
                if [ $? -eq 0 ]; then
                    echo -e "Unknown CHECK ID: $1\n"
                    usage 1
                else
                    CHECK_ITEMS="$CHECK_ITEMS $1"
                fi
                echo "$ACTION" | grep check > /dev/null 2>&1
                [ $? -eq 0 ] || ACTION="$ACTION check"
                ;;

            -l|--list)
                echo "$ACTION" | grep list > /dev/null 2>&1
                [ $? -eq 0 ] || ACTION="$ACTION list"
                ;;

            -d|--debug)
                DEBUG=1
                ;;

            -h|--help)
                usage 0
                ;;

            -v|-V|--version)
                echo "$PRO_NAME V${PRO_VERSION}"
                exit 0
                ;;

            *)
                echo -e "Unknown option: $1\n"
                usage 1
                ;;

        esac
        shift
    done
}


# Main: Start from here
parse_option $@
get_version_info
[ -z "$ACTION" ] && usage 1

for x in $ACTION; do
    case "$x" in

        list)
            $INSPECT_CMD -l
            ;;

        check)
            run_check
            ;;

        *)
            echo "Unknown ACTION: \"$ACTION\""
            echo "For help, use -h options."
            exit 2
            ;;

    esac
done

exit $RET
