# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import preCheck
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

queryWWNFailures = []
queryAluaFailures = []

robinNotPassDisks = []
evaluateNotPassDisks = []
cliRets = []

INDEX_INT6 = 6
LENGTH_INT38 = 38
lineBreak = '\n'
LINE_SIZE_INT2 = 2

def execute(ssh):
    '''
    @summary: AIX自带多路径双活LUN配置检查
    '''  
    try:
        is_upadmin_designated, echos = common.mark_host_upadmin_hyper_metro_luns(py_java_env, ssh, LOGGER)
        if is_upadmin_designated:
            return cliUtil.RESULT_NOSUPPORT, echos, ''
        #白名单检查
        py_java_env["logger"] = PY_LOGGER
        py_java_env["ssh"] = ssh
        checkFlag, cliRet, errMsg = preCheck.execute(py_java_env)
        cliRet += echos
        if checkFlag != True:
            return checkFlag, cliRet, errMsg
        arrayWwnDict = getArrayWwns(py_java_env)
        if not arrayWwnDict:
            return (True, '', '')  
        cliRets.append(cliRet)
        executeStatus, disks = queryHuaweiDisk(py_java_env, ssh)
        if not executeStatus:
            return (cliUtil.RESULT_NOCHECK, lineBreak.join(cliRets),
                    common.getMsg(LANG, "hyper.metro.host.disks.query.failure"))          
        if not disks:
            return (False, lineBreak.join(cliRets), common.getMsg(LANG, "hyper.metro.host.query.multipath.not.take.lun"))
        diskWwnDict = getValidDiskDict(disks, arrayWwnDict, ssh)
        LOGGER.logInfo("***[diskWwnDict is: %s]***" % diskWwnDict)
        if not diskWwnDict:
            return (False, lineBreak.join(cliRets), common.getMsg(LANG, "hyper.metro.host.query.multipath.not.take.lun"))
        return handleResultAndErrorMsg(evaluateDiskAlua(diskWwnDict, arrayWwnDict, ssh))   
    except BaseException, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, lineBreak.join(cliRets), common.getMsg(LANG, "query.result.abnormal"))

def updateHostAluaStatus(arrayWwnDict, wwn, status):
    if wwn not in arrayWwnDict:
        return
    LOGGER.logInfo("***[update the host alua status for the lun wwn: %s is: %s]***" % (wwn, status))
    arrayWwnDict[wwn]['hostAluaStatus'] = status

def getArrayWwns(py_java_env):
    arrayWwnDict = py_java_env.get('allStrgHyprMtrLns')
    return arrayWwnDict

def handleResultAndErrorMsg(evaluateResult):
    '''
    @summary: handle result and construct error message
    ''' 
    errorMsg = ''
    if queryWWNFailures:
        evaluateResult = cliUtil.RESULT_NOCHECK
        errorMsg += common.getMsg(LANG, "hyper.metro.disk.wwn.query.failure", ','.join(queryWWNFailures))
    if queryAluaFailures:
        evaluateResult = cliUtil.RESULT_NOCHECK
        errorMsg += common.getMsg(LANG, "hyper.metro.alua.query.failure", ','.join(queryAluaFailures)) 
    if robinNotPassDisks:
        evaluateResult = False
        errorMsg += common.getMsg(LANG, "hyper.metro.alua.evaluate.notpass.robin", ','.join(robinNotPassDisks))
    if evaluateNotPassDisks:
        evaluateResult = False
        errorMsg += common.getMsg(LANG, "hyper.metro.alua.evaluate.notpass.step6", ','.join(evaluateNotPassDisks))          
    return (evaluateResult, lineBreak.join(cliRets), errorMsg)

def evaluateDiskAlua(diskWwnDict, arrayWwnDict, ssh):
    global robinNotPassDisks, evaluateNotPassDisks, queryAluaFailures
    evaluateResult = True
    for diskWwn in diskWwnDict:
        disk = diskWwnDict.get(diskWwn)
        
        # 步骤5检查 磁盘多路径配置信息中是否包含 algorithm round robin
        executeStatus, checkResult = queryAndCheckDiskAlua(disk, py_java_env, ssh)
        evaluateResult = evaluateResult and checkResult            
        if not executeStatus:
            queryAluaFailures.append(disk)
            updateHostAluaStatus(arrayWwnDict, diskWwn, -1)
            LOGGER.logInfo("***[query the disk : %s alua info failure]***" % disk)
            continue
        
        if not checkResult:
            LOGGER.logInfo("***[the disk: %s is not pass]***" % disk)
            robinNotPassDisks.append(disk)
            updateHostAluaStatus(arrayWwnDict, diskWwn, -1)
            continue
        
        # 检查MPIO ALUA配置OPT和Non
        executeStatusMpio, checkResultMpio = getMpioPathStatus(py_java_env, ssh, disk)
        evaluateResult = executeStatusMpio and checkResultMpio
        if not executeStatusMpio:
            queryAluaFailures.append(disk)
            updateHostAluaStatus(arrayWwnDict, diskWwn, -1)
            LOGGER.logInfo("***[query the disk : %s alua info failure]***" % disk)
            continue
        
        if not checkResultMpio:
            LOGGER.logInfo("***[the disk: %s is not pass]***" % disk)
            evaluateNotPassDisks.append(disk)
            updateHostAluaStatus(arrayWwnDict, diskWwn, -1)
            continue
        
        # 如果配置都正确则，更新为正确状态1
        updateHostAluaStatus(arrayWwnDict, diskWwn, 1)  
          
    return evaluateResult 

def getValidDiskDict(disks, arrayWwnDict, ssh):
    global queryWWNFailures
    diskWwnDict = {}
    for disk in disks:
        executeStatus, wwn = queryDiskWwn(disk, py_java_env, ssh)
        LOGGER.logInfo("***[the disk is : %s,  the executeStatus: %s, the wwn is: %s]***" % (disk, executeStatus, wwn))
        if not executeStatus:
            queryWWNFailures.append(disk)
            continue
        valildWwn = filter(lambda arrayWwn : arrayWwn.lower() == wwn.lower(), arrayWwnDict.keys())
        if valildWwn:
            updateHostAluaStatus(arrayWwnDict, valildWwn[0], 1)
            diskWwnDict[valildWwn[0]] = disk
    return diskWwnDict

def queryHuaweiDisk(context, ssh):
    '''
    @summary: query the available huawei disks
    @return: (execute status: True or False, disk list)
    '''
    try:
        disks = []
        cmd = 'lsdev -Cc disk'
        executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.logInfo("***[execute queryHuaweiDisk failure, errorMsg is: %s]***" % errorMsg)
            return False, disks 
        for line in cliRet.splitlines():
            avilableDisk = filter(lambda item : item.lower() == 'available', line.split())
            if not avilableDisk:
                continue
            diskName = line.strip().split()[0]
            if diskName:
                disks.append(diskName)
        LOGGER.logInfo("execute queryHuaweiDisk, disks is : %s" % disks)
        return True, disks
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("queryHuaweiDisk ==> " + msg)
        return False, []
        
def queryDiskWwn(disk, context, ssh):
    '''
    @summary: query disk wwpn from host
    @return: (execute status: True or False, WWN)
    '''
    try:
        cmd = 'odmget -q "name=%s and attribute=unique_id" CuAt' % disk
        wwn = ''
        executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.logInfo("***[queryDiskWwn failure, cliRet is: %s, errorMsg is: %s]***" % (cliRet, errorMsg))
            return False, wwn
        if len(cliRet.splitlines()) <= LINE_SIZE_INT2:
            LOGGER.logInfo("***[the disk: %s is not taken over by nmp]***" % disk)
            return True, wwn
        for line in cliRet.splitlines():
            stripLine = line.strip()
            if not stripLine.lower().startswith('value'):
                continue
            splitDatas = stripLine.split('=')
            valuePart = splitDatas[-1].strip()
            if len(splitDatas) > 1 and len(valuePart) >= LENGTH_INT38:
                wwn = valuePart[INDEX_INT6:LENGTH_INT38]
                return True, wwn
        return False, wwn
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("queryDiskWwn ==> " + msg)
        return False, False

def queryAndCheckDiskAlua(disk, context, ssh):
    '''
    @summary: query the alua configure information of disk and check the information
    @return: (execute status: True or False, check result: True or False)
    '''
    try:
        cmd = 'lsattr -EHl %s | cat' % disk
        executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.logInfo("***[query the disk : %s alua info failure, the errorMsg is : %s]***" % (disk, errorMsg))
            return False, False
        for line in cliRet.splitlines():
            stripLine = line.strip()
            if not stripLine.lower().startswith('algorithm'):
                continue
            if 'round_robin' in stripLine.lower():
                return True, True
            else:
                return True, False
        return False, False
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("queryAndCheckDiskAlua ==> " + msg)
        return False, False

def getMpioPathStatus(context, ssh, diskNum):
    '''
    @summary: get current disk's mpio path status
    @return: isQueryOk, isPathAlua
    '''
    cmd = "lsmpio -l " + str(diskNum)
    try:
        LOGGER.logInfo("now start to query disk%s's multipath path status." % str(diskNum))
        isSucc, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cliRet)
        if not isSucc:
            LOGGER.logInfo("failed to query disk%s's multipath path status." % str(diskNum))
            return False, False
        hasAoPath = False
        hasAnPath = False
        for line in cliRet.splitlines():
            if 'opt' in line.lower():
                hasAoPath = True
                LOGGER.logInfo("found disk%s's working optimal path(AO)." % str(diskNum))
                continue
            if 'non' in line.lower():
                hasAnPath = True
                LOGGER.logInfo("found disk%s's None working path(AN)." % str(diskNum))
                continue
        if hasAnPath and hasAoPath:
            LOGGER.logInfo("found disk%s's working AN&AO path, alua configuration passed." % str(diskNum))
            return True, True    
        else:
            LOGGER.logInfo("disk%s's multipath is not ALUA compatible." % str(diskNum))
            return True, False
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("checking disk's mpio status but failed:" + msg)
        return False, False