﻿# -*- coding: UTF-8 -*-

def getMsg(lang, msg, args = ""):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @return: 经过国际化处理后的消息
    '''
    errMsg = "\n--"

    try:
        if not MESSAGES_DICT.has_key(msg):
            return errMsg

        localeDict = MESSAGES_DICT.get(msg)
        if not localeDict.has_key(lang):
            return errMsg

        localeMsg = localeDict.get(lang)
        if "%s" in localeMsg or "%i" in localeMsg:
            return localeMsg % args
        else:
            return localeMsg

    except:
        return errMsg


MESSAGES_DICT = {
"query.result.abnormal":
    {
        "zh":u"\n获取信息失败",
        "en":"\nThere is an error in getting information",
    },

"Host.NotSupport.error":
    {
        "zh":u"\n当前工具不支持此主机（操作系统类型：%s）的评估，请参考《华为SAN存储使用操作系统自带多路径的双活配置指南》手工确认。",
        "en":"\nThe current tool does not support evaluation of this host (operating system type: %s). For details, see the HyperMetro Configuration Guide for Huawei SAN Storage Using OS Native Multipathing Software.",
    },
    "Host.Not.In.WhiteList.error":
        {
            "zh": u"\n当前工具不支持此主机（操作系统类型：%s）的评估，"
                  u"请联系技术工程师协助处理。",
            "en": "\nThe current tool does not support evaluation "
                  "of this host (operating system type: %s), "
                  "Contact technical support engineers.",
        },
    "get.hyper.data.failed":
        {
            "zh": u"\n命令执行失败，设备SN:%s, 命令:%s",
            "en": "\nFailed to run the command, sn:[%s], cmd:[%s]"
        },
}
