# -*- coding: UTF-8 -*-
import pyEnv
import cli_windows
import whiteListCheck
import constant


def execute(context):
    '''
    添加主机时的检查项
    :param context: 上下文
    :return: 检查结果
    '''

    # 获取设备信息，通过devName获取主机类型
    # 根据不同类型有不同的多路径判断方法
    dev_name = pyEnv.getDeviceName(context)
    ssh = pyEnv.getSSH(context)
    logger = pyEnv.getLogger(context)

    is_huawei_mutipath, cliRet = judge_huawei_mutipath(ssh, dev_name, logger)
    if is_huawei_mutipath:
        return constant.RESULT_PASS, cliRet, ""
    else:
        logger.info("Multipath check does not pass,cliRet is" + str(cliRet))
        flag, cli_ret, msg = whiteListCheck.execute(context)
        if flag is not False:
            return flag, cli_ret, msg

        return whiteListCheck.execute_doradov6(context)


def judge_huawei_mutipath(ssh, os_type, logger):
    cliRet = ""
    is_huawei_mutipath = False
    if os_type == "Linux":
        is_huawei_mutipath, cliRet = judge_mutipath(ssh)
    elif os_type == "VMware":
        is_huawei_mutipath, cliRet = judge_mutipath_vmware(ssh)
    elif os_type == "Windows":
        is_huawei_mutipath, cliRet = judge_mutipath_windows(ssh, logger)
    elif os_type == "Solaris":
        is_huawei_mutipath, cliRet = judge_mutipath(ssh)
    elif os_type == "HP-UX":
        is_huawei_mutipath = False
    elif os_type == "AIX":
        is_huawei_mutipath, cliRet = judge_mutipath(ssh)
    elif os_type == "FusionSphere":
        is_huawei_mutipath, cliRet = judge_mutipath(ssh)
    return is_huawei_mutipath, cliRet


def judge_mutipath(ssh):
    cmd = "upadm show version"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3 * 60)
    if "Error" in cliRet or "Unknown command" in cliRet \
            or "command not found" in cliRet \
            or "command-not-found" in cliRet:
        return False, cliRet
    else:
        return True, cliRet


def judge_mutipath_vmware(ssh):
    cmd = "esxcli upadm show version"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3 * 60)
    if "Error" in cliRet or "Unknown command" in cliRet \
            or "command not found" in cliRet \
            or "command-not-found" in cliRet:
        return False, cliRet
    else:
        return True, cliRet


def judge_mutipath_windows(ssh, logger):
    cmd = "upadm show version"
    flag, cliRet, errMsg = cli_windows.execute_cmd_with_timeout(ssh, cmd,
                                                                logger)
    if "Error" in cliRet or "Unknown command" in cliRet \
            or "command not found" in cliRet \
            or "command-not-found" in cliRet \
            or u'不是内部或外部命令' in cliRet \
            or u'不是可运行的程序' in cliRet \
            or 'is not recognized as an internal or external command' \
            in cliRet or 'operable program or batch file' in cliRet:
        return False, cliRet
    else:
        return True, cliRet
