# -*- coding: UTF-8 -*-
import java.lang.Exception as JException

RESULT_NOCHECK = "NOCHECK"
RESULT_NOSUPPORT = "NOSUPPORT"
RESULT_WARNING = "WARNING"
HOST_CMD_TIMEOUT = 5 * 60
TIMEOUT_PLACE_HOLDER = "TOOLKIT_SEND_CMD_TIME_OUT"
CMD_FAILED_PLACE_HOLDER = "TOOLKIT_EXE_CMD_FAILED"


def execute_cmd_with_timeout(ssh_con, cmd, LOGGER, timeout=HOST_CMD_TIMEOUT,
                             is_local_wmic=False):
    '''
    @summary: execute command  with time out parameters
    '''
    cli_ret = ''
    try:
        if is_local_wmic:
            cli_ret = ssh_con.executeCmdTimeoutLcalWmic(cmd, timeout)
        else:
            cli_ret = ssh_con.execCmdRemoteTimout(cmd, timeout)
        if not cli_ret or len(cli_ret.splitlines()) < 2 \
                or TIMEOUT_PLACE_HOLDER in cli_ret \
                or CMD_FAILED_PLACE_HOLDER in cli_ret:
            return False, cli_ret, ''
        return True, cli_ret, ''
    except BaseException as bexcp:
        LOGGER.logException(bexcp)
        return False, cli_ret, ''
    except JException as jexcp:
        LOGGER.logNoPass("Java.lang.exception: " + unicode(jexcp.toString()))
        return False, cli_ret, ''
