# -*- coding: UTF-8 -*-

def getLang(py_java_env):
    '''
    @summary: 从上下文中获取lang
    @param py_java_env: 上下文对象
    @return: lang
    '''
    return py_java_env.get("lang")

def getSSH(py_java_env):
    '''
    @summary: 从上下文中获取ssh
    @param py_java_env: 上下文对象
    @return: ssh
    '''
    return py_java_env.get("ssh")

def getLogger(py_java_env):
    '''
    @summary: 从上下文中获取ssh
    @param py_java_env: 上下文对象
    @return: ssh
    '''
    return py_java_env.get("logger")

def getCurDeviceInfo(py_java_env):
    """
    @summary: query the device info from java env context
    """
    dev = py_java_env.get("devInfo")
    
    return dev

def getDeviceType(py_java_env):
    """
    @summary: query the device type from java env context
    """
    dev = getCurDeviceInfo(py_java_env)
    return str(dev.getDeviceType())

def getDeviceVersion(py_java_env):
    """
    @summary: query the device version from java env context
    """
    dev = getCurDeviceInfo(py_java_env)
    return dev.getProductVersion()

def getDeviceName(py_java_env):
    """
    @summary: query the device name from java env context
    """
    dev = getCurDeviceInfo(py_java_env)
    return dev.getDeviceName()
