# -*- coding: UTF-8 -*-

import common
import cliUtil
import preCheck
import traceback
import re
from common import UnCheckException

LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ""
LANG = py_java_env.get("lang")

def execute(ssh):
    '''
          双活LUN的ALUA状态检查
    '''
    global ALL_CLI_RET
    context = py_java_env
    cliRet = ""

    try:
        
        # 更新新版本时内存中的LUN标记。老版本时检查项内部已会去标记。
        common.mark_host_upadmin_hyper_metro_luns(py_java_env, ssh, LOGGER)
        
        # 获取华为双活LUN的信息
        hyperMetroLUNDict = context.get("allStrgHyprMtrLns")
        if not hyperMetroLUNDict:
            return (True, cliRet, "")

        # 阵列侧双活LUN
        hyperMetroLunWwnList = hyperMetroLUNDict.keySet()
        LOGGER.logInfo("Remote Hyper Metro LUN info: " + str(hyperMetroLunWwnList))
        if not hyperMetroLunWwnList:
            return (True, cliRet, "")

        # 风险lun
        riskLunWwnList = []

        # 判断upadm版本信息
        softVer = getHostMutipathVersion(ssh)
        if not softVer:
            # 使用老版本命令查询,判断主机上是否映射了双活LUN。
            softVer, riskLunWwnList = checkOldMutiPath(ssh, hyperMetroLunWwnList)
            LOGGER.logInfo("softVer:%s, riskLunWwnList: %s" % (softVer, str(riskLunWwnList)))
            if not softVer:
                return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''
            if riskLunWwnList:
                updateHyperMetroLUNDict(riskLunWwnList)
                return False, ALL_CLI_RET, common.getMsg(LANG, "hypermetro.mutipath.version.lower", softVer)

            return True, ALL_CLI_RET, ''

        if checkSoftVersion(softVer):
            # 获取华为LUN的信息
            lunWwnList = getHostMappingLun(ssh)
            if not lunWwnList:
                return True, ALL_CLI_RET, ""

            LOGGER.logInfo("LUN info in host:%s " % str(lunWwnList))
            for lunWwn in lunWwnList:
                if lunWwn in hyperMetroLunWwnList:
                    riskLunWwnList.append(lunWwn)

        LOGGER.logInfo("riskLunWwnList: %s" % str(riskLunWwnList))
        if riskLunWwnList:
            updateHyperMetroLUNDict(riskLunWwnList)
            return False, ALL_CLI_RET, common.getMsg(LANG, "hypermetro.mutipath.version.lower", softVer)

        return (True, ALL_CLI_RET, '')

    except UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if unCheckException.flag is None:
            return cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg

        return unCheckException.flag, unCheckException.cliRet, unCheckException.errorMsg

    except:
        LOGGER.logException()
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal")

def updateHyperMetroLUNDict(lunWwnList):
    """
    更新低版本做双活的LUN，不在【主机自带多路径双活LUN配置检查】中显示。
    :param lunWwnList:低版本做双活的LUN
    :return:
    """
    lun_wwn_dicts = py_java_env.get("allStrgHyprMtrLns")
    for lun_wwn in lunWwnList:
        if lun_wwn_dicts[lun_wwn]["hostAluaStatus"] == common.ALUA_CONFIGURED_NOT_CHECK:
            lun_wwn_dicts[lun_wwn]["hostAluaStatus"] = common.ALUA_CONFIGURED_PROPERLY
            LOGGER.logInfo("found lun(WWN: %s) matched storage devs',which is desiginated to upadmin service." % \
                       str(lun_wwn))
            
            
def checkSoftVersion(softVer):
    """
    判断版本是否是老版本
    :param softVer:
    :return:
    """
    if softVer.startswith("8") and softVer < "8.03.028":
        return True
    elif int(softVer.split(".")[0]) < 8:
        return True

    return False


def checkOldMutiPath(ssh, hyperMetroLunWwnList):
    """
    检查老版本多路径，判断主机上是否映射了双活LUN。
    :param ssh:
    :param hyperMetroLunWwnList:
    :return:
    """
    riskLunWwnList = []
    softVer = getOldMutiPathVersion(ssh)
    if not softVer:
        return '', riskLunWwnList

    # 判断版本信息是否为旧版本。
    if checkSoftVersion(softVer):
        # 检查lun信息
        arrayList = getArrayInfo(ssh)
        LOGGER.logInfo("arrayList: %s" % str(arrayList))
        if not arrayList:
            return softVer, riskLunWwnList

        lunWwnList = getLunInfoByArrayId(ssh, arrayList)
        LOGGER.logInfo("getLunInfoByArrayId lunWwnList: %s" % str(lunWwnList))
        if not lunWwnList:
            return softVer, riskLunWwnList

        for lunWwn in lunWwnList:
            if lunWwn in hyperMetroLunWwnList:
                riskLunWwnList.append(lunWwn)

    return softVer, riskLunWwnList


def getHostMutipathVersion(ssh):
    """
    获取主机上多路径版本
    :param ssh:
    :return: flag, softVer
            flag:True 获取成功，False 获取失败
            softVer: 版本信息
    """
    global ALL_CLI_RET
    cmd = "upadmin show version"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3*60)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if "Error" in cliRet or "Unknown command" in cliRet or "command not found" in cliRet or "command-not-found" in cliRet:
        return ''
    
    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x : x in cliRet.lower(), regx):
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "UltraPath Software Version"), ALL_CLI_RET)
    
    cliRetLines = cliRet.splitlines()
    softVer = ''
    driverVer = ''
    for line in cliRetLines:
        if "Software Version" in line:
            lineList = line.split(":")
            if len(lineList) == 2:
                softVer = lineList[1].strip()
            continue

        if "Driver   Version" in line:
            lineList = line.split(":")
            if len(lineList) == 2:
                driverVer = lineList[1].strip()

    if softVer and driverVer and softVer == driverVer:
        return softVer

    if softVer != driverVer:
        raise UnCheckException(common.getMsg(LANG, "multipath.softwareVersion.not.equal.driverVersion"), ALL_CLI_RET,
                               False)

    return ''


def getOldMutiPathVersion(ssh):
    """
    获取老版本多路径版本信息
    :param ssh:
    :return:
    """
    global ALL_CLI_RET
    cmd = "upadm show version"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3*60)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if "Error" in cliRet or "Unknown command" in cliRet or "command not found" in cliRet or "command-not-found" in cliRet:
        return ''
    
    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x : x in cliRet.lower(), regx):
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "UltraPath Software Version"), ALL_CLI_RET)
    
    
    cliRetLines = cliRet.splitlines()
    softVer = ''
    for line in cliRetLines:
        if "UltraPath for Linux" in line:
            lineList = line.split(":")
            if len(lineList) == 2:
                softVer = lineList[1].strip()
            continue

    if softVer:
        return softVer

    if not softVer:
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "UltraPath Software Version"), ALL_CLI_RET)


def getArrayInfo(ssh):
    """
    获取阵列信息
    :param ssh:
    :return:
    """
    global ALL_CLI_RET
    arrayIdList = []
    cmd = "upadm show array"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3*60)
    if not cliRet:
        return arrayIdList
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if "Error" in cliRet or "Unknown command" in cliRet or "command not found" in cliRet or "command-not-found" in cliRet:
        return arrayIdList
    
    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x : x in cliRet.lower(), regx):
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET)
    
    cliRetLines = cliRet.splitlines()
    isTitleLine = False
    for line in cliRetLines:
        if not isTitleLine and "Array ID" and "WWN" in line:
            isTitleLine = True
            continue

        if isTitleLine:
            lineList = line.split()
            if not len(lineList) >= 3:
                continue

            arrayId = lineList[0].strip()
            if arrayId:
                arrayIdList.append(arrayId)
    return arrayIdList


def getLunInfoByArrayId(ssh, arrayList):
    """
    获取映射的LUN信息
    :param ssh:
    :param arrayList:
    :return:
    """
    global ALL_CLI_RET
    lunWwnList = []
    cmd = "upadm show lun array=%s"
    for arrayId in arrayList:
        cmdStr = cmd % arrayId
        cliRet = ssh.execCmd(cmdStr)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
        if filter(lambda x : x in cliRet.lower(), regx):
            raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET)
    
        cliRetLines = cliRet.splitlines()
        for cliLine in cliRetLines:
            if "Information of Lun" in cliLine and "WWN" in cliLine:
                lineList = cliLine.split(":")
                if len(lineList) < 2:
                    continue

                wwn = lineList[1].strip().split()[0]
                lunWwnList.append(wwn)
    return lunWwnList


def getHostMappingLun(ssh):
    """
    获取主机上映射的LUN信息
    :param ssh:
    :return:
    """
    global ALL_CLI_RET
    lunWwnList = []
    cmd = "upadmin show vlun"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3*60)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if "Error" in cliRet or "Unknown command" in cliRet or "command not found" in cliRet \
        or "command-not-found" in cliRet or "Can't find any vluns" in cliRet:
        return lunWwnList
    
    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x : x in cliRet.lower(), regx):
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "vlun"), ALL_CLI_RET)
    
    cliRetLines = cliRet.splitlines()
    isFindTitle = False
    for cliLine in cliRetLines:
        if not isFindTitle and "Vlun ID".lower() in cliLine.lower():
            isFindTitle = True
            continue

        if isFindTitle:
            coloumList = cliLine.split()
            if not len(coloumList) >= 4:
                continue

            lunWWN = coloumList[3]
            lunWwnList.append(lunWWN)

    return lunWwnList
