# -*- coding: UTF-8 -*-
import re
import time
import decimal
import resource
import os
import logger
import traceback
import datetime
import pickle
import cliUtil
CLI_RET_KEY = 'cliRet'
ERROR_MSG_KEY = 'errMsg'
FLAG_KEY = 'flag'
DIR_RELATIVE_CMD = "..{}..".format(os.sep)
HYPERMETRO_DATA = "{0}tools{0}inspector{0}hypermetroData".format(os.sep)
SLEEP_TIMES = 30
PORTS_BIT_ERROR_SPEC = 60
PORTS_BIT_ERROR_INTERVAL = 30
SERIAL_NUMBER_LENGTH = 20
THRESHOLD_BBU_REMAINING_LIFETIME = 90
THRESHOLD_CONTRL_CPU_USAGE = 80
ALUA_CONFIGURED_PROPERLY = 1
ALUA_CONFIGURED_FALSELY = -1
ALUA_CONFIGURED_NOT_CHECK = 0
HOST_CMD_TIMEOUT = 5 * 60
HOST_CMD_SHORT_TIMEOUT = 2 * 60
LINUX_UPSCAN_CMD_TIMEOUT = 10 * 60


FILE_SUFFIX = "."

def getLang(py_java_env):
    '''
    @summary: 从上下文中获取lang
    @param py_java_env: 上下文对象
    @return: lang
    '''
    return py_java_env.get("lang")

def getCurDeviceInfo(py_java_env):
    """
    @summary: query the device info from java env context
    """
    dev = py_java_env.get("devInfo")
    
    return dev
    

def getMsg(lang, msg, args = ""):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @param resource: 消息字典
    @return: 经过国际化处理后的消息
    '''
    errMsg = "\n--"

    try:
        if not resource.MESSAGES_DICT.has_key(msg):
            return errMsg

        localeDict = resource.MESSAGES_DICT.get(msg)
        if not localeDict.has_key(lang):
            return errMsg

        localeMsg = localeDict.get(lang)
        if "%s" in localeMsg or "%i" in localeMsg:
            return localeMsg % args
        else:
            return localeMsg

    except:
        return errMsg
    
def getLogger(loggerInstance, pyFilePath):
    '''
    @summary: 获取日志类
    @param loggerInstance: logger实例
    @param pyFilePath: py文件路径
    '''
    pyFileName = getBaseName(pyFilePath)
    return logger.Logger(loggerInstance, pyFileName)

def getBaseName(file_path):
    '''
    @summary: 返回文件路径的文件名，不包含后缀
    @param file_path:文件路径
    @return: 返回不包含后缀的文件名字符串
    '''
    file_name = os.path.basename(file_path)
    if FILE_SUFFIX in file_name:
        dot_index = file_name.rindex(FILE_SUFFIX)
        return file_name[0:dot_index]
    else:
        return file_name

def getSnFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备SN。
    """
    return devNode.getDeviceSerialNumber()


def getIpFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备IP。
    """
    return devNode.getIp()


def getNameFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备名称。
    """
    return devNode.getDeviceName()


def getRemoteSNsFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备关联的远程设备SN。
    """
    return devNode.getRemoteSNs()


def getDevNodeFromContext(py_java_env):
    """
    @summary: 从工具箱的缓存中获取当前设备DevNode对象。
    """
    return py_java_env.get("devInfo")


def getHostTypeFromContext(py_java_env):
    """
    @summary: 从工具箱的缓存中获取当前设备的产品类型
    """
    devNode = getDevNodeFromContext(py_java_env)
    if not devNode:
        return ""
    return str(devNode.getDeviceType())

def mark_host_upadmin_hyper_metro_luns(context, sshCon, LOGGER):
    '''
    @summary: get hyperMetro luns on host whose been designated to upadmin
    '''
    used_utralpath = 1
    not_used_utralpath = 2

    echos = ''
    lun_wwn_dicts = context.get("allStrgHyprMtrLns")
    cmd = "upadmin show vlun type=hypermetro"

    objectForPy = context.get("objectForPy")
    host_dict = objectForPy.get("hostUseUtralPathInitiatorDict")
    if not host_dict:
        host_dict = {}
    devNode = context.get("devInfo")
    # 主机侧FC启动器信息
    hostFCLauncherWwns = devNode.getHostFCLauncherWwns()
    # 主机侧ISCSI启动器信息
    hostISCSILauncherWwns = devNode.getHostISCSILauncherWwns()
    if not hostFCLauncherWwns:
        hostFCLauncherWwns = []
    if not hostISCSILauncherWwns:
        hostISCSILauncherWwns = []
    fcList = list(hostFCLauncherWwns)
    iscsiList = list(hostISCSILauncherWwns)
    fcList.extend(iscsiList)
    iniList = [initiator.lower() for initiator in fcList]
    host_type = str(devNode.getDeviceName())
    isSucess, echos, resultMsg = cliUtil.executeCmdWithTimeout(sshCon, cmd, LOGGER)
    if not isSucess:
        return False, echos
    if "lun wwn"  not in echos.lower() and '-------' not in echos:
        LOGGER.logInfo("no such command or no vlun detected.")
        for ini in iniList:
            host_dict[ini] = {"isUseUtrapath": not_used_utralpath,
                              "hostType": host_type
                              }
        objectForPy.put("hostUseUtralPathInitiatorDict", host_dict)
        return False, echos
    for lun_wwn in lun_wwn_dicts:
        lun_wwn_upper = lun_wwn.upper()
        if lun_wwn_upper in echos.upper():
            if lun_wwn_dicts.get(lun_wwn).get("hostAluaStatus") == ALUA_CONFIGURED_NOT_CHECK:
                lun_wwn_dicts.get(lun_wwn)["hostAluaStatus"] = ALUA_CONFIGURED_PROPERLY
                LOGGER.logInfo("found lun(WWN: %s) matched storage devs',which is desiginated to upadmin service." % \
                           str(lun_wwn))

    for ini in iniList:
        host_dict[ini] = {"isUseUtrapath": used_utralpath,
                          "hostType": host_type
                          }
    objectForPy.put("hostUseUtralPathInitiatorDict", host_dict)
    return True, echos


def joinLines(originLines, postLines):
    """
    @summary: 将postLines追加originLines后
    """
    if not (originLines or postLines):
        return ""
    
    if not originLines:
        return postLines
    
    if not postLines:
        return originLines
    
    return "\n".join([originLines, postLines])

class UnCheckException(Exception):
    """
    @summary: 未检查异常自定义类
    """
    def __init__(self, errorMsg, cliRet, flag=None):
        self.errorMsg = errorMsg
        self.cliRet = cliRet
        self.flag = flag