# -*- coding: UTF-8 -*-
import common
import re
import cliUtil
import preCheck

from com.huawei.ism.tool.obase.utils import StringUtils

LOGGER = common.getLogger(PY_LOGGER, __file__)

ALUA_CONFIGURED_PROPERLY = 1
ALUA_CONFIGURED_FALSELY = -1


def execute(ssh_con):
    """
    Function name      : execute
    Input              : context
    Return             : cmd display
    """
    context = py_java_env
    LANG = context.get("lang")
    cli_rets = ""
    try:
        #白名单检查
        context["logger"] = PY_LOGGER
        context["ssh"] = ssh_con
        checkFlag, cli_rets, errMsg = preCheck.execute(context)
        if checkFlag != True:
            return checkFlag, cli_rets, errMsg

        is_qry_ok, has_nmp, echo = hasNMP(context, ssh_con)
        cli_rets += echo
        if not is_qry_ok:
            return cliUtil.RESULT_NOCHECK, cli_rets, common.getMsg(LANG, "hyper.metro.host.query.nmp.failure")

        # 如果未接管报不通过
        if not has_nmp:
            return (False, cli_rets, common.getMsg(LANG, "hyper.metro.host.query.multipath.not.open"))

        is_sucess, cli_ret, huawei_disk_letters = get_huawei_disk_ids(context, ssh_con, LANG)
        cli_rets += cli_ret
        if not is_sucess:
            return cliUtil.RESULT_NOCHECK, cli_rets, common.getMsg(LANG, "hyper.metro.host.disks.query.failure")
        if len(huawei_disk_letters) <= 0:
            return True, cli_rets, common.getMsg(LANG, "hyper.metro.host.disks.empty")
        LOGGER.logInfo("found huawei disks lists as: %s" % str(huawei_disk_letters))
        lun_info_map = {}
        failed_query_disks = []
        lun_wwn_dicts = context.get("allStrgHyprMtrLns")
        for disk_letter in huawei_disk_letters:
            is_success, echos, wwid, alua_state = get_lun_wwid_and_states(context, ssh_con, disk_letter)
            cli_rets += echos
            if not is_success:
                failed_query_disks.append(disk_letter)
                continue
            lun_info_map[wwid.upper()] = {"disk_letter":disk_letter, "alua_state":alua_state}
            updateHostAluaStatus(lun_wwn_dicts, wwid.lower(), ALUA_CONFIGURED_PROPERLY)
        LOGGER.logInfo("current host's lun's alua configuration :" + str(lun_info_map))
        result = True
        err_msg = ""
        is_succ, has_matched, wrong_configured_luns = seek_remote_storage_hyperMetro_lun_status(context, lun_info_map)
        if not is_succ:
            err_msg += common.getMsg(LANG, "hyper.metro.pair.query.failure")
            return True, cli_rets, err_msg

        if not has_matched:
            return False, cli_rets, common.getMsg(LANG, "hyper.metro.host.query.multipath.not.take.lun")

        if len(failed_query_disks) > 0:
            result = cliUtil.RESULT_NOCHECK
            err_msg += common.getMsg(LANG, "hyper.metro.disk.wwn.query.failure", ",".join(failed_query_disks))

        if len(wrong_configured_luns) > 0:
            result = False
            err_msg += common.getMsg(LANG, "hyper.metro.alua.evaluate.notpass", ",".join(wrong_configured_luns))

        return result, cli_rets, err_msg
    except BaseException, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, cli_rets, common.getMsg(LANG, "query.result.abnormal")


def seek_remote_storage_hyperMetro_lun_status(context, lun_info_map):
    '''
    @summary: get remote storage's hyperMetro lun's wwn information
    @return: whether has matched remote lun, remote lun that is not_configured properly
    '''
    has_matched = False
    wrong_configured_luns = []
    is_succ = True
    lun_wwn_dicts = context.get("allStrgHyprMtrLns")
    if not lun_wwn_dicts:
        LOGGER.logInfo("found no hyper metro lun wwn info in context, quit!")
        return False, has_matched, wrong_configured_luns

    for lun_wwn in lun_wwn_dicts:
        lun_wwn_upper = lun_wwn.upper()
        if lun_wwn_upper in lun_info_map:
            has_matched = True

            hostAluaStatus = lun_info_map.get(lun_wwn_upper).get("alua_state")
            lun_wwn_dicts.get(lun_wwn)["hostAluaStatus"] = hostAluaStatus \
                and ALUA_CONFIGURED_PROPERLY or ALUA_CONFIGURED_FALSELY
            LOGGER.logInfo("found lun(WWN: %s) matched storage devs', alua check result is %s." % \
                           (str(lun_wwn), hostAluaStatus))
            if not hostAluaStatus:
                LOGGER.logInfo("lun(WWN: %s) matched remote storage device but configured falsely" % lun_wwn)
                wrong_configured_luns.append(lun_info_map.get(lun_wwn_upper).get("disk_letter"))

    return is_succ, has_matched, wrong_configured_luns

def updateHostAluaStatus(arrayWwnDict, wwn, status):
    if wwn not in arrayWwnDict:
        return

    LOGGER.logInfo("***[update the host alua status for the lun wwn: %s is: %s]***" % (wwn, status))
    arrayWwnDict[wwn]['hostAluaStatus'] = status

def get_huawei_disk_ids(context, ssh_con, LANG):
    '''
    @summary: get huawei disk id lists
    @return:  r-disk directory
    '''
    cmd_id = "cmd_info_ioscan_for_disk"
    cmd = "ioscan -kfNnC disk"
    huawei_disk_letters = []
    LOGGER.logInfo("start to fetch current host's disk IDs")
    is_sucess, echos, resultMsg = execute_cmd_with_timeout(context, ssh_con, cmd, LOGGER)
    resultMsg = cmd_id + resultMsg
    if not is_sucess:
        return is_sucess, []
    isStart = False
    for line in echos.splitlines():
        if line.startswith("disk") and "huawei" in line.lower():
            isStart = True
            continue
        if isStart and "/dev/rdisk/disk" in line.lower():
            disk_letter = line[line.find('/dev/rdisk/disk'):].strip().split()[0][15:]
            LOGGER.logInfo("disk letter's number is : %s." % disk_letter)
            if disk_letter.isdigit():
                isStart = False
                huawei_disk_letters.append(disk_letter)

    return is_sucess, echos, huawei_disk_letters

def get_lun_wwid_and_states(context, sshCon, disk_letter):
    '''
    @summary: get LUN's WWID and working status corresponding to given disk letter 
    @return: isSuccess, wwid, alua_states (boolean)
    '''
    is_succ = False
    wwid = ""
    alua_states = False
    cmd = "scsimgr lun_map -D /dev/rdisk/disk" + disk_letter
    is_succ, echos, resultMsg = execute_cmd_with_timeout(context, sshCon, cmd, LOGGER)
    if not is_succ:
        return is_succ, echos, wwid, alua_states
    last_state_list = []
    state_list = []
    for line in echos.splitlines():
        if "world wide identifier" in line.lower() :
            wwid = len(line.split("=")) > 1 and line.split("=")[1].strip()[2:] or wwid

        state_pattern_str = '^state\s*=\s*(\w+\s*)+'
        if StringUtils.checkRegexReDos(line, state_pattern_str) and re.search(state_pattern_str, line.strip(), re.I):
            state_list.append(line.split('=')[1].strip().upper())
        last_pattern_str = '^last open or close state\s*=\s*(\w+\s*)+'
        if StringUtils.checkRegexReDos(line, last_pattern_str) and re.search(last_pattern_str, line.strip(), re.I):
            last_state_list.append(line.split('=')[1].strip().upper())

    if 'ACTIVE' in state_list and 'STANDBY' in state_list:
        alua_states = True
    if 'ACTIVE' not in state_list and 'STANDBY' not in state_list \
        and 'UNOPEN' in state_list and 'ACTIVE' in last_state_list \
        and 'STANDBY' in last_state_list:
        alua_states = True
    LOGGER.logInfo("current lun %s's alua configuration status: %s" % (disk_letter, str(alua_states)))
    LOGGER.logInfo("current lun %s's wwn: %s" % (disk_letter, wwid))
    if not wwid:
        is_succ = False
    return is_succ, echos, wwid, alua_states

def execute_cmd_with_timeout(context, sshCon, cmd, LOGGER):
    '''
    @summary: get command echos 
    @return: isSucess, echos, resultMsg
    '''
    isSucess, echos, resultMsg = cliUtil.executeCmdWithTimeout(sshCon, cmd, LOGGER)
    return isSucess, echos, resultMsg

def hasNMP(context, sshCon):
    '''
    @summary:判断是否带有自带多路径
    @param context
    @return: is_success, hasNMP
    '''
    LOGGER.logInfo("checking whether NMP has ***")

    cmd = "scsimgr get_attr -a leg_mpath_enable"

    try:
        isSucess, echos, resultMsg = execute_cmd_with_timeout(context, sshCon, cmd, LOGGER)
        if not isSucess:
            return False , False, echos
        current_flag = False
        default_flag = False
        for line in echos.splitlines():
            current_pattern_str = "current\s*=\s*(\w+\s*)+"
            default_pattern_str = "default\s*=\s*(\w+\s*)+"
            if StringUtils.checkRegexReDos(line, current_pattern_str) and re.search(current_pattern_str, line, re.I):
                current_flag = line.split("=")[1].strip().lower() == "true" and True or False
            elif StringUtils.checkRegexReDos(line, default_pattern_str) and re.search(default_pattern_str, line, re.I):
                default_flag = line.split("=")[1].strip().lower() == "true" and True or False
        return True, current_flag and default_flag, echos
    except:
        LOGGER.logInfo("exception occurred while checking whether NMP is initialized.")
        return False, False, ""
