# -*- coding: UTF-8 -*-

import sys
import os
scriptpath = os.path.dirname(os.path.abspath(__file__))
hostCommonPath = os.path.join(scriptpath, "..\\..\\HOST_Common")
sys.path.append(hostCommonPath)

import common
import cliUtil
import preCheck
import host_common

LOGGER = common.getLogger(PY_LOGGER, __file__)

ALUA_CONFIGURED_PROPERLY = 1
ALUA_CONFIGURED_FALSELY = -1

BALANCED = "Balanced"
ASYMMETRIC = "Asymmetric"

G_ValidWWNLength = 32


def execute(ssh):
    '''
          双活LUN的ALUA状态检查：
    '''
    context = py_java_env
    lang = context.get("lang")
    cliRet = ""

    try:
        cliUtil.executePS1(ssh, LOGGER)

        is_upadmin_designated, echos = \
            common.mark_host_upadmin_hyper_metro_luns(py_java_env, ssh,
                                                      LOGGER)
        if is_upadmin_designated:
            return cliUtil.RESULT_NOSUPPORT, echos, ''
            # 白名单检查
        context["logger"] = PY_LOGGER
        context["ssh"] = ssh
        checkFlag, cliRet, errMsg = preCheck.execute_doradov6(context)
        cliRet = echos + cliRet
        if checkFlag is not True:
            return checkFlag, cliRet, errMsg
        # 判断是否为自带多路径，并且启用NMP
        processFlag, isRunning, queryCliRet = hasNMP(ssh)
        cliRet += queryCliRet + "\n"
        if not processFlag:
            return cliUtil.RESULT_NOCHECK, cliRet, \
                   common.getMsg(lang, "hyper.metro.host.query.nmp.failure")
        LOGGER.logInfo("Host UltraPath running status: " + str(isRunning))

        # 如果未开启自带多路径 报不通过。 ,,,应该报不通过。
        if not isRunning:
            return (False, cliRet,
                    common.getMsg
                    (lang, "hyper.metro.host.query.multipath.not.open"))

            # 获取华为双活LUN的信息
        hyperMetroLUNDict = context.get("allStrgHyprMtrLns")
        if not hyperMetroLUNDict:
            return (True, cliRet, "")

        # 获取华为LUN的信息
        huaweiLunInfo, lunCliRet = getHuaweiLUNInfo(ssh)
        LOGGER.logInfo("LUN info in host: " + str(huaweiLunInfo))
        cliRet += lunCliRet + "\n"
        if huaweiLunInfo is None:
            # 信息结果异常
            return cliUtil.RESULT_NOCHECK, cliRet, \
                   common.getMsg(lang, "query.result.abnormal")
        if not huaweiLunInfo:
            # 未查询到华为LUN的信息,巡检通过,,,应该报不通过。
            return (False, cliRet,
                    common.getMsg
                    (lang, "hyper.metro.host.query.multipath.not.take.lun"))

        validDiskWwnDict = getValidDiskDict(hyperMetroLUNDict, huaweiLunInfo)
        if not validDiskWwnDict:
            return (False, cliRet,
                    common.getMsg
                    (lang, "hyper.metro.host.query.multipath.not.take.lun"))

        # 从上下文中获取show host general
        # |filterColumn include columnList=ID,Access\sMode,HyperMetro
        # \sPath\sOptimized命令查到的访问模式
        # 并且将回文加到cliRet
        access_mode_cli = host_common.get_host_access_cli_ret(context)
        access_mode_info = []
        access_mode_info.append(cliRet)
        for sn in access_mode_cli:
            access_mode_info.append(sn)
            access_mode_info.append(access_mode_cli[sn])
        cliRet = "\n".join(access_mode_info)

        access_mode_dict = host_common.get_access_mode(context)
        if not access_mode_dict:
            return (False, cliRet,
                    common.getMsg
                    (lang, "get.hyper.storage.host.access.mode.error"))
        # 对比不同存储上配置的访问模式是否一致，若不一致，不通过
        access_mode_list = access_mode_dict.values()
        if len(set(access_mode_list)) > 1:
            return (False, cliRet,
                    common.getMsg
                    (lang, "hyper.storage.host.access.mode.not.equal"))
        access_mode = access_mode_list[0]
        checkFlag = True
        errMsg = ""
        if access_mode == BALANCED:
            errorWwns, checkStatusFailWwns = check_hyper_lun_by_balanced(
                huaweiLunInfo, hyperMetroLUNDict)
        elif access_mode == ASYMMETRIC:
            errorWwns, checkStatusFailWwns = check_hyper_lun_by_Asymmetric(
                huaweiLunInfo, hyperMetroLUNDict)
        else:
            return (False, cliRet,
                    common.getMsg
                    (lang, "hyper.storage.host.access.mode.not.equal"))

        # wwn信息有误
        if errorWwns:
            checkFlag = False
            errMsg += common.getMsg(lang,
                                    "hyper.metro.disk.wwn.query.failure",
                                    ",".join(errorWwns))
        # 检查不通过的LUN
        if checkStatusFailWwns:
            checkFlag = False
            errMsg += common.getMsg(lang,
                                    "hyper.metro.alua.evaluate.notpass",
                                    ",".join(checkStatusFailWwns))
        return (checkFlag, cliRet, errMsg)
    except Exception as e:
        LOGGER.logError(str(e))
        LOGGER.logException()
        return cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(
            lang, "query.result.abnormal")


def check_hyper_lun_by_balanced(huaweiLunInfo, hyperMetroLUNDict):
    checkStatusFailWwns = []
    errorWwns = []
    # 每个华为LUN判断：是否为华为双活LUN，状态是否正常
    for lunWWN, lunInfo in huaweiLunInfo.items():
        # 信息有误判断
        if len(lunWWN) != G_ValidWWNLength:
            errorWwns.append(lunWWN)
            continue
        for remoteWwn in hyperMetroLUNDict:
            # 统一转换为大写进行匹配
            remoteWwnUpper = remoteWwn.upper()
            if remoteWwnUpper != lunWWN:
                continue
            # 获取优先级和状态信息
            # 信息有误判断
            prioList, statusList = lunInfo
            if not prioList or not statusList:
                errorWwns.append(lunWWN)
                continue
            elif len(prioList) != len(statusList) or len(prioList) != 1:
                errorWwns.append(lunWWN)
                continue

            # 和产品方案人对齐，增加prio值的判断，为1时正常，其他值不正常。
            if '1' in prioList and "active" in statusList:
                # 检查通过
                hyperMetroLUNDict.get(remoteWwn)[
                    "hostAluaStatus"] = ALUA_CONFIGURED_PROPERLY
            else:
                # 检查不通过
                checkStatusFailWwns.append(lunWWN)
                hyperMetroLUNDict.get(remoteWwn)[
                    "hostAluaStatus"] = ALUA_CONFIGURED_FALSELY
    return errorWwns, checkStatusFailWwns


def check_hyper_lun_by_Asymmetric(huaweiLunInfo, hyperMetroLUNDict):
    checkStatusFailWwns = []
    errorWwns = []
    # 每个华为LUN判断：是否为华为双活LUN，状态是否正常
    for lunWWN, lunInfo in huaweiLunInfo.items():
        # 信息有误判断
        if len(lunWWN) != G_ValidWWNLength:
            errorWwns.append(lunWWN)
            continue
        for remoteWwn in hyperMetroLUNDict:
            # 统一转换为大写进行匹配
            remoteWwnUpper = remoteWwn.upper()
            if remoteWwnUpper != lunWWN:
                continue

            # 获取优先级和状态信息
            # 信息有误判断
            prioList, statusList = lunInfo
            if not prioList or not statusList:
                errorWwns.append(lunWWN)
                continue
            elif len(prioList) != len(statusList) or len(prioList) < 2:
                errorWwns.append(lunWWN)
                continue

            # 优先级数据不能相同
            if len(set(prioList)) == 1:
                # 优先级数据相同检查不通过
                checkStatusFailWwns.append(lunWWN)
                hyperMetroLUNDict.get(remoteWwn)[
                    "hostAluaStatus"] = ALUA_CONFIGURED_FALSELY
            elif "active" in statusList and "enabled" in statusList:
                # 检查通过
                hyperMetroLUNDict.get(remoteWwn)[
                    "hostAluaStatus"] = ALUA_CONFIGURED_PROPERLY
            else:
                # 检查不通过
                checkStatusFailWwns.append(lunWWN)
                hyperMetroLUNDict.get(remoteWwn)[
                    "hostAluaStatus"] = ALUA_CONFIGURED_FALSELY
    return errorWwns, checkStatusFailWwns


def getValidDiskDict(arrayWwnDict, diskWwnDict):
    validDiskWwnDict = {}
    for arrayKey in arrayWwnDict.keys():
        lowerKey = arrayKey.upper()
        if lowerKey in diskWwnDict.keys():
            arrayWwnDict[arrayKey][
                "hostAluaStatus"] = ALUA_CONFIGURED_PROPERLY
            validDiskWwnDict[arrayKey] = diskWwnDict[lowerKey]
    return validDiskWwnDict


def hasNMP(ssh):
    '''
    @summary: Query the multipathd status (Linux multipath service status).
    @param ssh: ssh
    @return (processFlag, isMultipathdRunning, cliRet)
    '''

    LOGGER.logInfo("checking whether NMP has ***")
    allCliRet = ''
    endStr = ['# ', '$ ', '> ', '(press RETURN)', '#', '$', '>']

    try:
        # 执行第一条命令
        cliRet = ssh.execCmdWithTimout('service multipathd status | cat',
                                       common.HOST_CMD_SHORT_TIMEOUT,
                                       endStr)
        allCliRet += cliRet + "\n"
        if cliUtil.TIMEOUT_PLACE_HOLDER in cliRet:
            return False, False, allCliRet

        if 'multipathd: unrecognized service' in cliRet \
                or 'command not found' in cliRet:
            # 命令执行失败，替换第二条命令
            reCheckCmd = 'ps -e | grep multipathd |cat'
            cliRet = ssh.execCmdWithTimout(reCheckCmd,
                                           common.HOST_CMD_SHORT_TIMEOUT)
            allCliRet += cliRet + "\n"
            if cliUtil.TIMEOUT_PLACE_HOLDER in cliRet:
                return False, False, allCliRet
            isRunning = cliRet.replace(reCheckCmd, '').find(
                'multipathd') > -1
            return True, isRunning, allCliRet
        elif "(press RETURN)" in cliRet:
            cliRet = cliRet + \
                     ssh.execCmdWithTimout("\r",
                                           common.HOST_CMD_SHORT_TIMEOUT,
                                           endStr)
            allCliRet += cliRet + "\n"

        # 判断多路径是否运行
        if "running" in cliRet.lower() or u"正在运行" in cliRet:
            return True, True, allCliRet
        return True, False, allCliRet
    except Exception as e:
        LOGGER.logError(str(e))
        LOGGER.logException()
        return False, False, allCliRet


def getHuaweiLUNInfo(ssh):
    '''
          获取主机上华为LUN的信息
    '''
    huaweiLunInfo = {}
    cliRet = ssh.execCmd("multipath -ll |cat")
    if len(cliRet.splitlines()) == 2:
        return huaweiLunInfo, cliRet
    elif "dm-" not in cliRet.lower():
        return None, cliRet
    elif "huawei" not in cliRet.lower():
        return huaweiLunInfo, cliRet

    lineList = cliRet.splitlines()
    huaweiLunInfo = {}
    lunWWN = ""
    lunPrioList = []
    lunStatusList = []

    for line in lineList:
        if "huawei" in line.lower():
            if lunWWN:
                # 信息录入，然后重置
                huaweiLunInfo[lunWWN] = (lunPrioList, lunStatusList)
                # 重新初始化
                lunWWN = ""
                prioField = ""
                statusField = ""
                lunPrioList = []
                lunStatusList = []

            # 从第二个字符开始的32位为LUN的WWN(统一转换成大写)
            fields = line.split()
            for field in fields:
                if len(field) >= G_ValidWWNLength:
                    lunWWN = field.replace("(", "")[
                             1: G_ValidWWNLength + 1].upper()
                    break
            if len(lunWWN) != G_ValidWWNLength:
                # 信息可能有误，需要记录后续报错
                lunWWN = fields[0].upper()
                huaweiLunInfo[lunWWN] = (lunPrioList, lunStatusList)
                # 重新初始化
                lunWWN = ""
                prioField = ""
                statusField = ""
                lunPrioList = []
                lunStatusList = []
        if lunWWN and "prio=" in line and "status=" in line:
            allFields = line.split()
            for field in allFields:
                if field.strip().startswith("prio="):
                    prioField = field.split("=")[-1].strip()
                    lunPrioList.append(prioField)
                elif field.strip().startswith("status="):
                    statusField = field.split("=")[-1].strip()
                    lunStatusList.append(statusField)
    # 信息录入
    if lunWWN:
        huaweiLunInfo[lunWWN] = (lunPrioList, lunStatusList)
    return huaweiLunInfo, cliRet
