# -*- coding: UTF-8 -*-
import re
import sys
import os
import traceback

import com.huawei.ism.tool.obase.db.SqliteManager as SqliteManager

from cbb.frame.context import sqlite_context
from cbb.frame.cli.cli_with_cache import query_one_cmd

import cliUtil
import common
from common import UnCheckException

script_path = os.path.dirname(os.path.abspath(__file__))
common_path = os.path.join(
    script_path, os.path.join("..", "..", "HOST_Common")
)
sys.path.append(common_path)
import host_common

LOGGER = common.getLogger(PY_LOGGER, __file__)

ALL_CLI_RET = ""
PY_JAVA_ENV = py_java_env
LANG = PY_JAVA_ENV.get("lang")
FAULT_STATUS_VLUN_WWN_DICT = {}
ADDED_ARRAY_SN = []
faultVlunPathStatusDict = {}
vlunIdAndWWNMappView = {}

# 是否有端口组
hasPortGroupFlagDict = {}
ALL_HYPER_LUN_DICT = PY_JAVA_ENV.get("allStrgHyprMtrLns")


def execute(ssh):
    """
   双活LUN是否接管检查
    """

    global ALL_CLI_RET
    context = PY_JAVA_ENV
    lang = context.get("lang")
    errVlunStatusMsg = ''
    notPassErrMsg = ''
    errVlunPathStatusMsg = ''
    errLunNotOnHostMsg = ''
    try:
        cliUtil.executePS1(ssh, LOGGER)

        # 标记双活LUN
        common.mark_host_upadmin_hyper_metro_luns(PY_JAVA_ENV, ssh, LOGGER)

        # 白名单检查
        context["logger"] = PY_LOGGER
        context["ssh"] = ssh

        # 检查多路径版本信息
        flag, cliRet, errMsg = checkUtralPathVersion(ssh)
        if flag is not True:
            return flag, cliRet, errMsg

        # 查询path
        pathInfoDict, iscsiPathIdList = getHostPath(ssh)
        LOGGER.logInfo("pathInfoDict:%s, iscsiPathIdList:%s" % (
            str(pathInfoDict), str(iscsiPathIdList)))

        # 查询lun wwn
        vlunIdList = getAllVlun(ssh)
        LOGGER.logInfo("vlunIdList:%s" % str(vlunIdList))

        # 查询详细vlun路径信息
        vlunPathInfoOnHost, errHyperLunMsg, \
            iscsiCheckedVlunWWNList = getVlunDetailInfo(
                ssh, vlunIdList,
                iscsiPathIdList)
        LOGGER.logInfo(
            u"vlunInfoDict:%s，errHyperLunMsg:%s, "
            u"iscsiCheckedVlunWWNList：%s" % (
                str(vlunPathInfoOnHost), errHyperLunMsg,
                str(iscsiCheckedVlunWWNList)))

        # 获取启动器信息
        initiatorList = getInitiatorInfoOnHost()
        LOGGER.logInfo("initiatorList:%s" % str(initiatorList))

        # 获取阵列各SN的VLUN path路径
        vlunPathInfoOnArray = getPathInfoFromRealArray(vlunPathInfoOnHost,
                                                       initiatorList)

        # 比较信息
        NOT_EXIST_LUN_ON_HOST_LIST, NOT_PASS_ERR_MSG_LIST, \
            OTHER_NOT_PASS_MSG_LIST = compareHostAndArrayInfo(
                vlunPathInfoOnHost,
                vlunPathInfoOnArray, pathInfoDict, iscsiCheckedVlunWWNList)
        LOGGER.logInfo("FAULT_STATUS_VLUN_WWN_DICT:%s" % str(
            FAULT_STATUS_VLUN_WWN_DICT))
        LOGGER.logInfo(
            "NOT_PASS_ERR_MSG_LIST:%s" % str(NOT_PASS_ERR_MSG_LIST))
        LOGGER.logInfo("NOT_EXIST_LUN_ON_HOST_LIST:%s" % str(
            NOT_EXIST_LUN_ON_HOST_LIST))

        if errHyperLunMsg:
            OTHER_NOT_PASS_MSG_LIST.append(errHyperLunMsg)

        if faultVlunPathStatusDict:
            for vlunWWN in faultVlunPathStatusDict:
                arraySnDict = faultVlunPathStatusDict[vlunWWN]
                for arraySn in arraySnDict:

                    # 只检查添加了的阵列的路径状态是否正常，因为可能有其他非双活LUN。
                    if arraySn and arraySn in ADDED_ARRAY_SN:
                        pathDict = arraySnDict[arraySn]
                        for pathId in pathDict:
                            errVlunPathStatusMsg += common.getMsg(
                                LANG,
                                "hyper.lun.accepted.vlun."
                                "path.status.exception",
                                (
                                    vlunIdAndWWNMappView.get(
                                        vlunWWN,
                                        vlunWWN),
                                    pathId,
                                    pathDict[
                                        pathId],
                                    arraySn))

        if FAULT_STATUS_VLUN_WWN_DICT:
            for vlunWWN in FAULT_STATUS_VLUN_WWN_DICT:
                arraySnDict = FAULT_STATUS_VLUN_WWN_DICT[vlunWWN].get(
                    "arraySn")
                for arraySn in arraySnDict:
                    # 只检查添加了的阵列的路径状态是否正常，因为可能有其他非双活LUN。
                    if arraySn and arraySn in ADDED_ARRAY_SN:
                        errVlunStatusMsg += common.getMsg(
                            LANG,
                            "hyper.lun.accepted.vlun.status.exception",
                            (
                                vlunIdAndWWNMappView.get(
                                    vlunWWN,
                                    vlunWWN),
                                arraySnDict.get(
                                    arraySn),
                                arraySn))

        if NOT_EXIST_LUN_ON_HOST_LIST:
            errMsgList = []
            for key in NOT_EXIST_LUN_ON_HOST_LIST:
                errMsgList.append(u"%s:%s" % (
                    key, ",".join(NOT_EXIST_LUN_ON_HOST_LIST[key])))
            errLunNotOnHostMsg += common.getMsg(
                LANG,
                "hyper.lun.accepted.vlun.not.mapped.on.host",
                ",".join(errMsgList))

        # 非端口组场景不通过
        if NOT_PASS_ERR_MSG_LIST \
                or NOT_EXIST_LUN_ON_HOST_LIST \
                or errVlunStatusMsg \
                or errVlunPathStatusMsg \
                or OTHER_NOT_PASS_MSG_LIST:
            if NOT_PASS_ERR_MSG_LIST:
                notPassErrMsg += common.getMsg(
                    LANG,
                    "hyper.lun.accepted.vlun"
                    ".path.smaller.than.array.title") + "".join(
                    NOT_PASS_ERR_MSG_LIST)
            notPassErrMsg += errLunNotOnHostMsg
            notPassErrMsg += errVlunStatusMsg
            notPassErrMsg += errVlunPathStatusMsg
            notPassErrMsg += "".join(OTHER_NOT_PASS_MSG_LIST)
            return False, ALL_CLI_RET, notPassErrMsg

        return True, ALL_CLI_RET, ''
    except UnCheckException, unCheckException:
        LOGGER.logInfo(
            u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if unCheckException.flag is None:
            return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET,
                    unCheckException.errorMsg)

        return unCheckException.flag, ALL_CLI_RET, unCheckException.errorMsg

    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(
            lang,
            "query.result.abnormal")

def compareHostAndArrayInfo(vlunPathInfoOnHost, vlunPathInfoOnArray,
                            pathInfoDict, iscsiCheckedVlunWWNList):
    """
    比较主机侧和阵列侧路径信息
    :param vlunPathInfoOnHost:
    :param vlunPathInfoOnArray:
    :param pathInfoDict:
    :return:
    """
    NOT_EXIST_LUN_ON_HOST_LIST = {}
    NOT_PASS_ERR_MSG_LIST = []
    OTHER_NOT_PASS_MSG_LIST = []
    for arraySn in vlunPathInfoOnHost:
        vlunInfoOnHostDict = vlunPathInfoOnHost.get(arraySn, {})
        vlunInfoOnArrayDict = vlunPathInfoOnArray.get(arraySn, {})
        lunPathInfoDictOnArray = vlunInfoOnArrayDict.get("lunPathInfoDict",
                                                         {})
        lunHostDict = vlunInfoOnArrayDict.get("lunHostDict", {})
        notStandardViewList = vlunInfoOnArrayDict.get("notStandardViewList",
                                                      {})
        if notStandardViewList:
            OTHER_NOT_PASS_MSG_LIST.append(
                common.getMsg(
                    LANG,
                    "hyper.lun.accepted.vlun.path."
                    "exist.fc.and.iscsi.initiator",
                    (arraySn, ",".join(notStandardViewList))))
        for vlunWWN in lunPathInfoDictOnArray:
            host_vlun_wwn = vlunWWN
            if vlunWWN not in vlunInfoOnHostDict:
                # 兼容nof启动器阵列侧LUN WWN和主机侧不一致的场景。
                new_wwn = host_common.get_nof_lun_wwn_on_host(vlunWWN)
                LOGGER.logInfo(
                    "nof lun wwn not found on host, need conversion, before "
                    "conversion:{}, after coversion:{}".format(
                        vlunWWN, new_wwn
                    )
                )
                if new_wwn in vlunInfoOnHostDict:
                    host_vlun_wwn = new_wwn
                else:
                    tmpList = NOT_EXIST_LUN_ON_HOST_LIST.get(arraySn, [])
                    tmpList.append(vlunWWN)
                    NOT_EXIST_LUN_ON_HOST_LIST[arraySn] = tmpList
                    continue

            # iscsi组网已检查。
            if vlunWWN in iscsiCheckedVlunWWNList:
                LOGGER.logInfo("vlunWWN is checked by iscsi : %s" % vlunWWN)
                continue

            pathInfoListOnArray = lunPathInfoDictOnArray.get(vlunWWN, [])
            pathInfoDictOnHost = vlunInfoOnHostDict.get(host_vlun_wwn, {})
            arrayPathNum = len(pathInfoListOnArray)
            hostPathNum = pathInfoDictOnHost.get("totalPathNum", 0)
            hostId = ",".join(lunHostDict.get(vlunWWN, []))
            LOGGER.logInfo(
                u"arraySn:%s, vlunWWN:%s, arrayPathNum: %s, hostPathNum:%s, "
                u"pathInfoListOnArray:%s, pathInfoDictOnHost:%s" % (
                    arraySn, vlunWWN, arrayPathNum, hostPathNum,
                    pathInfoListOnArray, pathInfoDictOnHost))
            if hostPathNum >= arrayPathNum:
                continue

            hostPathIdList = pathInfoDictOnHost.get("pathIdList", [])

            pathDetailOnHost = {}
            for pathId in hostPathIdList:
                initiatorWWN = pathInfoDict.get(pathId, "")
                iniNum = pathDetailOnHost.get(initiatorWWN, 0)
                iniNum += 1
                pathDetailOnHost[initiatorWWN] = iniNum

            tmpArrayErrMsg = []
            tmpHostErrMsg = []
            pathResDict = {}
            for path in pathInfoListOnArray:
                pathNum = pathResDict.get(path[0], 0)
                pathNum += 1
                pathResDict[path[0]] = pathNum

            for key in pathResDict:
                tmpArrayErrMsg.append("%s:%s" % (key, pathResDict[key]))

            for ini in pathDetailOnHost:
                tmpHostErrMsg.append("%s:%s" % (ini, pathDetailOnHost[ini]))

            NOT_PASS_ERR_MSG_LIST.append(
                common.getMsg(
                    LANG,
                    "hyper.lun.accepted.vlun.path.smaller.than.array",
                    (hostId,
                     vlunIdAndWWNMappView.get(vlunWWN, vlunWWN),
                     arraySn,
                     ",".join(tmpArrayErrMsg),
                     ",".join(tmpHostErrMsg))))

    return (NOT_EXIST_LUN_ON_HOST_LIST, NOT_PASS_ERR_MSG_LIST,
            OTHER_NOT_PASS_MSG_LIST)


def getInitiatorInfoOnHost():
    """
    获取主机侧全部启动器信息。
    :return:
    """
    iniList = []

    devNode = PY_JAVA_ENV.get("devInfo")

    # 主机侧FC启动器信息
    hostFCLauncherWwns = devNode.getHostFCLauncherWwns()

    if hostFCLauncherWwns:
        iniList.extend(hostFCLauncherWwns)

    # 主机侧ISCSI启动器信息
    hostISCSILauncherWwns = devNode.getHostISCSILauncherWwns()

    if hostISCSILauncherWwns:
        iniList.extend(hostISCSILauncherWwns)

    nvme_ini_wwns_list = devNode.getHostNvmeLauncherWwns()
    if nvme_ini_wwns_list:
        iniList.extend(nvme_ini_wwns_list)

    iniListTemp = [str(ini).lower() for ini in iniList]

    return iniListTemp


def getVlunDetailInfo(ssh, vlunIdList, iscsiPathIdList):
    """
    获取主机侧VLUN路径信息
    :param ssh:
    :param vlunIdList:
    :return:
    """
    global ALL_CLI_RET, FAULT_STATUS_VLUN_WWN_DICT, \
        faultVlunPathStatusDict, vlunIdAndWWNMappView
    vlunInfoDict = {}
    errHyperLunMsg = ""
    iscsiCheckedVlunWWNList = []
    cmd = "upadmin show vlun id=%s type=hypermetro"
    for vlunId in vlunIdList:
        tmpVlunPathDict = {}
        isIscsiPath = False
        cmdStr = cmd % vlunId
        flag, cliRet, errMsg = cliUtil.executeCmdWithTimeout(ssh, cmdStr,
                                                             LOGGER)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag is not True:
            raise UnCheckException(
                common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET)

        if "Can't find" in cliRet \
                or "Unknown command" in cliRet \
                or "command not found" in cliRet \
                or "command-not-found" in cliRet:
            raise UnCheckException(
                common.getMsg(LANG, "cannot.get.info", "vlun"), ALL_CLI_RET,
                cliUtil.RESULT_NOCHECK)

        segCliRetList = cliRet.split("Aggregation Member#")
        for segCliRet in segCliRetList:
            arraySn = ''
            lunWWN = ''
            numOfPath = 0
            lunStatus = ''
            pathIdList = []
            if "Status" in segCliRet \
                    and "LUN WWN" in segCliRet \
                    and "Array SN" in segCliRet \
                    and "Num of Paths" in segCliRet:
                resLines = segCliRet.splitlines()
                for line in resLines:
                    tmpLine = line.strip()
                    if tmpLine.startswith("Status"):
                        tmpList = tmpLine.split(":")
                        if len(tmpList) != 2:
                            continue

                        lunStatus = tmpList[1].strip()
                        continue

                    if tmpLine.startswith("LUN WWN"):
                        tmpList = tmpLine.split(":")
                        if len(tmpList) != 2:
                            continue

                        lunWWN = tmpList[1].strip()
                        continue

                    if tmpLine.startswith("Array SN"):
                        tmpList = tmpLine.split(":")
                        if len(tmpList) != 2:
                            continue

                        arraySn = tmpList[1].strip()
                        continue

                    if tmpLine.startswith("Num of Paths"):
                        tmpList = tmpLine.split(":")
                        if len(tmpList) != 2:
                            continue

                        numOfPath = tmpList[1].strip()
                        if str(numOfPath).isdigit():
                            numOfPath = int(numOfPath)
                        continue

                    if tmpLine.startswith("Path"):
                        pathId = ''
                        res = re.match(r"Path (\d+)", tmpLine, re.I)
                        if res:
                            pathId = res.group(1)
                            if pathId:
                                pathIdList.append(pathId)
                                if pathId in iscsiPathIdList:
                                    isIscsiPath = True
                        pathStatus = tmpLine.split(":")[-1].strip()
                        if pathStatus.lower() == "fault":
                            tmpDict = faultVlunPathStatusDict.get(lunWWN, {})
                            tmpArrayDict = tmpDict.get(arraySn, {})
                            tmpArrayDict[pathId] = pathStatus
                            tmpDict[arraySn] = tmpArrayDict
                            faultVlunPathStatusDict[lunWWN] = tmpDict
                            pathIdList.remove(pathId)

                if arraySn and lunWWN and numOfPath and lunStatus:

                    # 使用路径状态正常的逻辑路径和阵列比较数量。
                    numOfPath = len(pathIdList)
                    if cliRet.count("Aggregation Member#") < 2 \
                            and lunWWN in ALL_HYPER_LUN_DICT:
                        errHyperLunMsg += common.getMsg(
                            LANG,
                            "hyper.lun.accepted.vlun.path.only.one.array",
                            (lunWWN, arraySn))
                    vlunIdAndWWNMappView[lunWWN] = vlunId
                    if lunStatus != "Normal":
                        tmpeDict = FAULT_STATUS_VLUN_WWN_DICT.get(lunWWN, {})
                        arraySnDict = tmpeDict.get("arraySn", {})
                        arraySnDict[arraySn] = lunStatus
                        tmpeDict["arraySn"] = arraySnDict
                        FAULT_STATUS_VLUN_WWN_DICT[lunWWN] = tmpeDict

                    arrayPathInfoDict = vlunInfoDict.get(arraySn, {})
                    arrayPathInfoDict[lunWWN] = {"totalPathNum": numOfPath,
                                                 "pathIdList": pathIdList,
                                                 "lunStatus": lunStatus
                                                 }

                    tmpDictPath = tmpVlunPathDict.get(lunWWN, {})
                    tmpDictPath[arraySn] = pathIdList
                    tmpVlunPathDict[lunWWN] = tmpDictPath

                    vlunInfoDict[arraySn] = arrayPathInfoDict
                    arraySn = ''
                    lunWWN = ''
                    numOfPath = ''
                    lunStatus = ''
                    pathIdList = ''

        LOGGER.logInfo(u"isIscsiPath：%s, tmpVlunPathDict:%s" % (
            isIscsiPath, tmpVlunPathDict))
        if isIscsiPath:
            for lunWWN in tmpVlunPathDict:
                iscsiCheckedVlunWWNList.append(lunWWN)
                snList = tmpVlunPathDict[lunWWN].keys()
                if len(snList) >= 2:
                    pathListA = tmpVlunPathDict[lunWWN][snList[0]]
                    pathListB = tmpVlunPathDict[lunWWN][snList[1]]
                    if len(pathListA) != len(pathListB):
                        errHyperLunMsg += common.getMsg(
                            LANG,
                            "hyper.lun.accepted.vlun.path.not.same.on.array",
                            (
                                vlunId,
                                snList[0],
                                len(pathListA),
                                snList[1],
                                len(pathListB)
                            ))

    return vlunInfoDict, errHyperLunMsg, iscsiCheckedVlunWWNList


def getAllVlun(ssh):
    """
    获取主机侧VLUN 信息
    :param ssh:
    :return:
    """
    global ALL_CLI_RET
    vlunIdList = []
    cmd = "upadmin show vlun type=hypermetro"
    flag, cliRet, errMsg = cliUtil.executeCmdWithTimeout(ssh, cmd, LOGGER)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag is not True:
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET)

    if "Can't find" in cliRet \
            or "Unknown command" in cliRet \
            or "command not found" in cliRet \
            or "command-not-found" in cliRet:
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET,
            cliUtil.RESULT_NOSUPPORT)

    resLines = cliRet.splitlines()
    isStart = False
    for line in resLines:
        if "Vlun ID" in line:
            isStart = True
            continue

        if not isStart:
            continue

        vlunId = ''
        tmpList = line.split()
        if len(tmpList) >= 10:
            vlunId = tmpList[0].strip()

        if vlunId:
            vlunIdList.append(vlunId)

    return list(set(vlunIdList))


def getArrayPathInfo(ssh, arrayList):
    """
    获取每个阵列的path信息
    :param ssh:
    :param arrayList:
    :return:
    """
    global ALL_CLI_RET
    arrayPathInfoDict = {}
    cmd = "upadmin show array id=%s"
    for arrayId in arrayList:
        cmdStr = cmd % arrayId
        flag, cliRet, errMsg = cliUtil.executeCmdWithTimeout(ssh, cmdStr,
                                                             LOGGER)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag is not True:
            raise UnCheckException(
                common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET)

        if "Can't lookup" in cliRet \
                or "Unknown command" in cliRet \
                or "command not found" in cliRet \
                or "command-not-found" in cliRet:
            raise UnCheckException(
                common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET,
                cliUtil.RESULT_NOSUPPORT)

        resLines = cliRet.splitlines()
        arraySn = ''
        pathDict = {}
        for line in resLines:
            tmpLine = line.strip()
            if tmpLine.startswith("Array SN"):
                tmpList = tmpLine.split(":")
                if len(tmpList) == 2:
                    arraySn = tmpList[1]
            if tmpLine.startswith("Path") and "PathInfo" not in tmpLine:
                res = re.match(r"Path(\d+):(.*)", tmpLine, re.I)
                if res:
                    pathId = res.group(1).strip()
                    pathStatus = res.group(2).strip()
                    pathDict[pathId] = pathStatus
        if arraySn:
            arrayPathInfoDict[arraySn] = pathDict

    return arrayPathInfoDict


def getHostPath(ssh):
    """
    获取主机path信息
    :param ssh:
    :return:
    """
    global ALL_CLI_RET
    pathInfoDict = {}
    iscsiPathIdList = []
    cmd = "upadmin show path"
    flag, cliRet, errMsg = cliUtil.executeCmdWithTimeout(ssh, cmd, LOGGER)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag is not True:
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", "path"), ALL_CLI_RET)

    if "Can't find" in cliRet \
            or "Unknown command" in cliRet \
            or "command not found" in cliRet \
            or "command-not-found" in cliRet:
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", "path"), ALL_CLI_RET,
            cliUtil.RESULT_NOSUPPORT)

    resLines = cliRet.splitlines()
    for line in resLines:
        tmpList = line.strip().split()
        if len(tmpList) == 9 and "Path ID" not in line:
            pathId = tmpList[0].strip()
            targetPortInitiator = tmpList[1].strip()
            pathInfoDict[pathId] = targetPortInitiator
            if tmpList[7] != "FC":
                iscsiPathIdList.append(pathId)
    return pathInfoDict, iscsiPathIdList


def checkUtralPathVersion(ssh):
    """
    检查utralpath版本信息
    :param ssh:
    :return:
    """
    try:
        # 判断upadm版本信息
        softVer = getHostMutipathVersion(ssh)

        if not softVer:
            softVer = getOldMutiPathVersion(ssh)

            # 命令不支持的场景
            if not softVer:
                return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''

        # 如果是老版本则检查不通过
        if checkSoftVersion(softVer):
            return False, ALL_CLI_RET, common.getMsg(
                LANG,
                "hypermetro.mutipath.version.lower",
                softVer)

        return True, ALL_CLI_RET, ''

    except UnCheckException, unCheckException:
        LOGGER.logInfo(
            u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if unCheckException.flag is None:
            return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET,
                    unCheckException.errorMsg)

        return unCheckException.flag, ALL_CLI_RET, unCheckException.errorMsg

    except Exception:
        LOGGER.logException()
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(
            LANG,
            "query.result.abnormal")


def updateHyperMetroLUNDict(lunWwnList):
    """
    更新低版本做双活的LUN，不在【主机自带多路径双活LUN配置检查】中显示。
    :param lunWwnList:低版本做双活的LUN
    :return:
    """
    lun_wwn_dicts = PY_JAVA_ENV.get("allStrgHyprMtrLns")
    for lun_wwn in lunWwnList:
        if lun_wwn_dicts[lun_wwn]["hostAluaStatus"] \
                == common.ALUA_CONFIGURED_NOT_CHECK:
            lun_wwn_dicts[lun_wwn][
                "hostAluaStatus"] = common.ALUA_CONFIGURED_PROPERLY
            LOGGER.logInfo(
                "found lun(WWN: %s) matched storage devs',which is "
                "desiginated to upadmin service." %
                str(lun_wwn))


def checkSoftVersion(softVer):
    """
    判断版本是否是老版本
    :param softVer:
    :return:
    """
    if softVer.startswith("8") and softVer < "8.03.028":
        return True
    elif int(softVer.split(".")[0]) < 8:
        return True

    return False


def getHostMutipathVersion(ssh):
    """
    获取主机上多路径版本
    :param ssh:
    :return: flag, softVer
            flag:True 获取成功，False 获取失败
            softVer: 版本信息
    """
    global ALL_CLI_RET
    cmd = "upadmin show version"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3 * 60)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if "Error" in cliRet \
            or "Unknown command" in cliRet \
            or "command not found" in cliRet \
            or "command-not-found" in cliRet:
        return ''

    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x: x in cliRet.lower(), regx):
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info",
                                             "UltraPath Software Version"),
                               ALL_CLI_RET)

    cliRetLines = cliRet.splitlines()
    softVer = ''
    driverVer = ''
    for line in cliRetLines:
        if "Software Version" in line:
            lineList = line.split(":")
            if len(lineList) == 2:
                softVer = lineList[1].strip()
            continue

        if "Driver   Version" in line:
            lineList = line.split(":")
            if len(lineList) == 2:
                driverVer = lineList[1].strip()

    if softVer and driverVer and softVer == driverVer:
        return softVer

    if not softVer:
        return softVer

    if softVer != driverVer:
        raise UnCheckException(
            common.getMsg(
                LANG,
                "multipath.softwareVersion.not.equal.driverVersion"),
            ALL_CLI_RET,
            False)

    return softVer


def getOldMutiPathVersion(ssh):
    """
    获取老版本多路径版本信息
    :param ssh:
    :return:
    """
    global ALL_CLI_RET
    cmd = "upadm show version"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3 * 60)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if "Error" in cliRet \
            or "Unknown command" in cliRet \
            or "command not found" in cliRet \
            or "command-not-found" in cliRet:
        return ''

    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x: x in cliRet.lower(), regx):
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info",
                                             "UltraPath Software Version"),
                               ALL_CLI_RET)

    cliRetLines = cliRet.splitlines()
    softVer = ''
    for line in cliRetLines:
        if "UltraPath for Linux" in line:
            lineList = line.split(":")
            if len(lineList) == 2:
                softVer = lineList[1].strip()
            continue

    return softVer


def getArrayInfo(ssh):
    """
    获取阵列信息
    :param ssh:
    :return:
    """
    global ALL_CLI_RET
    arrayIdList = []
    cmd = "upadm show array"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3 * 60)
    if not cliRet:
        return arrayIdList
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if "Error" in cliRet \
            or "Unknown command" in cliRet \
            or "command not found" in cliRet \
            or "command-not-found" in cliRet:
        return arrayIdList

    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x: x in cliRet.lower(), regx):
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET)

    cliRetLines = cliRet.splitlines()
    isTitleLine = False
    for line in cliRetLines:
        if not isTitleLine and "Array ID" and "WWN" in line:
            isTitleLine = True
            continue

        if isTitleLine:
            lineList = line.split()
            if not len(lineList) >= 3:
                continue

            arrayId = lineList[0].strip()
            if arrayId:
                arrayIdList.append(arrayId)
    return arrayIdList


def getLunInfoByArrayId(ssh, arrayList):
    """
    获取映射的LUN信息
    :param ssh:
    :param arrayList:
    :return:
    """
    global ALL_CLI_RET
    lunWwnList = []
    cmd = "upadm show lun array=%s"
    for arrayId in arrayList:
        cmdStr = cmd % arrayId
        cliRet = ssh.execCmd(cmdStr)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
        if filter(lambda x: x in cliRet.lower(), regx):
            raise UnCheckException(
                common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET)

        cliRetLines = cliRet.splitlines()
        for cliLine in cliRetLines:
            if "Information of Lun" in cliLine and "WWN" in cliLine:
                lineList = cliLine.split(":")
                if len(lineList) < 2:
                    continue

                wwn = lineList[1].strip().split()[0]
                lunWwnList.append(wwn)
    return lunWwnList


def getHostMappingLun(ssh):
    """
    获取主机上映射的LUN信息
    :param ssh:
    :return:
    """
    global ALL_CLI_RET
    lunWwnList = []
    cmd = "upadmin show vlun"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3 * 60)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if "Error" in cliRet \
            or "Unknown command" in cliRet \
            or "command not found" in cliRet \
            or "command-not-found" in cliRet \
            or "Can't find any vluns" in cliRet:
        return lunWwnList

    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x: x in cliRet.lower(), regx):
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", "vlun"), ALL_CLI_RET)

    cliRetLines = cliRet.splitlines()
    isFindTitle = False
    for cliLine in cliRetLines:
        if not isFindTitle and "Vlun ID".lower() in cliLine.lower():
            isFindTitle = True
            continue

        if isFindTitle:
            coloumList = cliLine.split()
            if not len(coloumList) >= 4:
                continue

            lunWWN = coloumList[3]
            lunWwnList.append(lunWWN)

    return lunWwnList


def getPathInfoFromRealArray(arrayDict, initiatorList):
    global ALL_CLI_RET, ADDED_ARRAY_SN, hasPortGroupFlagDict
    arrayInfoDict = {}
    objectForPy = PY_JAVA_ENV.get("objectForPy")
    sqlite_manager = SqliteManager()
    for arraySn in arrayDict:
        sqlite_conn = sqlite_context.get_sqlite_conn_from_context(
            objectForPy, arraySn, LOGGER
        )
        # 主机侧有，但未关联的阵列
        if not host_common.need_check_array(PY_JAVA_ENV, arraySn):
            LOGGER.logInfo(
                "array sn is:{} do not check.".format(arraySn)
            )
            continue

        p_version = host_common.get_product_version_from_mem(objectForPy,
                                                             arraySn)
        ADDED_ARRAY_SN.append(arraySn)
        ret = "\n\n----------------Array SN Echo({})" \
              "----------------\n".format(arraySn)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
        hyperLunDict = getHyperLunDictOnArray(sqlite_manager, sqlite_conn, arraySn)
        LOGGER.logInfo(
            "arraySn:%s, hyperLunDict:%s" % (arraySn, hyperLunDict))
        initiatorPortLinkDict, cli_ret = host_common.getPortInfo(
            sqlite_manager, sqlite_conn, arraySn, LANG
        )
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)

        # 首先看config中有没有fc启动器信息
        host_fc_ini_dict = host_common.get_fc_ini_from_config(
            objectForPy, p_version, arraySn, LOGGER
        )
        # 如果没有则使用命令查询和require保持一致的查询策略
        if not host_fc_ini_dict:
            cmd = "show initiator initiator_type=FC"
            host_fc_ini_dict = host_common.get_host_ini_info(
                sqlite_manager, sqlite_conn, arraySn, LANG, cmd, "WWN"
            )

        # 获取主机ISCSI启动器信息
        cmd = "show initiator initiator_type=iSCSI"
        host_iscsi_ini_dict = host_common.get_host_ini_info(
            sqlite_manager, sqlite_conn, arraySn, LANG, cmd, "iSCSI IQN"
        )

        cmd = "show nvme_over_roce_initiator general"
        host_nqn_ini_dict = host_common.get_host_ini_info(
            sqlite_manager, sqlite_conn, arraySn, LANG, cmd, "NQN"
        )

        # nvme nqn 是iscsi协议合入iscsi判断标准
        host_iscsi_ini_dict = merge_ini_dict(
            host_nqn_ini_dict, host_iscsi_ini_dict
        )

        # 从config中获取信息，如果获取失败，则使用命令查询
        use_running_data_dict = host_common.get_running_data(
            objectForPy, p_version, arraySn
        )
        if use_running_data_dict:
            (
                notStandardViewList, onlyIscsiViewLunWWNList,
                lunPathInfoDict, lunHostDict,
            ) = host_common.get_mapping_initiator_from_config(
                objectForPy, p_version, arraySn, hyperLunDict,
                initiatorPortLinkDict, initiatorList, host_fc_ini_dict,
                host_iscsi_ini_dict, LOGGER,
            )
            cli_ret = host_common.CONFIG_CLI_RET.format(str(lunPathInfoDict))
            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        else:
            LOGGER.logInfo("arraySn:%s, initiatorPortLinkDict:%s" % (
                arraySn, str(initiatorPortLinkDict)))
            (
                notStandardViewList, onlyIscsiViewLunWWNList, lunPathInfoDict,
                lunHostDict, all_ret,
            ) = get_mapping_ini(
                sqlite_manager, sqlite_conn, arraySn, hyperLunDict,
                initiatorPortLinkDict, initiatorList, host_fc_ini_dict,
                host_iscsi_ini_dict
            )
            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, all_ret)

        arrayInfoDict[arraySn] = {
            "notStandardViewList": notStandardViewList,
            "onlyIscsiViewLunWWNList": onlyIscsiViewLunWWNList,
            "lunPathInfoDict": lunPathInfoDict,
            "lunHostDict": lunHostDict
        }

    return arrayInfoDict


def merge_ini_dict(data_dict, mg_dict):
    """
    合并启动器信息 key:[ini,ini]的数据
    :param data_dict: 待合并
    :param mg_dict: 合并后对象
    :return: 合并后对象
    """
    for key, value in data_dict.items():
        if key in mg_dict:
            tmp_list = mg_dict.get(key, [])
            tmp_list.extend(value)
            mg_dict[key] = tmp_list
        else:
            mg_dict[key] = value
    return mg_dict


def get_mapping_ini(
        sqlite_manager, sqlite_conn,sn, h_lun, ini_dict, ini_list,
        fc_ini_dict, iscsi_ini_dict
):
    param_dict = dict()
    param_dict["sqlite_manager"] = sqlite_manager
    param_dict["sqlite_conn"] = sqlite_conn
    param_dict["sn"] = sn
    param_dict["hyperLunDict"] = h_lun
    param_dict["initiatorAndPortLinkDict"] = ini_dict
    param_dict["initiatorOnHostList"] = ini_list
    param_dict["host_fc_ini_dict"] = fc_ini_dict
    param_dict["host_iscsi_ini_dict"] = iscsi_ini_dict
    param_dict["lang"] = LANG
    param_dict["LOGGER"] = LOGGER
    return host_common.get_mapping_view_initiator_dorado_v6(param_dict)



def getCmdRes(sqlite_manager, sqlite_conn, cmd, sn):
    """
    从内存中获取命令回显API
    :param sqlite_manager: 防止每次创建数据库管理
    :param sqlite_conn: 数据库连接
    :param cmd: 命令
    :param sn: 设备SN
    :return:
    """
    return host_common.get_cmd_res(sqlite_manager, sqlite_conn, cmd, sn, LANG)


def getHyperLunDictOnArray(sqlite_manager, sqlite_conn, sn):
    """
    获取阵列侧的双活LUN
    :param sqlite_manager:
    :param sqlite_conn:
    :param sn:
    :return:
    """
    global ALL_CLI_RET
    hyperLunDict = {}
    cmd = "show hyper_metro_pair general |filterRow " \
          "column=Type predict=equal_to value=LUN |filterColumn " \
          r"include columnList=Local\sID,WWN"
    flag, cliRet, errMsg = getCmdRes(sqlite_manager, sqlite_conn, cmd, sn)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag is not True:
        raise UnCheckException(errMsg, ALL_CLI_RET, flag)

    # 获取伪装LUN信息
    take_lun_info_dict = get_take_lun(sqlite_manager, sqlite_conn, sn)
    hyperLunDictList = common.getHorizontalCliRet(cliRet)
    for info in hyperLunDictList:
        lunId = info.get("Local ID", "")
        lunWWN = info.get("WWN", "")
        if lunId and lunWWN:
            if take_lun_info_dict and lunWWN in take_lun_info_dict:
                lunWWN = take_lun_info_dict.get(lunWWN)
            hyperLunDict[lunId] = lunWWN

    return hyperLunDict


def get_take_lun(sqlite_manager, sqlite_conn, sn):
    """
    获取伪装LUN信息，如果伪装LUN做双活需要使用伪装过后的LUN WWN和主机上的
    LUN WWN匹配
    :param sqlite_manager: 数据库管理对象
    :param sqlite_conn: 当前阵列数据库连接
    :param sn: 当前阵列SN
    :return: {常规LUN WWN : 伪装LUN WWN}
    """
    take_lun_dict = {}
    cmd_str = "show lun_takeover general"
    flag, cli_ret, err_msg = getCmdRes(sqlite_manager, sqlite_conn, cmd_str, sn)
    if flag is not True:
        msg = common.getMsg(LANG, "hyper.lun.accepted.take.lun.error")
        raise UnCheckException(msg, ALL_CLI_RET)

    take_lun_info_list = common.get_horizontal_nostandard_cli_ret(cli_ret)
    for take_lun_info in take_lun_info_list:
        local_wwn = take_lun_info.get("WWN", "")
        t_lun_wwn = take_lun_info.get("Takeover LUN WWN", "")
        take_lun_dict[local_wwn] = t_lun_wwn

    return take_lun_dict


def hasPortGroup(sqlite_manager, sqlite_conn, sn):
    """
    判断是否有端口组
    :param sqlite_manager: 数据库管理对象
    :param sqlite_conn: 当前阵列数据库连接
    :param sn: 当前阵列SN
    :return:
    """
    global ALL_CLI_RET
    hasPortGroupFlag = False
    mappingViewList = []
    cmd = "show mapping_view general"
    flag, cliRet, errMsg = getCmdRes(sqlite_manager, sqlite_conn, cmd, sn)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    tmpResDict = common.getHorizontalCliRet(cliRet)
    for tmpDict in tmpResDict:
        mappId = tmpDict.get("Mapping View ID", '')
        if mappId:
            mappingViewList.append(mappId)

    cmdStr = "show mapping_view general mapping_view_id=%s"
    for mappId in mappingViewList:
        cmd = cmdStr % mappId
        flag, cliRet, errMsg = getCmdRes(sqlite_manager, sqlite_conn, cmd, sn)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        tmpResDict = common.getVerticalCliRet(cliRet)
        for tmpDict in tmpResDict:
            protGroupId = tmpDict.get("Port Group ID", '')
            if protGroupId and protGroupId != "--":
                hasPortGroupFlag = True
                return hasPortGroupFlag

    return hasPortGroupFlag
