# -*- coding: UTF-8 -*-

import common
import cliUtil
import config
import traceback
from common import UnCheckException

LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = py_java_env.get("lang")


def execute(ssh):
    """
    Fusioncomputer多路径工作模式检查
    :param ssh:
    :return:
    """
    all_cli_ret_list = []
    context = py_java_env

    try:

        # 更新新版本时内存中的LUN标记。
        common.mark_host_upadmin_hyper_metro_luns(py_java_env, ssh, LOGGER)

        # 获取华为双活LUN的信息
        lun_wwn_dicts = context.get("allStrgHyprMtrLns")
        LOGGER.logInfo("array hyper lun:%s" % str(lun_wwn_dicts))
        if not lun_wwn_dicts:
            return True, "NO HYPER METRO LUN ON STORAGE.", ""

        # 检查本次巡检的所有存储设备和补丁的信息
        risk_array_sn_list = check_array_version(all_cli_ret_list)
        LOGGER.logInfo("risk sn list is:%s" % str(risk_array_sn_list))
        if not risk_array_sn_list:
            return True, "\n".join(all_cli_ret_list), ''

        # 检查是否是fusion computer
        is_fusion_computer = check_is_fusion_computer(ssh, all_cli_ret_list)
        LOGGER.logInfo("is fusion computer :%s" % str(is_fusion_computer))
        if not is_fusion_computer:
            return True, "\n".join(all_cli_ret_list), ''

        # 获取主机映射LUN的回显，判断阵列双活LUN是否在当前主机上
        cli_ret = get_host_mapping_lun(ssh, all_cli_ret_list)
        exist_flag = False
        for lun_wwn in lun_wwn_dicts:
            lun_wwn_upper = lun_wwn.upper()
            if lun_wwn_upper in cli_ret.upper():
                exist_flag = True
                break
        LOGGER.logInfo("is hyper host:%s" % str(exist_flag))

        # 如果非双活主机，则建议优化
        if not exist_flag:
            msg = common.getMsg(LANG, "fusion.workingmode.suggestion",
                                ",".join(risk_array_sn_list))
            return cliUtil.RESULT_WARNING, "\n".join(all_cli_ret_list), msg

        # 双活主机则不通过
        msg = common.getMsg(LANG, "fusion.workingmode.nopass",
                            ",".join(risk_array_sn_list))
        return False, "\n".join(all_cli_ret_list), msg

    except UnCheckException as e:
        LOGGER.logError(str(traceback.format_exc()))
        return e.flag, "\n".join(all_cli_ret_list), e.errorMsg

    except Exception as e:
        LOGGER.logError(str(e))
        return (cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret_list),
                common.getMsg(LANG, "query.result.abnormal"))


def check_array_version(all_cli_ret_list):
    """
    检查阵列版本和补丁信息
    :param all_cli_ret_list: 回文
    :return:阵列补丁小于既定补丁的存储SN
    """
    array_sn_list = []
    object_for_py = py_java_env.get("objectForPy")
    array_version_info = object_for_py.get("array_product_version_info")
    if not array_version_info:
        return array_sn_list

    for sn in array_version_info:
        tmp_dict = array_version_info.get(sn, {})
        # 补丁和版本信息
        p_version = tmp_dict.get("product version", '')
        p_patch = tmp_dict.get("hot patch version", '')
        p_patch_flag = tmp_dict.get("patch cli flag", True)
        p_patch_ret = tmp_dict.get("patch cli ret", '')
        p_patch_msg = tmp_dict.get("patch cli msg", '')

        # 双活lun 信息
        p_lun_ret = tmp_dict.get("hyper lun cli ret", '')
        p_lun_flag = tmp_dict.get("hyper lun flag", True)
        p_lun_msg = tmp_dict.get("hyper lun msg", "")
        all_cli_ret_list.append("\n\n-------ARRAY SN:%s--------" % sn)
        all_cli_ret_list.append(p_patch_ret)
        all_cli_ret_list.append(p_lun_ret)
        if p_patch_flag is not True:
            raise UnCheckException(p_patch_msg, "\n".join(all_cli_ret_list))

        if p_lun_flag is not True:
            raise UnCheckException(p_lun_msg, "\n".join(all_cli_ret_list))

        if p_version not in config.fusion_working_mode_product:
            continue

        # 处理无补丁版本场景
        if config.fusion_working_mode_product.get(p_version, "--") == "--":
            array_sn_list.append(sn)
            continue

        # 处理补丁信息小于既定补丁场景
        if p_patch < config.fusion_working_mode_product.get(p_version, "--"):
            array_sn_list.append(sn)

    return array_sn_list


def get_host_mapping_lun(ssh, all_cli_ret_list):
    """
    获取主机上映射的LUN信息
    :param ssh:连接
    :param all_cli_ret_list: 回文
    :return:
    """
    cmd = "upadmin show vlun"
    flag, cli_ret, err_msg = cliUtil.executeCmdWithTimeout(ssh, cmd, LOGGER)
    all_cli_ret_list.append(cli_ret)
    if not check_command_support(cli_ret):
        cmd = "multipath -ll"
        flag, cli_ret, err_msg = cliUtil.executeCmdWithTimeout(ssh, cmd,
                                                               LOGGER)
        all_cli_ret_list.append(cli_ret)
        if not check_command_support(cli_ret):
            return cli_ret

    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x: x in cli_ret.lower(), regx):
        err_msg = common.getMsg(LANG, "cannot.get.info", "vlun")
        raise UnCheckException(err_msg, "\n".join(all_cli_ret_list))

    return cli_ret


def check_command_support(cli_ret):
    """
    检查是否命令支持
    :param cli_ret: 执行命令回文
    :return: True支持， False: 不支持
    """
    if "Error" in cli_ret or "Unknown command" in cli_ret \
            or "command not found" in cli_ret \
            or "command-not-found" in cli_ret \
            or "Can't find any vluns" in cli_ret:
        return False

    return True


def check_is_fusion_computer(ssh, all_cli_ret_list):
    """
    检查是否fusion_computer主机
    :param ssh: 连接
    :param all_cli_ret_list: 回文
    :return:True: 是，False:否。
    """
    cmd = "cat /opt/galax/version/GalaxVersion.cfg"
    flag, cli_ret, err_msg = cliUtil.executeCmdWithTimeout(ssh, cmd, LOGGER)
    all_cli_ret_list.append(cli_ret)
    if "no such file or directory" in cli_ret.lower():
        return False

    return True
