# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(ssh):
    cmd = "systemctl -a|grep 'CDM ' |grep -v running|grep -v HWSvrMgmService.service"
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    # 行数为2的话说明命令没有回显，检查通过
    if len(cli_ret_list) == 2:
        return True, cli_ret, ""
    err_msg = common.getMsg(LANG, "dpa.check.service.status.abnormal")
    LOGGER.logNoPass("Some services are running abnormally.")
    return False, cli_ret, err_msg
