# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(ssh):
    total_cli_ret = []
    dpa_version, ver_cli_ret = common.get_dpa_version(ssh, LOGGER)
    total_cli_ret.append(ver_cli_ret)
    if common.compare_dpa_version(dpa_version, "8.0.1.9"):
        cmd = "cd /opt/CDMServer/HWEOSSService; export LD_LIBRARY_PATH=. ; chmod u+x eoss_client_tool ; " \
              "echo exit | su -s /bin/bash hwcdm -c './eoss_client_tool --cmd=meta.gns' 2> /dev/null | " \
              "awk -F'|' '{print $3}'|grep -v ^$|sort |uniq -c"
        cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
        total_cli_ret.append(cli_ret)
        cli_ret_list = cli_ret.encode("utf8").splitlines()
        for line in cli_ret_list[1:-1]:
            if line.split()[0] != "1":
                return False, "\n".join(total_cli_ret), common.getMsg(LANG, "dpa.contact.technical.support.engineers")
    elif common.compare_dpa_version("8.0.1.6", dpa_version):
        cmd = 'cat /var/log/CDM/HWEOSSService/eoss_*_svc* |grep multi'
        cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
        total_cli_ret.append(cli_ret)
        # 没有打印则检查通过，否则上报异常
        if len(cli_ret.splitlines()) > 2:
            return False, "\n".join(total_cli_ret), common.getMsg(LANG, "dpa.contact.technical.support.engineers")
    return True, "\n".join(total_cli_ret), ""

