# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.


import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ENVIRONMENT_FLAG = "no such user"
EARLY_VERSION_INVOLVED = "8.0.1.6"
total_cli_ret = []
total_err_msg = []


def execute(ssh):
    dpa_version, cli_ret = common.get_dpa_version(ssh, LOGGER)
    total_cli_ret.append(cli_ret)
    if not dpa_version:
        total_err_msg.append(common.getMsg(LANG, "query.result.abnormal"))
        return False, "\n".join(total_cli_ret), "".join(total_err_msg)
    # 如果版本低于最低涉及版本，返回通过
    if common.compare_dpa_version(dpa_version, EARLY_VERSION_INVOLVED):
        return True, "\n".join(total_cli_ret), "".join(total_err_msg)
    pre_operation_cli_ret, pre_operation_err_msg = common.eoss_client_tool_pre_operation(ssh, dpa_version)
    total_cli_ret.append(pre_operation_cli_ret)
    check_cli_ret, check_err_msg = check_cleanup_queue(ssh)
    total_cli_ret.append(check_cli_ret)
    total_err_msg.extend(check_err_msg)
    if total_err_msg:
        return False, "\n".join(total_cli_ret), "".join(total_err_msg)
    return True, "\n".join(total_cli_ret), "".join(total_err_msg)


def check_cleanup_queue(ssh):
    cmd = './eoss_client_tool --cmd=mgm.listrecqueue'
    cli_ret = ssh.execCmd(cmd)
    cli_ret_list = cli_ret.splitlines()
    err_msg_lst = []
    clean_rec_count = 0
    temp = []
    for line in cli_ret_list:
        temp.append(line)
        if not line:
            if clean_rec_count > 30:
                err_msg_lst.append(common.getMsg(LANG, "dpa.check.cleanup.queue.abnormal"))
            clean_rec_count, temp = 0, []
            continue
        if line.count("|") == 3:
            if line.split("|")[1].strip().isdecimal() and line.split("|")[2].strip():
                clean_rec_count += 1
    return cli_ret, err_msg_lst
