# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(ssh):
    cli_ret = ""
    try:
        cmd = "df -BM /opt/CDMServerUpdate"
        cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
        cli_ret_list = cli_ret.encode("utf8").splitlines()
        directory_capacity = int(cli_ret_list[2].split()[3].rstrip("M"))
        LOGGER.logInfo("cli_ret_list:{}".format(cli_ret_list))
        LOGGER.logInfo("space:{}".format(directory_capacity))
        file_total_size = get_file_total_size(ssh)
        LOGGER.logInfo("file_total_size:{}".format(file_total_size))
        if directory_capacity < file_total_size:
            err_msg = common.getMsg(LANG, "dpa.directory.capacity.abnormal", directory_capacity)
            LOGGER.logNoPass("The space [{}]MB is incorrectly".format(
                directory_capacity)
            )
            return False, cli_ret, err_msg
        return True, cli_ret, ""
    except Exception as e:
        LOGGER.logError(str(e))
        return (cliUtil.RESULT_NOCHECK, cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))


def get_file_total_size(ssh):
    total_size = 0
    cmd = "cat /opt/CDMServerUpdate/etc/conf.ini"
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()

    for cli_tem_var in cli_ret_list:
        if "upload_limit" in cli_tem_var or "backup_limit" in cli_tem_var:
            total_size += float(cli_tem_var.split("=")[1])
    return total_size
