# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
TABLE_HEAD_NAME = "Use%"
CONTENT_NAMES = ("/opt", "/var")
total_err_msg = list()
total_cli_ret = list()


def execute(ssh):
    try:
        for content_name in CONTENT_NAMES:
            cli_ret = check_disk_usage(ssh, content_name)
            total_cli_ret.append(cli_ret)
        if total_err_msg:
            LOGGER.logNoPass("The available space of the system disk is less than 50% of total space.")
            return False, "\n".join(total_cli_ret), "".join(total_err_msg)
        return True, "\n".join(total_cli_ret), ""
    except Exception as e:
        LOGGER.logError(str(e))
        total_err_msg.append(common.getMsg(LANG, "query.result.abnormal"))
        return cliUtil.RESULT_NOCHECK, "\n".join(total_cli_ret), "".join(total_err_msg)


def check_disk_usage(ssh, content):
    cmd = "df -h {}".format(content)
    cli_ret = ssh.execCmd(cmd)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if len(cli_ret_list) < 3:
        total_err_msg.append(common.getMsg(LANG, "query.result.abnormal"))
        return cli_ret
    disk_free_value = cli_ret_list[2].split()
    table_head = cli_ret_list[1].split()
    # 使用表头解析索引
    disk_usage = disk_free_value[table_head.index(TABLE_HEAD_NAME)]
    LOGGER.logInfo("usage:{}".format(disk_usage))
    # 回显值小于等于50%，则检查通过，否则检查不通过
    if int(disk_usage[:-1]) > 50:
        total_err_msg.append(common.getMsg(LANG, "dpa.system.disk.used.status.abnormal", (content, disk_usage)))
        return cli_ret
    return cli_ret
