# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ENVIRONMENT_FLAG = "no such user"
NO_FILE_FLAG = "No such file or directory"
TABLE_HEAD_NAME = "free"
CRONTAB_RETURNS = (
    "*/1 * * * * bash /opt/fusionstorage/agent/script/dpa_judge_drop_cache.sh > /dev/null 2>&1",
    "*/1 * * * * sleep 30; bash /opt/fusionstorage/agent/script/dpa_judge_drop_cache.sh > /dev/null 2>&1"
)
total_cli_ret = list()
total_err_msg = list()


def execute(ssh):
    env_flag, cli_ret = common.check_dpa_environment(ssh, LOGGER)
    total_cli_ret.append(cli_ret)
    if env_flag:
        cli_ret = check_drop_cache_log(ssh, "", env_flag)
        total_cli_ret.append(cli_ret)
    else:
        # 获取dpa版本
        dpa_version, cli_ret = common.get_dpa_version(ssh, LOGGER)
        total_cli_ret.append(cli_ret)
        if not dpa_version:
            total_err_msg.append(common.getMsg(LANG, "query.result.abnormal"))
            return False, "\n".join(total_cli_ret), "".join(total_err_msg)
        cli_ret = check_crontab(ssh)
        total_cli_ret.append(cli_ret)
        if total_err_msg:
            return False, "\n".join(total_cli_ret), "".join(total_err_msg)
        cli_ret = check_drop_cache_log(ssh, dpa_version, env_flag)
        total_cli_ret.append(cli_ret)
    if total_err_msg:
        return False, "\n".join(total_cli_ret), "".join(total_err_msg)
    return True, "\n".join(total_cli_ret), ""


def check_crontab(ssh):
    """
    获取命令回显记录，若存在回显行与CRONTAB_RETURNS的全部内容对应，则通过
    """
    cmd = 'crontab -l | grep "dpa_judge_drop_cache"'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    result = [ret_line in cli_ret_list for ret_line in CRONTAB_RETURNS]
    if False in result:
        total_err_msg.append(common.getMsg(LANG, "dpa.drop.cache.config.abnormal"))
        return cli_ret
    return cli_ret


def check_drop_cache_log(ssh, dpa_version, env_flag):
    """
    param： env_flag：True单机模式 False分布式
    """
    if env_flag:
        cmd = 'cat /var/log/dpa_judge_drop_cache_standalone.log'
        cli_ret = ssh.execCmd(cmd)
        cli_ret_list = cli_ret.encode("utf8").splitlines()
    else:
        if common.compare_dpa_version("8.0.1.7", dpa_version):
            cmd = 'tail -n 100 /var/log/cron | grep "dpa_judge_drop_cache"'
            cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
            cli_ret_list = cli_ret.encode("utf8").splitlines()
        else:
            cmd = 'cat /var/log/oam/fsa/script/agent_handle.log | grep -a "dpa_judge_drop_cache"'
            cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
            cli_ret_list = cli_ret.encode("utf8").splitlines()
    if len(cli_ret_list) == 2 or NO_FILE_FLAG in cli_ret:
        total_err_msg.append(common.getMsg(LANG, "dpa.drop.cache.config.abnormal"))
        return cli_ret
    return cli_ret
