# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ENVIRONMENT_FLAG = "no such user"
TABLE_HEAD_NAME = "free"
MIN_MIB_MEMORY = 12288
MIB_TO_KIB = 1024


def execute(ssh):
    # 检查主机环境
    env_flag, cli_ret = common.check_dpa_environment(ssh, LOGGER)
    if env_flag:
        # 主机环境为单机
        return check_single_node_system_free_memory(ssh)
    else:
        # 主机环境为分布式
        return check_distributed_system_free_memory(ssh)


def check_single_node_system_free_memory(ssh):
    cli_ret = ""
    try:
        mem_free, cli_ret, err_msg = get_free_memory(ssh, "", "only_node system")
        if int(mem_free) < MIN_MIB_MEMORY:
            err_msg += common.getMsg(LANG, "dpa.check.memory.status.abnormal", mem_free)
            LOGGER.logNoPass("the free column of the Mem line is {}, less than 12288.".format(mem_free))
            return False, cli_ret, err_msg
        return True, cli_ret, err_msg
    except Exception as e:
        LOGGER.logError(str(e))
        return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "query.result.abnormal")


def check_distributed_system_free_memory(ssh):
    cli_ret = ""
    try:
        mem_free, cli_ret, err_msg = get_free_memory(ssh, '"KiB Mem"', "distributed system")
        if not mem_free:
            mem_free, cli_ret, err_msg = get_free_memory(ssh, '"MiB Mem"', "distributed system")
            # 两个命令都没获取到结果则返回获取失败
            if not mem_free:
                err_msg += common.getMsg(LANG, "query.result.abnormal")
                return False, cli_ret, err_msg
            if float(mem_free) < MIN_MIB_MEMORY:
                err_msg += common.getMsg(LANG, "dpa.free.memory.abnormal", (mem_free, MIN_MIB_MEMORY))
                return False, cli_ret, err_msg
            return True, cli_ret, ""
        if float(mem_free) < MIN_MIB_MEMORY * MIB_TO_KIB:
            err_msg += common.getMsg(LANG, "dpa.free.memory.abnormal", (mem_free, MIN_MIB_MEMORY * MIB_TO_KIB))
            return False, cli_ret, err_msg
        return True, cli_ret, ""
    except Exception as e:
        LOGGER.logError(str(e))
        return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "query.result.abnormal")


def get_free_memory(ssh, para, sys_type):
    err_msg = ""
    cli_ret = ""
    mem_free = ""
    if sys_type == "distributed system":
        # 分布式环境，执行以下检查
        cmd = 'find /var/log/oam/sys_data/bak -mtime -1|xargs zgrep -a {}|sort -n -k 6|head -1'.format(para)
        cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
        cli_ret_list = cli_ret.encode("utf8").splitlines()
        # 回显行数为2，则命令查询失败，返回空值
        if len(cli_ret_list) == 2:
            return None, cli_ret, err_msg
        mem_info = cli_ret_list[1].split()
        mem_free = mem_info[mem_info.index("free,") - 1]
        LOGGER.logInfo("free memory:{} {}".format(mem_free, para))
        return mem_free, cli_ret, err_msg
    elif sys_type == "only_node system":
        # 单机环境，执行以下检查
        cmd = 'free -m'
        cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
        cli_ret_list = cli_ret.encode("utf8").splitlines()
        # 判断回显是否正常，如果回显异常直接报错
        if len(cli_ret_list) != 5 or TABLE_HEAD_NAME not in cli_ret_list[1].split():
            err_msg = common.getMsg(LANG, "dpa.check.abnormal")
            return "", cli_ret, err_msg
        mem_value = cli_ret_list[2].split()
        if len(mem_value) < 4:
            err_msg = common.getMsg(LANG, "dpa.check.abnormal")
            return "", cli_ret, err_msg
        table_head = cli_ret_list[1].split()
        # 使用表头解析索引
        mem_free = mem_value[table_head.index(TABLE_HEAD_NAME) + 1]
        LOGGER.logInfo("mem_free:{}".format(mem_free))
    return mem_free, cli_ret, err_msg
