# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(ssh):
    flag, cli_ret, open_files_max_number = get_open_files_max_number(ssh)
    if not flag:
        err_msg = common.getMsg(LANG, "dpa.check.abnormal")
        return False, cli_ret, err_msg
    # 回显open files行 如果小于65535则检查不通过
    if open_files_max_number < 65535:
        err_msg = common.getMsg(LANG, "dpa.check.handle.numbers.abnormal", open_files_max_number)
        LOGGER.logNoPass("The number of printed open files is less than 65535.")
        return False, cli_ret, err_msg
    return True, cli_ret, ""


def get_open_files_max_number(ssh):
    cmd = 'ulimit -a | grep "open files"'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if len(cli_ret_list) < 3:
        return False, cli_ret, ""
    return True, cli_ret, int(cli_ret_list[1].split()[-1])
