# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(ssh):
    cmd = 'cat /etc/ssh/sshd_config  |grep ClientAlive |grep -v "#"'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    client_alive_interval = float(cli_ret_list[1].split()[1])
    client_alive_count_max = float(cli_ret_list[2].split()[1])
    if client_alive_interval * client_alive_count_max < 900:
        #要求这两个变量乘积大于900
        err_msg = common.getMsg(LANG, "dpa.keepalive.status.abnormal", (cli_ret_list[1], cli_ret_list[2]))
        LOGGER.logNoPass("Keepalive configuration abnormal[{},{}]".format(cli_ret_list[1], cli_ret_list[2]))
        return False, cli_ret, err_msg
    return True, cli_ret, ""
