# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.

import re
import common
import cliUtil

PY_JAVA_ENV = py_java_env
LANG = PY_JAVA_ENV.get("lang")
LOGGER = common.getLogger(PY_LOGGER, __file__)
REQUIRE_LOAD = 8


def execute(ssh):
    cli_ret_list = list()
    try:
        cpus_value, cli_ret = get_cpus_value(ssh)
        cli_ret_list.append(cli_ret)
        if not cpus_value:
            # 未获取成功
            LOGGER.logNoPass("There is an error in getting information")
            err_msg = common.getMsg(LANG, "query.result.abnormal")
            return False, "\n".join(cli_ret_list), err_msg
        cli_ret, err_msg = check_load_average(ssh, cpus_value)
        cli_ret_list.append(cli_ret)
        if err_msg:
            return False, "\n".join(cli_ret_list), err_msg
        return True, "\n".join(cli_ret_list), ""
    except Exception as e:
        LOGGER.logError(str(e))
        return cliUtil.RESULT_NOCHECK, "\n".join(cli_ret_list), common.getMsg(LANG, "query.result.abnormal")


def get_cpus_value(ssh):
    """
    获取CPU核个数
    """
    cmd = "lscpu"
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    for cpu_info in cli_ret_list[1:]:
        info_value = cpu_info.split()
        if len(info_value) < 2:
            continue
        if info_value[0] == "CPU(s):":
            return info_value[-1], cli_ret
    return "", cli_ret


def check_load_average(ssh, cpus_value):
    cmd = "top -M -s -n 1 -b"
    cli_ret = ssh.execCmd(cmd)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if len(cli_ret_list) < 2:
        err_msg = common.getMsg(LANG, "query.result.abnormal")
        return cli_ret, err_msg
    load_ave_list = cli_ret_list[1].split(",")
    fifteen_minute_load_average = float(load_ave_list[-1].strip())
    five_minute_load_average = float(load_ave_list[-2].strip()) if len(load_ave_list) > 1 else 0
    for tem_var in load_ave_list:
        if "load average" in tem_var:
            one_minute_load_average = float(tem_var.split(':')[1].strip())
            load_averages = [one_minute_load_average, five_minute_load_average, fifteen_minute_load_average]
            if max(load_averages) > int(cpus_value) * 16:
                err_msg = common.getMsg(LANG, "dpa.load.status.abnormal", str(load_averages))
                LOGGER.logNoPass(
                    "The average load of 1 minute, 5 minutes, and 15 minutes is [{}].".format(str(load_averages)))
                return cli_ret, err_msg
            return cli_ret, ""
    LOGGER.logNoPass("There is an error in getting information")
    err_msg = common.getMsg(LANG, "query.result.abnormal")
    return cli_ret, err_msg
