# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(ssh):
    cli_ret = ""
    try:
        cmd = "free -m"
        cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
        cli_ret_list = cli_ret.encode("utf8").splitlines()
        LOGGER.logInfo("cli_ret_list:{}".format(cli_ret_list))
        total_mem = float(cli_ret_list[2].split()[1])
        if total_mem <= 16 * 1024:
            # 要求内存总量大于16GB，换算单位：
            err_msg = common.getMsg(LANG, "dpa.total.memory.abnormal", total_mem)
            LOGGER.logNoPass("The total capacity [{}]MB is less than the required capacity.".format(total_mem))
            return False, cli_ret, err_msg
        return True, cli_ret, ""

    except Exception as e:
        LOGGER.logError(str(e))
        return (cliUtil.RESULT_NOCHECK, cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))
