# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
TABLE_HEAD_NAME = "free"


def execute(ssh):
    cmd = 'free -m'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    # 判断回显是否正常，如果回显异常直接报错
    if len(cli_ret_list) != 5 or TABLE_HEAD_NAME not in cli_ret_list[1].split():
        err_msg = common.getMsg(LANG, "dpa.check.abnormal")
        return False, cli_ret, err_msg
    mem_value = cli_ret_list[2].split()
    if len(mem_value) < 4:
        err_msg = common.getMsg(LANG, "dpa.check.abnormal")
        return False, cli_ret, err_msg
    table_head = cli_ret_list[1].split()
    # 使用表头解析索引
    mem_free = int(mem_value[table_head.index(TABLE_HEAD_NAME) + 1])
    LOGGER.logInfo("+++{}".format(mem_free))
    # 回显Mem行free列值小于等于16384，则检查不通过，否则检查通过。
    if mem_free <= 16384:
        err_msg = common.getMsg(LANG, "dpa.check.memory.status.abnormal", mem_free)
        LOGGER.logNoPass("the free column of the Mem line is {}, less than or equal to 16384.".format(mem_free))
        return False, cli_ret, err_msg
    return True, cli_ret, ""
