# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import common
import cliUtil
from java.lang import Exception as JException

PY_JAVA_ENV = py_java_env
LANG = PY_JAVA_ENV.get("lang")
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(ssh):
    cli_ret = ""
    try:
        net_manager_flag, net_manager_cli_ret, net_manager_err_msg = _network_manager_check(ssh)
        net_service_flag, network_service_cli_ret, network_service_err_msg = _network_service_check(ssh)
        cli_ret = '{}\n{}'.format(net_manager_cli_ret, network_service_cli_ret)
        if net_manager_flag and net_service_flag:
            return True, cli_ret, ""
        return False, cli_ret, net_manager_err_msg + network_service_err_msg
    except (Exception, JException) as e:
        LOGGER.logError(str(e))
        return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "query.result.abnormal")


def _network_manager_check(ssh):
    cli_ret, cli_ret_list = _active_service(ssh, "NetworkManager.service")
    if cli_ret_list[1] != "inactive":
        err_msg = common.getMsg(LANG, "dpa.network.manager.service.abnormal")
        LOGGER.logNoPass("The NetworkManager.service service is abnormal.")
        return False, cli_ret, err_msg
    return True, cli_ret, ""


def _network_service_check(ssh):
    cli_ret, cli_ret_list = _active_service(ssh, "network")
    if cli_ret_list[1] != "active":
        err_msg = common.getMsg(LANG, "dpa.network.abnormal")
        LOGGER.logNoPass("The network service is abnormal.")
        return False, cli_ret, err_msg
    return True, cli_ret, ""


def _active_service(ssh, service_name):
    cmd = 'systemctl is-active {}'.format(service_name)
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    return cli_ret, cli_ret.encode("utf8").splitlines()
