# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ENVIRONMENT_FLAG = "no such user"
STANDALONE_OS_VERSION = {
    "8.0.1.7": ["3.10.0-862.14.1.5.h654.eulerosv2r7.x86_64",
                "4.19.36-vhulk1907.1.0.h1130.eulerosv2r8.aarch64"],
    "8.0.1.8": ["4.18.0-147.5.2.2.h657.eulerosv2r10.x86_64",
                "4.18.0-147.5.2.19.h1260.eulerosv2r10.x86_64",
                "4.19.90-vhulk2108.6.0.h832.eulerosv2r10.aarch64",
                "4.19.90-vhulk2211.3.0.h1489.eulerosv2r10.aarch64"],
    "8.0.1.9": ["4.19.90-vhulk2211.3.0.h1489.eulerosv2r10.aarch64",
                "4.18.0-147.5.2.19.h1260.eulerosv2r10.x86_64"],
    "8.0.2.0": ["4.19.90-vhulk2211.3.0.h1654.eulerosv2r10.aarch64",
                "4.18.0-147.5.2.19.h1404.eulerosv2r10.x86_64"]
}
DISTRIBUTED_OS_VERSION = {
    "8.0.1.7": ["3.10.0-862.14.1.5.h408.eulerosv2r7.x86_64",
                "4.19.36-vhulk1907.1.0.h683.eulerosv2r8.aarch64"],
    "8.0.1.8": ["4.18.0-147.5.2.4.h694.eulerosv2r10.x86_64",
                "4.19.90-vhulk2110.1.0.h860.eulerosv2r10.aarch64"],
    "8.0.1.9": ["4.19.90-vhulk2110.1.0.h860.eulerosv2r10.aarch64",
                "4.18.0-147.5.2.4.h694.eulerosv2r10.x86_64"],
    "8.0.2.0": ["5.10.0-136.12.0.86.h1258.eulerosv2r12.aarch64",
                "5.10.0-136.12.0.86.h1258.eulerosv2r12.x86_64"]
}


def execute(ssh):
    total_cli_ret = list()
    env_flag, cli_ret = common.check_dpa_environment(ssh, LOGGER)
    total_cli_ret.append(cli_ret)
    dpa_version, cli_ret = common.get_dpa_version(ssh, LOGGER)
    total_cli_ret.append(cli_ret)
    os_version, cli_ret = get_os_version(ssh)
    total_cli_ret.append(cli_ret)
    # env_flag：True为单机，False为分布式
    if env_flag:
        if os_version in STANDALONE_OS_VERSION.get(dpa_version):
            return True, "\n".join(total_cli_ret), ""
    else:
        if os_version in DISTRIBUTED_OS_VERSION.get(dpa_version):
            return True, "\n".join(total_cli_ret), ""
    err_msg = common.getMsg(LANG, "dpa.check.os.version.abnormal")
    return False, "\n".join(total_cli_ret), err_msg


def get_os_version(ssh):
    cmd = 'cat /proc/version'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if len(cli_ret_list) < 3:
        return "", cli_ret
    check_info = cli_ret_list[1].split()
    if len(check_info) < 3:
        return "", cli_ret
    return check_info[2], cli_ret
