# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
MONTH_LIST = {
    "Jan": "01", "Feb": "02", "Mar": "03", "Apr": "04", "May": "05", "Jun": "06", "Jul": "07", "Aug": "08", "Sep": "09",
    "Oct": "10", "Nov": "11", "Dec": "12"
}
total_cli_ret = []


def execute(ssh):
    try:
        need_check_user = get_need_check_user(ssh)
        if not need_check_user:
            return True, "\n".join(total_cli_ret), ""
        expires_date = get_expires_date(ssh, need_check_user)
        if not expires_date:
            return False, "\n".join(total_cli_ret), common.getMsg(LANG, "dpa.check.abnormal")
        elif expires_date == "never":
            return True, "\n".join(total_cli_ret), ""
        now_date, date_cli_ret = get_now_date(ssh)
        if not now_date:
            return False, "\n".join(total_cli_ret), common.getMsg(LANG, "dpa.check.abnormal")
        time_difference = common.get_time_difference(now_date, expires_date)
        if time_difference < 0:
            return False, "\n".join(total_cli_ret), common.getMsg(LANG, "dpa.check.password.status.abnormal")
        elif time_difference < 30:
            err_msg = common.getMsg(LANG, "dpa.check.password.config.abnormal", time_difference)
            return False, "\n".join(total_cli_ret), err_msg
        return True, "\n".join(total_cli_ret), ""
    except Exception as e:
        LOGGER.logError(str(e))
        return cliUtil.RESULT_NOCHECK, "\n".join(total_cli_ret), common.getMsg(LANG, "query.result.abnormal")


def get_now_date(ssh):
    cmd = "date +%F"
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    total_cli_ret.append(cli_ret)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if len(cli_ret_list) == 1:
        return "", cli_ret
    now_date = cli_ret_list[1]
    return now_date, cli_ret


def get_expires_date(ssh, need_check_user):
    cmd = "sudo chage -l {}".format(need_check_user)
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    total_cli_ret.append(cli_ret)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    # 判断是否有回显, 如果无回显则返回空值
    if len(cli_ret_list) > 2 and ":" in cli_ret_list[2]:
        expires_date = cli_ret_list[2].split(": ")[1]
    else:
        return ""
    # 如果过期日期为"never"，检查通过
    if expires_date == "never":
        return expires_date
    format_date = get_format_date(expires_date)
    return format_date


def get_format_date(date):
    """
    @summary: 转换日期格式为，格式：（年 - 月 - 日），单位：天
    """
    # 传入的date格式："MMM DD, YYYY"
    month, day, year = date.split()
    # 去除末尾逗号
    format_date = "{}-{}-{}".format(year, MONTH_LIST[month], day)[:-1]
    return format_date


def get_need_check_user(ssh):
    '''
    @summary: 判断DPA设备当前环境，返回对应环境需要检查的用户，单机加固对应cdpauser、分布式对应fsadmin
    @return: 将需检查的用户名，以字符串形式返回，若无需检查，则返回None
    '''
    cmd = "id fsadmin"
    cli_ret = ssh.execCmd(cmd)
    total_cli_ret.append(cli_ret)
    # 回显含有“no such user”，则当前环境是单机
    if "no such user" in cli_ret:
        cmd = "id cdpauser"
        cli_ret = ssh.execCmd(cmd)
        total_cli_ret.append(cli_ret)
        # 回显含有“no such user”，则当前环境是未加固单机
        if "no such user" in cli_ret:
            return ""
        return "cdpauser"
    return "fsadmin"
