# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(ssh):
    cmd = "ls /opt/CDMServerUpdate"
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if "CDMServer.tmp" in cli_ret_list:
        err_msg = common.getMsg(LANG, "dpa.residual.directory.abnormal")
        LOGGER.logNoPass("The residual CDMServer.tmp directory exists.")
        return False, cli_ret, err_msg
    return True, cli_ret, ""
