# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import common
import cliUtil


PY_JAVA_ENV = py_java_env
LANG = PY_JAVA_ENV.get("lang")
LOGGER = common.getLogger(PY_LOGGER, __file__)
NORMAL_STATUS = ["disabled", "no such file or directory"]


def execute(ssh):
    cli_ret = ""
    try:
        flag_net, cli_ret_net, err_msg_net = network_manager_check(ssh)
        flag_up, cli_ret_up, err_msg_up = updata_service_check(ssh)
        cli_ret = '{}\n{}'.format(cli_ret_net, cli_ret_up)
        if flag_net and flag_up:
            return True, cli_ret, ""
        return False, cli_ret, err_msg_net + err_msg_up
    except Exception as e:
        LOGGER.logError(str(e))
        return (cliUtil.RESULT_NOCHECK, cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))


def network_manager_check(ssh):
    cmd = 'systemctl is-enabled NetworkManager.service'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if any(normal_state in cli_ret.lower() for normal_state in NORMAL_STATUS):
        return True, cli_ret, ""
    else:
        err_msg = common.getMsg(LANG, "dpa.network.service.abnormal", cli_ret_list[1])
        LOGGER.logNoPass("The NetworkManager.service service is abnormal.[{}]".format(cli_ret_list[1]))
        return False, cli_ret, err_msg


def updata_service_check(ssh):
    cmd = 'systemctl is-active HWUpdataService.service'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if cli_ret_list[1] != "inactive":
        err_msg = common.getMsg(LANG, "dpa.updata.service.abnormal", cli_ret_list[1])
        LOGGER.logNoPass("The HWUpdataService.service service is abnormal.[{}]".format(cli_ret_list[1]))
        return False, cli_ret, err_msg
    return True, cli_ret, ""
