# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
VOL_NAME = "Subsystem sftp"


def execute(ssh):
    cmd = "cat /etc/ssh/sshd_config |grep Subsystem"
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    # 检查是否有多行回显，若len > 3则表示有多行回显
    if len(cli_ret_list) == 3:
        # 检查回显行是否被注释掉(开头为#号)
        if VOL_NAME in cli_ret_list[1] and cli_ret_list[1].lstrip()[0] != "#":
            return True, cli_ret, ""
    err_msg = common.getMsg(LANG, "dpa.check.sftp.config.abnormal")
    LOGGER.logNoPass("The line in the command output is commented out or more than one line is displayed.")
    return False, cli_ret, err_msg
