# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(ssh):
    cli_ret = ""
    try:
        cmd = "du --max-depth=0  /opt/CDMServerUpdate"
        cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
        cli_ret_list = cli_ret.encode("utf8").splitlines()
        software_space = float(cli_ret_list[1].split()[0])
        file_bk_size = get_file_bk_size(ssh)
        if software_space > 0.5 * 1024 * file_bk_size:
            # 要求软件占用空间小于配置文件中配置的一半：单位换算：0.5 * 1024 * file_bk_size
            err_msg = common.getMsg(LANG, "dpa.software.space.abnormal", software_space)
            LOGGER.logNoPass("The space [{} KB] is greater than the required capacity.".format(
                software_space)
            )
            return False, cli_ret, err_msg
        return True, cli_ret, ""

    except Exception as e:
        LOGGER.logError(str(e))
        return (cliUtil.RESULT_NOCHECK, cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))


def get_file_bk_size(ssh):
    bk_list = list()
    cmd = "cat /opt/CDMServerUpdate/etc/conf.ini"
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()

    for cli_tem_var in cli_ret_list:
        if "backup_limit" in cli_tem_var:
            bk_list.append(cli_tem_var)
    return float(bk_list[0].split("=")[1])
