# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
NO_CONFIG_INFO = "no config info"


def execute(ssh):
    cli_ret = ""
    try:
        time_out_flag, time_out_cli_ret, export_time_out = check_export_time_out(ssh)
        interval_flag, interval_cli_ret, client_alive_interval = check_client_alive_interval(ssh)
        count_max_flag, count_max_cli_ret, client_alive_count_max = check_client_alive_count_max(ssh)
        cli_ret = '{}\n{}\n{}'.format(time_out_cli_ret, interval_cli_ret, count_max_cli_ret)
        if time_out_flag and interval_flag and count_max_flag:
            return True, cli_ret, ""
        err_msg = common.getMsg(LANG, "dpa.check.ssh.timeout.abnormal",
                                (export_time_out, client_alive_interval, client_alive_count_max))
        return False, cli_ret, err_msg
    except Exception as e:
        LOGGER.logError(str(e))
        return (cliUtil.RESULT_NOCHECK, cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))


def check_export_time_out(ssh):
    cmd = 'cat /etc/profile |grep "export TMOUT"'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    export_time_out = int(cli_ret_list[1].split("=")[1])
    # cat /etc/profile |grep "export TMOUT" 超时时间不超过3600s
    if export_time_out < 3600:
        LOGGER.logNoPass("The timeout period is {} and does not exceed 3600s.".format(export_time_out))
        return False, cli_ret, cli_ret_list[1]
    return True, cli_ret, cli_ret_list[1]


def check_client_alive_interval(ssh):
    cmd = 'cat /etc/ssh/sshd_config |grep "ClientAliveInterval"|grep -v "#"'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if len(cli_ret_list) < 3:
        return False, cli_ret, NO_CONFIG_INFO
    for cli_ret_line in cli_ret_list[1:-1]:
        client_alive_interval = int(cli_ret_line.split()[1])
        # cat /etc/ssh/sshd_config |grep "ClientAliveInterval"|grep -v "#" 保活时间间隔为300s
        if client_alive_interval != 300:
            LOGGER.logNoPass("The keepalive interval is {}.".format(client_alive_interval))
            return False, cli_ret, "\n".join(cli_ret_list[1:-1])
    return True, cli_ret, "\n".join(cli_ret_list[1:-1])


def check_client_alive_count_max(ssh):
    cmd = 'cat /etc/ssh/sshd_config |grep "ClientAliveCountMax"|grep -v "#"'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if len(cli_ret_list) < 3:
        return False, cli_ret, NO_CONFIG_INFO
    for cli_ret_line in cli_ret_list[1:-1]:
        client_alive_count_max = int(cli_ret_line.split()[1])
        # cat /etc/ssh/sshd_config |grep "ClientAliveCountMax"|grep -v "#" 保活计数最大值为3
        if client_alive_count_max != 3:
            LOGGER.logNoPass("The maximum value of keepalive count is {}, not 3.".format(client_alive_count_max))
            return False, cli_ret, "\n".join(cli_ret_list[1:-1])
    return True, cli_ret, "\n".join(cli_ret_list[1:-1])
