# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import re

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(ssh):
    total_cli_ret = []
    env_flag, cli_ret = common.check_dpa_environment(ssh, LOGGER)
    total_cli_ret.append(cli_ret)
    if not env_flag:
        return True, "\n".join(total_cli_ret), ""

    lsblk_info = cliUtil.getInfoFromHost(ssh, "lsblk | grep lvm | grep -E 'sdb|sdc'", LOGGER)
    total_cli_ret.append(lsblk_info)
    fs_config_list = splice_fs_config(lsblk_info)

    fstab_info = cliUtil.getInfoFromHost(ssh, "cat /etc/fstab | grep -E 'sdb|sdc'", LOGGER)
    total_cli_ret.append(fstab_info)
    fstab_info = fstab_info.encode("utf8")
    for fs_config in fs_config_list:
        if fs_config not in fstab_info:
            return False, "\n".join(total_cli_ret), common.getMsg(LANG, "dpa.mount.config.abnormal")
    return True, "\n".join(total_cli_ret), ""


def splice_fs_config(lsblk_info):
    # 通过lsblk命令查询到的逻辑卷信息，拼接标准备份挂载配置
    config_list = []
    for line in lsblk_info.encode("utf8").splitlines():
        match = re.search(r"(\w+)-(\w+) ", line)
        if not match:
            continue
        volume_group = match.group(1)
        logic_volume = match.group(2)
        mount_point = line.split()[-1]
        config_list.append("/dev/{}/{} {} xfs defaults 0 0".format(volume_group, logic_volume, mount_point))
    return config_list
