# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
VOL_NAME = "/logvol/"


def execute(ssh):
    cmd = "df -hT"
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    for cli_ret_line in cli_ret_list[1:-1]:
        if VOL_NAME in cli_ret_line.split()[-1]:
            err_msg = common.getMsg(LANG, "dpa.check.unmounting.log.abnormal")
            LOGGER.logNoPass("The {}XXXXXX mounting directory exists.".format(VOL_NAME))
            return False, cli_ret, err_msg
    return True, cli_ret, ""
