# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import time
import json
import common
import cliUtil
from java.lang import Exception as JException
import com.huawei.ism.tool.obase.entity.User as User
import com.huawei.ism.tool.obase.entity.DevNode as DevNode

PY_JAVA_ENV = py_java_env
LANG = PY_JAVA_ENV.get("lang")
LOGGER = common.getLogger(PY_LOGGER, __file__)
PASSWARD_PROTECTION = "*********"


def execute(ssh):
    nodes_dic = dict()
    try:
        err_msg = ""
        cmd = "cat /opt/CDMServerUpdate/upgrade.json"
        re_var = modify_prompts(ssh)
        cli_ret = ssh.execCmdNoLog(cmd)
        nodes_dic = json.loads(cli_ret.encode("utf8").lstrip(cmd + "|cat").rstrip(re_var))
        for node in nodes_dic.get("nodes"):
            node_ip = node.get("ssh_ip")
            node_port = int(node.get("ssh_port"))
            root_name = node.get("ssh_user")
            root_pwd = node.get("root_pwd")
            try:
                connection = get_connection_by_ip(node_ip, node_port, root_name, root_pwd, PY_JAVA_ENV)
            except JException as exp:
                err_msg += common.getMsg(LANG, "dpa.check.upgrade.file.abnormal", node_ip)
                LOGGER.logNoPass("Create SSH {} connection catch exception:".format(node_ip) + unicode(exp))
            else:
                PY_JAVA_ENV.get("sshManager").releaseConnection(connection)
            finally:
                node["root_pwd"] = PASSWARD_PROTECTION
                node["ssh_pwd"] = PASSWARD_PROTECTION

        if not err_msg:
            return True, str(nodes_dic), ""
        return False, str(nodes_dic), err_msg
    except Exception as exp:
        LOGGER.logError(str(exp))
        return (cliUtil.RESULT_NOCHECK, str(nodes_dic),
                common.getMsg(LANG, "query.result.abnormal"))


def modify_prompts(ssh):
    cmd = 'PS1=\"\\u:\\h:~$\"'
    cli_ret = ssh.execCmd(cmd)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    return cli_ret_list[1]


def get_connection_by_ip(ip, port, name, pwd, PY_JAVA_ENV):
    java_dev = get_java_dev(ip, port, name, pwd, PY_JAVA_ENV)
    return PY_JAVA_ENV.get("sshManager").getSshConnection(java_dev)


def get_java_dev(ip, port, name, pwd, PY_JAVA_ENV):
    java_dev = DevNode()
    dev = PY_JAVA_ENV.get("devInfo")
    java_dev.setSshForwardList(dev.getSshForwardList())
    java_dev.setSocks5Proxy(dev.getSocks5Proxy())
    java_dev.setPort(port)
    java_dev.setLoginUser(User(name, pwd))
    device_sn = ip + str(time.time())
    java_dev.setDeviceSerialNumber(device_sn)
    java_dev.setIp(ip)
    return java_dev