# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ENVIRONMENT_FLAG = "no such user"
UPDATE_FLAG = "update_flag=1"


def execute(ssh):
    env_flag, cli_ret = check_environment(ssh)
    if env_flag:
        return True, cli_ret, ""
    found_flag, path_cli_ret, dispatch_path = find_dispatch_path(ssh)
    cli_ret = '{}\n{}'.format(cli_ret, path_cli_ret)
    if not found_flag:
        err_msg = common.getMsg(LANG, "dpa.check.dispatch.file.abnormal")
        return False, cli_ret, err_msg
    cmd = "cat {} | grep update_flag".format(dispatch_path)
    temp_cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = temp_cli_ret.encode("utf8").splitlines()
    cli_ret = '{}\n{}'.format(cli_ret, temp_cli_ret)
    if UPDATE_FLAG != cli_ret_list[1]:
        err_msg = common.getMsg(LANG, "dpa.check.upgrade.flag.abnormal",)
        LOGGER.logNoPass("Update_flag=1 is not displayed in the command output.")
        return False, cli_ret, err_msg
    return True, cli_ret, ""


def check_environment(ssh):
    cmd = "id fsadmin"
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    # 回显含有“no such user”，则当前环境是单机，返回检查通过
    if ENVIRONMENT_FLAG in cli_ret:
        return True, cli_ret
    return False, cli_ret


def find_dispatch_path(ssh):
    # 获取dispatch.ini文件路径
    cmd = 'find /opt -name dispatch.ini | grep "/opt/CDMServer/"'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if len(cli_ret_list) != 3:
        LOGGER.logNoPass("The 'dispatch.ini' file is not found.")
        return False, cli_ret, cli_ret_list[1]
    return True, cli_ret, cli_ret_list[1]
