# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import common
import cliUtil


PY_JAVA_ENV = py_java_env
LANG = PY_JAVA_ENV.get("lang")
LOGGER = common.getLogger(PY_LOGGER, __file__)
FILE_PERMISSION = '0755'


def execute(ssh):
    cli_ret = ""
    try:
        flag_bk, cli_ret_bk, err_msg_bk = _bk_dir_check(ssh)
        flag_up, cli_ret_up, err_msg_up = _up_dir_check(ssh)
        cli_ret = '{}\n{}'.format(cli_ret_bk, cli_ret_up)
        if flag_bk and flag_up:
            return True, cli_ret, ""
        return False, cli_ret, err_msg_bk + err_msg_up
    except Exception as exp:
        LOGGER.logError(str(exp))
        return (cliUtil.RESULT_NOCHECK, cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))


def _bk_dir_check(ssh):
    err_msg = ""
    cmd = 'stat /opt/CDMBackupSvr | grep -i "access" | grep -i uid | cut -d "/" -f1 | cut -d "(" -f2'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if len(cli_ret_list) >= 2:
        if "No such file or directory" in cli_ret_list[1]:
            err_msg = common.getMsg(LANG, "dpa.backup.directory.status.abnormal")
            LOGGER.logNoPass("The /opt/CDMBackupSvr directory is not created.")
            return False, cli_ret, err_msg
        if FILE_PERMISSION > cli_ret_list[1]:
            err_msg = common.getMsg(LANG, "dpa.backup.directory.permission.abnormal", cli_ret_list[1])
            LOGGER.logNoPass("The permission on /opt/CDMBackupSvr directory {} is abnormal.".format(cli_ret_list[1]))
            return False, cli_ret, err_msg
    return True, cli_ret, err_msg


def _up_dir_check(ssh):
    err_msg = ""
    cmd = 'stat /opt/CDMUploadSvr  | grep -i "access" | grep -i uid | cut -d "/" -f1 | cut -d "(" -f2'
    cli_ret = cliUtil.getInfoFromHost(ssh, cmd, LOGGER)
    cli_ret_list = cli_ret.encode("utf8").splitlines()
    if len(cli_ret_list) >= 2:
        if "No such file or directory" in cli_ret_list[1]:
            err_msg = common.getMsg(LANG, "dpa.upload.directory.status.abnormal")
            LOGGER.logNoPass("The /opt/CDMUploadSvr directory is not created.")
            return False, cli_ret, err_msg
        if FILE_PERMISSION > cli_ret_list[1]:
            err_msg = common.getMsg(LANG, "dpa.upload.directory.permission.abnormal", cli_ret_list[1])
            LOGGER.logNoPass("The permission on /opt/CDMBackupSvr directory {} is abnormal.".format(cli_ret_list[1]))
            return False, cli_ret, err_msg
    return True, cli_ret, err_msg
