# -*- coding: UTF-8 -*-
import re
import cliUtil
import common
import traceback
import preCheck
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

queryAluaFailures = []
evaluateNotPassDisks = []
cliRets = []
interactiveEndFlags = ['): ', '> ']
ALUA_CONFIGURED_PROPERLY = 1
lineBreak = '\n'
INDEX_INT2 = 2
HOST_CMD_TIMEOUT = 5 * 60
TIMEOUT_FLAG = 'TOOLKIT_SEND_CMD_TIME_OUT'

def execute(ssh):
    '''
    @summary: Solaris自带多路径双活LUN配置检查
    '''  
    try:
        is_upadmin_designated, echos = common.mark_host_upadmin_hyper_metro_luns(py_java_env, ssh, LOGGER)
        cliRets.append(echos)
        if is_upadmin_designated:
            return cliUtil.RESULT_NOSUPPORT, echos, ''  
        #白名单检查
        py_java_env["logger"] = PY_LOGGER
        py_java_env["ssh"] = ssh
        checkFlag, cliRet, errMsg = preCheck.execute(py_java_env)
        cliRets.append(cliRet)
        if checkFlag != True:
            return checkFlag, lineBreak.join(cliRets), errMsg
        continueFlag, checkResult, errorMsg = checkPrerequisite(py_java_env, ssh)
        if continueFlag != True:
            return (checkResult, lineBreak.join(cliRets), errorMsg)       
        arrayWwnDict = getArrayWwns(py_java_env)
        if not arrayWwnDict:
            return (True, lineBreak.join(cliRets), '')       
        executeStatus, diskWwpnDict = queryHuaweiDisk(py_java_env, ssh)
        if not executeStatus:
            return (cliUtil.RESULT_NOCHECK, lineBreak.join(cliRets),
                    common.getMsg(LANG, "hyper.metro.host.disks.query.failure"))          
        if not diskWwpnDict:
            return (False, lineBreak.join(cliRets), common.getMsg(LANG, "hyper.metro.host.query.multipath.not.take.lun"))
        validDiskWwnDict = getValidDiskDict(arrayWwnDict, diskWwpnDict)
        LOGGER.logInfo("***[the validDiskWwnDict diks  is: %s ]***" % validDiskWwnDict)
        
        # 如果没有匹配到双活LUN，报不通过
        if not validDiskWwnDict:
            return (False, lineBreak.join(cliRets), common.getMsg(LANG, "hyper.metro.host.query.multipath.not.take.lun"))
        return handleResultAndErrorMsg(evaluateDiskAlua(validDiskWwnDict, arrayWwnDict, ssh)) 
    except BaseException, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, lineBreak.join(cliRets), common.getMsg(LANG, "query.result.abnormal"))

def updateHostAluaStatus(arrayWwnDict, wwn, status):
    LOGGER.logInfo("***[update the host alua status for the lun wwn: %s is: %s]***" % (wwn, status))
    arrayWwnDict[wwn]['hostAluaStatus'] = status

def getArrayWwns(py_java_env):
    arrayWwnDict = py_java_env.get('allStrgHyprMtrLns')
    return arrayWwnDict
    
def checkPrerequisite(context, ssh):
    continueFlag, checkResult, errorMsg = hasNMP(context, ssh)
    if continueFlag != True:
        return (continueFlag, checkResult, errorMsg)
    return (True, '', '')

def evaluateDiskAlua(diskWwnDict, arrayWwnDict, ssh):
    evaluateResult = True
    for diskWwn in diskWwnDict:
        disk = diskWwnDict.get(diskWwn)
        executeStatus, checkResult = queryAndCheckDiskAlua(disk, py_java_env, ssh)
        evaluateResult = evaluateResult and checkResult            
        if not executeStatus:
            queryAluaFailures.append(disk)
            updateHostAluaStatus(arrayWwnDict, diskWwn, -1)
            LOGGER.logInfo("***[query the disk : %s alua info failure]***" % disk)
            continue
        if not checkResult:
            LOGGER.logInfo("***[the disk: %s is not pass]***" % disk)
            updateHostAluaStatus(arrayWwnDict, diskWwn, -1)
            evaluateNotPassDisks.append(disk)
            continue
        updateHostAluaStatus(arrayWwnDict, diskWwn, 1)
    return evaluateResult 

def getValidDiskDict(arrayWwnDict, diskWwnDict):
    validDiskWwnDict = {}
    for arrayKey in arrayWwnDict.keys():
        lowerKey = arrayKey.lower()
        if lowerKey in diskWwnDict.keys():
            arrayWwnDict[arrayKey]["hostAluaStatus"] = ALUA_CONFIGURED_PROPERLY
            validDiskWwnDict[arrayKey] = diskWwnDict[lowerKey]      
    return validDiskWwnDict
                 
def handleResultAndErrorMsg(evaluateResult):
    '''
    @summary: handle result and construct error message
    ''' 
    errorMsg = ''
    if queryAluaFailures:
        evaluateResult = cliUtil.RESULT_NOCHECK
        errorMsg += common.getMsg(LANG, "hyper.metro.alua.query.failure", ','.join(queryAluaFailures)) 
    if evaluateNotPassDisks:
        evaluateResult = False
        errorMsg += common.getMsg(LANG, "hyper.metro.alua.evaluate.notpass", ','.join(evaluateNotPassDisks))          
    return (evaluateResult, lineBreak.join(cliRets), errorMsg)
             
def queryAndCheckDiskAlua(disk, context, ssh):
    '''
    @summary: query the alua configure information of disk and check the information
    @return: (execute status: True or False, check result: True or False)
    '''
    try:
        cmd = 'mpathadm show lu %s' % disk
        executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.logInfo("***[query the disk : %s alua info failure, the errorMsg is : %s]***" % (disk, errorMsg))
            return False, False
        hasAccessState, checkResult = getDiskAlua(cliRet)
        if not hasAccessState:
            LOGGER.logInfo("***[query and check disk alua, hasAccessState: %s ]***" % hasAccessState)
            return False, checkResult     
        return True, checkResult
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("queryAndCheckDiskAlua ==> " + msg)
        return False, False

def getDiskAlua(cliRet):
    hasAccessState = False
    activeOptimized = False
    activeNotOptimized = False
    for line in cliRet.splitlines():
        stripLine = line.strip().lower()
        if not stripLine.startswith('access state:'):
            continue
        hasAccessState = True
        stateValue = stripLine.split(':')[-1].strip()
        if 'active optimized' == stateValue:
            activeOptimized = True
        if 'active not optimized' == stateValue:
            activeNotOptimized = True
    return hasAccessState, activeOptimized and activeNotOptimized


def queryHuaweiDisk(context, ssh):
    '''
    @summary: query the available huawei disks
    '''
    try:
        diskWwpnDict = {}
        cliRet = executeInteractiveCmd(context, ssh)
        cliRets.append(cliRet)
        if not cliRet or TIMEOUT_FLAG in cliRet:
            LOGGER.logInfo("***[execute queryHuaweiDisk failure, cliRet is: %s]***" % cliRet)
            return False, diskWwpnDict
        diskAndWwnPattern = re.compile(r".*t([/\d|a-f|A-F]{32})d.*",
                                       flags=re.IGNORECASE)
        for line in cliRet.splitlines():
            disk, wwn = getWWNAndDisk(line, diskAndWwnPattern)
            if disk and wwn:
                diskWwpnDict[wwn.lower()] = disk
        LOGGER.logInfo("execute queryHuaweiDisk, diskWwpnDict is : %s" % diskWwpnDict)
        return True, diskWwpnDict
    except:
        msg = traceback.format_exc()
        LOGGER.logError("queryHuaweiDisk ==> " + msg)
        return False, {}


def getWWNAndDisk(line, pattern):
    match = pattern.search(line)
    if not match:
        return '', ''
    return line.strip(), match.group(1)


def executeInteractiveCmd(context, ssh):
    try:
        if not ssh:
            return ''
        executeStatus, cliRet, errorMsg = \
            cliUtil.executeHostCmd(context, ssh, 'mpathadm list LU')
        if executeStatus is not True:
            LOGGER.logInfo(
                "***[query the mpathadm list LU alua info failure, "
                "the errorMsg is : %s]***" % errorMsg)
            return ''
        LOGGER.logInfo(
            "***[execute interactive command, the cliRet is: "
            "%s]***" % cliRet)
        return cliRet
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("executeInteractiveCmd ==> " + msg)
        return ''

def hasNMP(context, ssh):
    try:
        cmd = 'stmsboot -L'
        executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.logInfo("***[execute cmd: %s failure, errorMsg is: %s]***" % (cmd, errorMsg))
            cmd = 'luxadm probe'
            executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
            cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.logInfo("***[execute cmd: %s failure, errorMsg is: %s]***" % (cmd, errorMsg))
            return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.nmp.failure"))
        nmpOpen = 'STMS device name' in cliRet or 'found fibre channel device' in cliRet.lower()
        
        # 未开启自带多路径
        if not nmpOpen:
            return (False, False, common.getMsg(LANG, "hyper.metro.host.query.multipath.not.open"))
        return (True, '', '')
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("hasNMP ==> " + msg)
        return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.nmp.failure"))
