# -*- coding: UTF-8 -*-
import os
import sys
import re
import cliUtil
import common
import traceback
import preCheck
scriptpath = os.path.dirname(os.path.abspath(__file__))
hostCommonPath = os.path.join(scriptpath, "..\\..\\HOST_Common")
sys.path.append(hostCommonPath)
import host_common


LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

queryAluaFailures = []
evaluateNotPassDisks = []
cliRets = []
disk_check_error_msg = ''
interactiveEndFlags = ['): ', '> ']
ALUA_CONFIGURED_PROPERLY = 1
lineBreak = '\n'
INDEX_INT2 = 2
HOST_CMD_TIMEOUT = 5 * 60
TIMEOUT_FLAG = 'TOOLKIT_SEND_CMD_TIME_OUT'


def execute(ssh):
    """
    Solaris自带多路径双活LUN配置检查
    :param ssh:
    :return:
    """
    try:
        is_upadmin_designated, echos = \
            common.mark_host_upadmin_hyper_metro_luns(py_java_env, ssh,
                                                      LOGGER)
        cliRets.append(echos)
        if is_upadmin_designated:
            return cliUtil.RESULT_NOSUPPORT, echos, ''
        # 白名单检查
        py_java_env["logger"] = PY_LOGGER
        py_java_env["ssh"] = ssh
        check_flag, cli_ret, err_msg = \
            preCheck.execute_doradov6(py_java_env)
        cliRets.append(cli_ret)
        if check_flag is not True:
            return check_flag, lineBreak.join(cliRets), err_msg
        continue_flag, check_result, error_msg = \
            check_prerequisite(py_java_env, ssh)
        if continue_flag is not True:
            return check_result, lineBreak.join(cliRets), error_msg
        array_wwn_dict = get_array_wwns(py_java_env)
        if not array_wwn_dict:
            return True, lineBreak.join(cliRets), ''
        execute_status, disk_wwpn_dict = query_huawei_disk(py_java_env, ssh)
        if not execute_status:
            return (cliUtil.RESULT_NOCHECK, lineBreak.join(cliRets),
                    common.getMsg(
                        LANG, "hyper.metro.host.disks.query.failure"))
        if not disk_wwpn_dict:
            return (False, lineBreak.join(cliRets),
                    common.getMsg(
                        LANG,
                        "hyper.metro.host.query.multipath.not.take.lun"))
        valid_disk_wwn_dict = \
            get_valid_disk_dict(array_wwn_dict, disk_wwpn_dict)
        LOGGER.logInfo(
            "***[the validDiskWwnDict diks  is: %s ]***"
            % valid_disk_wwn_dict)
        # 如果没有匹配到双活LUN，报不通过
        if not valid_disk_wwn_dict:
            return (False, lineBreak.join(cliRets),
                    common.getMsg(
                        LANG,
                        "hyper.metro.host.query.multipath.not.take.lun"))
        return handle_result_and_error_msg(
            evaluate_disk_alua(valid_disk_wwn_dict, array_wwn_dict, ssh))
    except BaseException, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, lineBreak.join(cliRets),
                common.getMsg(LANG, "query.result.abnormal"))


def update_host_alua_status(array_wwn_dict, wwn, status):
    LOGGER.logInfo("***[update the host alua status for"
                   " the lun wwn: %s is: %s]***" % (wwn, status))
    array_wwn_dict[wwn]['hostAluaStatus'] = status


def get_array_wwns(py_java_env):
    array_wwn_dict = py_java_env.get('allStrgHyprMtrLns')
    return array_wwn_dict


def check_prerequisite(context, ssh):
    continue_flag, check_result, error_msg = has_nmp(context, ssh)
    if continue_flag is not True:
        return continue_flag, check_result, error_msg
    return True, '', ''


def evaluate_disk_alua(disk_wwn_dict, array_wwn_dict, ssh):
    global cliRets
    evaluate_result = True
    cliRets.append(build_device_access_mode_cli_ret(py_java_env))
    for diskWwn in disk_wwn_dict:
        disk = disk_wwn_dict.get(diskWwn)
        execute_status, check_result = \
            query_and_check_disk_alua(disk, py_java_env, ssh)
        evaluate_result = evaluate_result and check_result
        if not execute_status:
            queryAluaFailures.append(disk)
            update_host_alua_status(array_wwn_dict, diskWwn, -1)
            LOGGER.logInfo("***[query the disk : "
                           "%s alua info failure]***" % disk)
            continue
        if not check_result:
            LOGGER.logInfo("***[the disk: %s is not pass]***" % disk)
            update_host_alua_status(array_wwn_dict, diskWwn, -1)
            evaluateNotPassDisks.append(disk)
            continue
        update_host_alua_status(array_wwn_dict, diskWwn, 1)
    return evaluate_result


def get_valid_disk_dict(array_wwn_dict, disk_wwn_dict):
    valid_disk_wwn_dict = {}
    for array_key in array_wwn_dict.keys():
        lower_key = array_key.lower()
        if lower_key in disk_wwn_dict.keys():
            array_wwn_dict[array_key]["hostAluaStatus"] =\
                ALUA_CONFIGURED_PROPERLY
            valid_disk_wwn_dict[array_key] = disk_wwn_dict[lower_key]
    return valid_disk_wwn_dict


def handle_result_and_error_msg(evaluate_result):
    """
    handle result and construct error message
    :param evaluate_result:
    :return:
    """
    global disk_check_error_msg
    errorMsg = ''
    if queryAluaFailures:
        evaluate_result = cliUtil.RESULT_NOCHECK
        errorMsg += common.getMsg(LANG, "hyper.metro.alua.query.failure",
                                  ','.join(queryAluaFailures))
    if evaluateNotPassDisks:
        evaluate_result = False
        errorMsg += disk_check_error_msg
    return evaluate_result, lineBreak.join(cliRets), errorMsg


def query_and_check_disk_alua(disk, context, ssh):
    """
    query the alua configure information
     of disk and check the information
    :param disk:
    :param context:
    :param ssh:
    :return:
    """
    global disk_check_error_msg
    try:
        cmd = 'mpathadm show lu %s' % disk
        execute_status, cli_ret, error_msg = \
            cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cli_ret)
        if execute_status is not True:
            LOGGER.logInfo("***[query the disk : %s alua info failure, "
                           "the errorMsg is : %s]***" % (disk, error_msg))
            return False, False
        hasAccessState, checkResult, disk_error = get_disk_alua(context,
                                                                cli_ret)
        if not checkResult:
            disk_check_error_msg += \
                common.getMsg(LANG, "hyper.metro.host.disk.check.error",
                              (disk, disk_error))
        if not hasAccessState:
            LOGGER.logInfo(
                "***[query and check disk alua, hasAccessState: %s ]***"
                % hasAccessState)
            return False, checkResult
        return True, checkResult
    except Exception as ex:
        msg = traceback.format_exc()
        LOGGER.logError("queryAndCheckDiskAlua ==> " + str(msg) + str(ex))
        return False, False


def get_disk_alua(context, cli_ret):
    has_access_state = False
    active_optimized = False
    active_not_optimized = False
    for line in cli_ret.splitlines():
        strip_line = line.strip().lower()
        if not strip_line.startswith('access state:'):
            continue
        has_access_state = True
        state_value = strip_line.split(':')[-1].strip()
        if 'active optimized' == state_value:
            active_optimized = True
        if 'active not optimized' == state_value:
            active_not_optimized = True
    if not has_access_state:
        return False, False, common.getMsg(
            LANG, "hyper.metro.host.access.state.error")
    else:
        sn_access_mode_dict = host_common.get_access_mode(context)
        sn_hyper_path_dict = host_common.get_hyper_path_opt(context)
        if active_optimized and not active_not_optimized:
            check_result, check_error = active_optimized_access_state_check(
                sn_access_mode_dict,
                sn_hyper_path_dict)
            return True, check_result, check_error

        elif active_optimized and active_not_optimized:
            check_result, check_error = both_access_state_check(
                sn_access_mode_dict,
                sn_hyper_path_dict)
            return True, check_result, check_error
    return has_access_state, False, common.getMsg(
        LANG, "hyper.metro.host.access.state.error")


def active_optimized_access_state_check(sn_access_mode_dict,
                                        sn_hyper_path_dict):
    """
    active_optimized时访问机制检查
    :param disk:
    :param sn_access_mode_dict:
    :param sn_hyper_path_dict:
    :return:
    """
    check_flag = True
    error_msg = ''
    for sn, access_mode in sn_access_mode_dict.items():
        hypermetro_path = sn_hyper_path_dict.get(sn, '')
        if access_mode.lower() == 'asymmetric' and \
                hypermetro_path.lower() == 'yes':
            continue
        else:
            check_flag = False
            error_msg += \
                common.getMsg(
                    LANG,
                    "hyper.metro.host.activeoptimized.check.error",
                    (sn, access_mode, hypermetro_path))
    return check_flag, error_msg


def both_access_state_check(sn_access_mode_dict, sn_hyper_path_dict):
    """
    同时满足active_optimized和active_not_optimized访问机制检查
    :param disk:
    :param sn_access_mode_dict:
    :param sn_hyper_path_dict:
    :return:
    """
    check_flag = True
    hypermetro_paths = []
    check_error = ''
    for sn, hypermetro_path in sn_hyper_path_dict.items():
        hypermetro_paths.append(hypermetro_path)
    hypermetro_paths = list(set(hypermetro_paths))
    if len(hypermetro_paths) <= 1:
        check_flag = False
        check_error += \
            common.getMsg(LANG, "hyper.metro.host.activeoptimized."
                                "activenotoptimized.same.path.config")
    for sn, access_mode in sn_access_mode_dict.items():
        if access_mode.lower() != 'asymmetric':
            check_flag = False
            check_error += \
                common.getMsg(
                    LANG, "hyper.metro.host.activeoptimized."
                          "activenotoptimized.not.asymmetric",
                          sn)
    return check_flag, check_error


def build_device_access_mode_cli_ret(context):
    """
    获取阵列侧主机访问机制回显
    :param context:
    :return:
    """
    cli_rets = ''
    sn_cli_ret_dict = host_common.get_host_access_cli_ret(context)
    for sn, cli_ret in sn_cli_ret_dict.items():
        cli_rets += 'HyperMetro Device SN[%s]:\r\n%s\r\n' % (sn, cli_ret)
    return cli_rets


def query_huawei_disk(context, ssh):
    '''
    @summary: query the available huawei disks
    '''
    try:
        diskWwpnDict = {}
        cliRet = execute_interactive_cmd(context, ssh)
        cliRets.append(cliRet)
        if not cliRet or TIMEOUT_FLAG in cliRet:
            LOGGER.logInfo("***[execute queryHuaweiDisk"
                           " failure, cliRet is: %s]***" % cliRet)
            return False, diskWwpnDict
        diskAndWwnPattern = re.compile(r".*t([/\d|a-f|A-F]{32})d.*",
                                       flags=re.IGNORECASE)
        for line in cliRet.splitlines():
            disk, wwn = get_wwn_and_disk(line, diskAndWwnPattern)
            if disk and wwn:
                diskWwpnDict[wwn.lower()] = disk
        LOGGER.logInfo("execute queryHuaweiDisk, diskWwpnDict is : %s"
                       % diskWwpnDict)
        return True, diskWwpnDict
    except Exception as ex:
        msg = traceback.format_exc()
        LOGGER.logError("queryHuaweiDisk ==> " + str(msg) + str(ex))
        return False, {}


def get_wwn_and_disk(line, pattern):
    match = pattern.search(line)
    if not match:
        return '', ''
    return line.strip(), match.group(1)


def execute_interactive_cmd(context, ssh):
    try:
        if not ssh:
            return ''
        execute_status, cli_ret, error_msg = \
            cliUtil.executeHostCmd(context, ssh, 'mpathadm list LU')
        if execute_status is not True:
            LOGGER.logInfo(
                "***[query the mpathadm list LU alua info failure, "
                "the errorMsg is : %s]***" % error_msg)
            return ''
        LOGGER.logInfo(
            "***[execute interactive command, the cliRet is: "
            "%s]***" % cli_ret)
        return cli_ret
    except Exception as ex:
        msg = traceback.format_exc()
        LOGGER.logError("executeInteractiveCmd ==> " + str(msg) + str(ex))
        return ''


def has_nmp(context, ssh):
    try:
        cmd = 'stmsboot -L'
        execute_status, cli_ret, error_msg = cliUtil.executeHostCmd(context,
                                                                    ssh,
                                                                    cmd)
        cliRets.append(cli_ret)
        if execute_status is not True:
            LOGGER.logInfo(
                "***[execute cmd: %s failure, errorMsg is: %s]***" % (
                    cmd, error_msg))
            cmd = 'luxadm probe'
            execute_status, cli_ret, error_msg = cliUtil.executeHostCmd(
                context, ssh, cmd)
            cliRets.append(cli_ret)
        if execute_status is not True:
            LOGGER.logInfo(
                "***[execute cmd: %s failure, errorMsg is: %s]***" % (
                    cmd, error_msg))
            return (False, cliUtil.RESULT_NOCHECK,
                    common.getMsg(LANG,
                                  "hyper.metro.host.query.nmp.failure"))
        nmp_open = 'STMS device name' in cli_ret \
                   or 'found fibre channel device' in cli_ret.lower()
        # 未开启自带多路径
        if not nmp_open:
            return (False,
                    False, common.getMsg(
                        LANG, "hyper.metro.host.query.multipath.not.open"))
        return True, '', ''
    except Exception as ex:
        msg = traceback.format_exc()
        LOGGER.logError("hasNMP ==> " + str(msg) + str(ex))
        return (False, cliUtil.RESULT_NOCHECK,
                common.getMsg(LANG, "hyper.metro.host.query.nmp.failure"))
