# -*- coding: UTF-8 -*-
import cliResource

HOST_CMD_TIMEOUT = 5 * 60

RESULT_NOCHECK = "NOCHECK"
RESULT_NOSUPPORT = "NOSUPPORT"
RESULT_WARNING = "WARNING"

def getMsg(lang, msg, args="", resource=cliResource.MESSAGES_DICT):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @param resource: 消息字典
    @return: 经过国际化处理后的消息
    '''
    errMsg = "\n--"

    try:
        if not resource.has_key(msg):
            return errMsg

        localeDict = resource.get(msg)
        if not localeDict.has_key(lang):
            return errMsg

        localeMsg = localeDict.get(lang)
        if "%s" in localeMsg or "%i" in localeMsg:
            return localeMsg % args
        else:
            return localeMsg

    except:
        return errMsg

def executeHostCmd(context, ssh, command, timeout=HOST_CMD_TIMEOUT):
    '''
    @summary:获取单一命令执行结果
    @param ssh: ssh 
    @param command : shell 命令
    @return: (command execute whether or not success, command result, error message) 
    '''  
    excuteSuccess = False
    errMsg = ''
    LANG = context.get("lang")
    cliRet = ssh.execCmdNoLogTimout(command, timeout)
    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x : x in cliRet.lower(), regx):
        if "en" == LANG:
            errMsg += command + ":\texecute failed\r\n"
        else:
            errMsg += command + u":\t执行失败\r\n"
    else:
        if "en" == LANG:
            errMsg += command + ":\texecute success\r\n"
        else:
            errMsg += command + u":\t执行成功\r\n" 
        excuteSuccess = True
    return excuteSuccess, cliRet, errMsg
