# -*- coding: UTF-8 -*-
import re
import traceback
import cliUtil
import common
import preCheck
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

queryAluaFailures = []
evaluateNotPassDisks = []
cliRets = []

lineBreak = '\n'
HOST_CMD_TIMEOUT = 5 * 60
VMWARE_VERSION_5_0 = 5.0
VMWARE_VERSION_5_1 = 5.1
VMWARE_VERSION_5_5 = 5.5
VMWARE_VERSION_6_0 = 6.0
VMWARE_VERSION_6_7 = 6.7
VMWARE_VERSION_6_LIST = [6.0, 6.5, 6.7]

INDEX_INT2 = 2
VMWARE_VERSION = 'VMware ESXi %s %s'
ALUA_CONFIGURED_PROPERLY = 1
MANUAL_DETECTION_WARN = False
def execute(ssh):
    '''
    @summary: Vmware自带多路径双活LUN配置检查
    '''  
    try:
        exec_result, is_upadmin_designated, echos = \
            common.mark_host_upadmin_hyper_metro_luns(py_java_env,
                                                      ssh, LOGGER)
        cliRets.append(echos)
        if is_upadmin_designated:
            return cliUtil.RESULT_NOSUPPORT, echos, ''     
        #白名单检查
        py_java_env["logger"] = PY_LOGGER
        py_java_env["ssh"] = ssh
        checkFlag, cliRet, errMsg = preCheck.execute(py_java_env)
        cliRets.append(cliRet)
        if checkFlag != True:
            return checkFlag, lineBreak.join(cliRets), errMsg
        
        # 步骤3 检查是否NMP启用了。
        continueFlag, checkResult, errorMsg = hasNMP(py_java_env, ssh)
        if continueFlag != True:
            return (checkResult, lineBreak.join(cliRets), errorMsg)
        
        # 步骤4 查询主机上的双活LUN
        executeStatus, diskWwpnDict = queryHuaweiDisk(py_java_env, ssh)
        if not executeStatus:
            return (cliUtil.RESULT_NOCHECK, lineBreak.join(cliRets), common.getMsg(LANG, "hyper.metro.host.disks.query.failure"))          
        
        if not diskWwpnDict:
            return (False, lineBreak.join(cliRets), common.getMsg(LANG, "hyper.metro.host.query.multipath.not.take.lun"))
        
        # 获取阵列侧映射了的双活LUN
        arrayWwnDict = getArrayWwns(py_java_env)
        if not arrayWwnDict:
            return (True, lineBreak.join(cliRets), '')
        
        # 检查主机侧的lun wwn是否在存储双活LUN集合中
        validDiskWwnDict = getValidDiskDict(arrayWwnDict, diskWwpnDict)
        LOGGER.logInfo("***[the validDiskWwnDict= %s ]***" % validDiskWwnDict)
        
        # 如果未查询到和阵列匹配的双活LUN，报不通过
        if not validDiskWwnDict:
            return (False, lineBreak.join(cliRets), common.getMsg(LANG, "hyper.metro.host.query.multipath.not.take.lun"))
        
        
        continueFlag, checkResult, errorMsg = checkPrerequisite(py_java_env, ssh)
        if continueFlag != True:
            return (checkResult, lineBreak.join(cliRets), errorMsg)
        
        LOGGER.logInfo("***[query diskWwpnDict= %s ]***" % diskWwpnDict)
        
        return handleResultAndErrorMsg(evaluateDiskAlua(validDiskWwnDict, arrayWwnDict, ssh)) 
    except BaseException, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, lineBreak.join(cliRets), common.getMsg(LANG, "query.result.abnormal"))

def updateHostAluaStatus(arrayWwnDict, wwn, status):
    LOGGER.logInfo("***[update the host alua status for the lun wwn: %s is: %s]***" % (wwn, status))
    arrayWwnDict[wwn]['hostAluaStatus'] = status

def getArrayWwns(py_java_env):
    arrayWwnDict = py_java_env.get('allStrgHyprMtrLns')
    return arrayWwnDict
    
def checkPrerequisite(context, ssh):
    # 步骤5 检查源生多路径信息
    continueFlag, checkResult, errorMsg = checkSourceNmp(context, ssh)
    if continueFlag != True:
        return (continueFlag, checkResult, errorMsg)
    
    # 步骤6 检查settings
    continueFlag, checkResult, errorMsg = checkVmwareSetting(context, ssh)
    if continueFlag != True:
        return (continueFlag, checkResult, errorMsg)
    return (True, '', '')

def checkSourceNmp(context, ssh):
    try:
        cmd = "esxcli storage nmp satp rule list | grep -i HUAWEI"
        executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.logInfo("***[execute cmd: %s failure, errorMsg is: %s]***" % (cmd, errorMsg))
            return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.source.nmp.failure"))
        
        for line in cliRet.splitlines():
            lowerLine = line.lower()
            if 'vmw_satp_alua' in lowerLine and 'huawei' in lowerLine:
                return (True, '', '')      
        return (False, False, common.getMsg(LANG, "hyper.metro.host.query.source.nmp.notpass"))
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("hasNMP ==> " + msg)
        return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.source.nmp.failure"))

def checkVmwareSetting(context, ssh):
    executeStatus, versionNum, versionType = getOsVersion(context, ssh)
    LOGGER.logInfo("***[version number= %s, version type = %s]***" % (versionNum, versionType))
    if executeStatus != True:
        return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.os.query.failure"))
    elif versionNum == VMWARE_VERSION_5_0 or versionNum == VMWARE_VERSION_5_1:
        return checkVmware5(context, ssh)
    elif versionNum == VMWARE_VERSION_5_5 or (
            versionNum in VMWARE_VERSION_6_LIST and
            ((versionNum == VMWARE_VERSION_6_7 and
              versionType <= "Update 3"
                             ""
                             "") or
             versionNum != VMWARE_VERSION_6_7)):
        return checkVmwareFrom55(versionNum, context, ssh, versionType)
    else:
        return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.vmare.os.6.5.method", VMWARE_VERSION % (versionNum, versionType)))


def checkVmwareFrom55(version_num, context, ssh, version_type):
    '''
    @summary: version include 5.5 5.5U1 5.5U3,6.0,6.5,6.7
    '''
    global MANUAL_DETECTION_WARN
    try:
        terminateCmd = "esxcli system settings kernel list -o 'terminateVMOnPDL'"
        executeStatus, terminateCmdRet, errorMsg = cliUtil.executeHostCmd(context, ssh, terminateCmd)
        terminate_ret = common.deal_cli_ret_special_long_split_flag(
            terminateCmdRet
        )
        cliRets.append(terminate_ret)
        if executeStatus != True:
            LOGGER.logInfo("***[execute cmd: %s failure, errorMsg is: %s]***" % (terminateCmd, errorMsg))
            return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.vmware.config.failure"))

        autoremoveCmd = "esxcli system settings advanced list -o '/Disk/AutoremoveOnPDL'"
        executeStatus, autoremoveCmdRet, errorMsg = cliUtil.executeHostCmd(context, ssh, autoremoveCmd)
        cliRets.append(autoremoveCmdRet)
        if executeStatus != True:
            LOGGER.logInfo("***[execute cmd: %s failure, errorMsg is: %s]***" % (autoremoveCmd, errorMsg))
            return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.vmware.config.failure"))

        #解析terminate信息
        settingDicts = cliUtil.getHorizontalCliRet(terminateCmdRet)
        for setting in settingDicts:
            configured = setting.get('Configured', '')
            runtime = setting.get('Runtime', '')
            break
        #解析autoremove信息
        lineList = autoremoveCmdRet.splitlines()
        for line in lineList:
            if "Int Value:" in line:
                fields = line.split(":")
                int_value = fields[-1].strip()
                break

        if version_num == VMWARE_VERSION_5_5 \
            or (version_num == VMWARE_VERSION_6_0
                and version_type <= "Update 1"):
            flag = common.check_config_value_before_6U1(configured, runtime,
                                                        int_value)
            err_key = "hyper.metro.host.query.vmware." \
                      "config.notpass.configRunTime"
            return flag, flag, common.getMsg(LANG, err_key,
                                             (configured, runtime))

        if version_num in VMWARE_VERSION_6_LIST:
            MANUAL_DETECTION_WARN = True
            flag = common.check_config_value_after_6U1(configured, runtime,
                                                       int_value)
            err_key = "hyper.metro.host.query.vmware." \
                      "config.notpass.configRunTime"
            return flag, flag, common.getMsg(LANG, err_key,
                                             (configured, runtime))

        return (True, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.vmware.config.failure"))
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("checkVmwareFrom55To6u3 ==> " + msg)
        return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.vmware.config.failure"))


def checkVmware5(context, ssh):
    '''
    @summary: include 5.0 5.1
    '''
    try:
        cmd = "cat /etc/vmware/settings"
        executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.logInfo("***[execute cmd: %s failure, errorMsg is: %s]***" % (cmd, errorMsg))
            return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.vmware.config.failure"))
        for line in cliRet.splitlines():
            if not 'Disk.terminateVMOnPDLDefault' in line:
                continue
            settings = line.split('=')
            if settings[-1].strip().lower() == 'true':
                return (True, '', '')
            else:
                return (False, False, common.getMsg(LANG, "hyper.metro.host.query.vmware.config.notpass"))        
        return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.vmware.config.failure"))    
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("checkVmware5 ==> " + msg)
        return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.vmware.config.failure"))
        
def evaluateDiskAlua(diskWwnDict, arrayWwnDict, ssh):
    evaluateResult = True
    for diskWwn in diskWwnDict:
        disk = diskWwnDict.get(diskWwn)
        executeStatus, checkResult = queryAndCheckDiskAlua(disk, py_java_env, ssh)
        evaluateResult = evaluateResult and checkResult            
        if not executeStatus:
            queryAluaFailures.append(disk)
            updateHostAluaStatus(arrayWwnDict, diskWwn, -1)
            LOGGER.logInfo("***[query the disk : %s alua info failure]***" % disk)
            continue
        if not checkResult:
            LOGGER.logInfo("***[the disk: %s is not pass]***" % disk)
            updateHostAluaStatus(arrayWwnDict, diskWwn, -1)
            evaluateNotPassDisks.append(disk)
            continue
        updateHostAluaStatus(arrayWwnDict, diskWwn, 1)
    return evaluateResult 

def getValidDiskDict(arrayWwnDict, diskWwnDict):     
    validDiskWwnDict = {}
    for arrayKey in arrayWwnDict.keys():
        lowerKey = arrayKey.lower()
        if lowerKey in diskWwnDict.keys():
            arrayWwnDict[arrayKey]["hostAluaStatus"] = ALUA_CONFIGURED_PROPERLY
            validDiskWwnDict[arrayKey] = diskWwnDict[lowerKey]      
    return validDiskWwnDict
                 
def handleResultAndErrorMsg(evaluateResult):
    '''
    @summary: handle result and construct error message
    ''' 
    errorMsg = ''
    if queryAluaFailures:
        evaluateResult = cliUtil.RESULT_NOCHECK
        errorMsg += common.getMsg(LANG, "hyper.metro.alua.query.failure", ','.join(queryAluaFailures)) 
    if evaluateNotPassDisks:
        evaluateResult = False
        errorMsg += common.getMsg(LANG, "hyper.metro.alua.evaluate.notpass", ','.join(evaluateNotPassDisks))          
    if evaluateResult is True and MANUAL_DETECTION_WARN:
        evaluateResult = cliUtil.RESULT_WARNING
        errorMsg += common.getMsg(LANG, "PDL.config.ui.not.check.v3")
    return (evaluateResult, lineBreak.join(cliRets), errorMsg)


def queryAndCheckDiskAlua(disk, context, ssh):
    '''
    @summary: query the alua configure information of disk and check the information
    @return: (execute status: True or False, check result: True or False)
    '''
    try:          
        cmd = 'esxcli storage nmp device list -d=%s' % disk
        executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.logInfo("***[query the disk : %s alua info failure, the errorMsg is : %s]***" % (disk, errorMsg))
            return False, False
        hasKeyWord, checkResult = getDiskAlua(cliRet)
        if not hasKeyWord:
            LOGGER.logInfo("***[query and check disk alua, hasAccessState: %s ]***" % hasKeyWord)
            return False, checkResult     
        return True, checkResult
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("queryAndCheckDiskAlua ==> " + msg)
        return False, False

def getDiskAlua(cliRet):
    hasStorageArrayType = False
    hasPathSelectionPolicy = False
    vmwSatpAlua = False
    vmwPspRr = False
    for line in cliRet.splitlines():
        stripLine = line.strip().lower()
        splitLines = stripLine.split(':')
        if 'storage array type:' in stripLine:
            hasStorageArrayType = True
            if splitLines[-1].strip() == 'vmw_satp_alua':
                vmwSatpAlua = True    
        elif 'path selection policy:' in stripLine:
            hasPathSelectionPolicy = True
            if splitLines[-1].strip() == 'vmw_psp_rr':
                vmwPspRr = True
    return hasStorageArrayType and hasPathSelectionPolicy, vmwSatpAlua and vmwPspRr
        
def queryHuaweiDisk(context, ssh):
    '''
    @summary: query the available huawei disks
    '''
    diskWwpnDict = {}
    cmd = "esxcli storage nmp device list"
    executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
    cliRets.append(cliRet)
    if not executeStatus:
        LOGGER.logInfo("***[execute queryHuaweiDisk failure, errorMsg is: %s]***" % errorMsg)
        return False, diskWwpnDict
    diskAndWwnPattern = re.compile(".*\((naa.([\d|a-f]{32}))\).*", flags=re.IGNORECASE)
    for line in cliRet.splitlines():
        disk, wwn = getWWNAndDisk(line, diskAndWwnPattern)
        if disk and wwn:
            diskWwpnDict[wwn.lower()] = disk
    LOGGER.logInfo("execute queryHuaweiDisk, diskWwpnDict is : %s" % diskWwpnDict)
    return True, diskWwpnDict

def getWWNAndDisk(line, pattern):
    match = pattern.search(line)
    if not match:
        return '', ''
    return match.group(1), match.group(INDEX_INT2)

def getOsVersion(context, ssh):
    cmd = 'vmware -l'
    executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
    cliRets.append(cliRet)
    if executeStatus != True:
        LOGGER.logInfo("***[execute getOsVersion errorMsg is : %s]***" % errorMsg)
        return (False, '', '')
    patternVersion = re.compile('vmware\sesxi\s(\d\.\d)\.\d\s(.*)', flags=re.IGNORECASE)
    for line in cliRet.splitlines():
        match = patternVersion.search(line.strip())
        if match:
            return (True, float(match.group(1)), match.group(INDEX_INT2))
    return (False, '', '')

def hasNMP(context, ssh):
    '''
    @summary:判断是否带有自带多路径
    @param context : 上下文
    '''
    nmpOpen = False
    regx = ".*\((.+)\).*"
    try:
        cmd = "esxcli storage core device list"
        executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.logInfo("***[execute cmd: %s failure, errorMsg is: %s]***" % (cmd, errorMsg))
            return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.nmp.failure"))
        currentPath = False
        currentPathName = ''
        hasMultipathPlugin = False
        hasTransport = False
        for line in cliRet.splitlines():
            line = line.strip()
            if line.lower().startswith('display name'):
                m = re.match(regx, line)
                if m:
                    currentPathName = m.group(1)
                    LOGGER.logInfo("***[currentPathName= " + currentPathName + "]***")
                    currentPath = True
                else:
                    currentPath = False
            elif line.lower().startswith('multipath plugin:'):
                hasMultipathPlugin = True
                if  line.lower().split(':')[-1].strip() == 'nmp' and currentPath:
                    hasTransport, nmpOpen = checkNmpPathTransport(currentPathName, context, ssh)
                    LOGGER.logInfo("***[currentPathName= %s, hasTransport= %s, flag= %s]***" % (currentPathName, hasTransport, nmpOpen))
                    if nmpOpen:
                        break
                    else:
                        currentPath = False                         
        if not (hasMultipathPlugin and hasTransport):
            return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.nmp.failure"))
        
        # 如果未开启自带多路径
        if not nmpOpen:
            return (False, False, common.getMsg(LANG, "hyper.metro.host.query.multipath.not.open"))     
        return (True, '', '')
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("hasNMP ==> " + msg)
        return (False, cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "hyper.metro.host.query.nmp.failure"))

def checkNmpPathTransport(pathName, context, ssh):
    '''
    @summary: check nmp path transport'value is 'fc' or 'iscsi'
    @param pathName: nmp path name
    @param context: context provide some execute params  
    '''
    flag = False
    hasTransport = False
    cmd = 'esxcli storage core path list -d %s' % pathName
    try:
        executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context, ssh, cmd)
        cliRets.append(cliRet)
        if executeStatus != True:
            LOGGER.logInfo("***[execute cmd: %s failure, errorMsg is: %s]***" % (cmd, errorMsg))
            return hasTransport, flag
        for line in cliRet.splitlines():
            item = line.strip().lower()
            if not item.startswith('transport:'):
                continue
            hasTransport = True
            transportValue = item.split(':')[-1].strip()
            if 'fc' == transportValue or 'iscsi' == transportValue or 'fcoe' == transportValue:
                flag = True
                break        
        return hasTransport, flag
    except:
        msg = traceback.format_exc() 
        LOGGER.logError("checkNmpPathTransport ==> " + msg)
        return hasTransport, flag 
