# -*- coding: UTF-8 -*-
import os
import sys
import re
import traceback
import cliUtil
import common
import preCheck
scriptpath = os.path.dirname(os.path.abspath(__file__))
hostCommonPath = os.path.join(scriptpath, "..\\..\\HOST_Common")
sys.path.append(hostCommonPath)
import host_common


LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

HOST_CMD_TIMEOUT = 5 * 60
VMWARE_VERSION_5_0 = 5.0
VMWARE_VERSION_5_1 = 5.1
VMWARE_VERSION_5_5 = 5.5
VMWARE_VERSION_6_0 = 6.0
VMWARE_VERSION_6_7 = 6.7
VMWARE_VERSION_6_LIST = [6.0, 6.5, 6.7]
INDEX_INT2 = 2
ASYMMETRIC_ULTRAPATH_KEY_LIST = ['VMW_SATP_ALUA', 'VMW_PSP_RR', 'HUAWEI',
                                 'XSG1']
BALANCED_ULTRAPATH_KEY_LIST = ['VMW_SATP_DEFAULT_AA', 'VMW_PSP_RR',
                               'HUAWEI', 'XSG1']
VMWARE_VERSION = 'VMware ESXi %s %s'
ALUA_CONFIGURED_PROPERLY = 1
query_alua_failures = []
evaluate_not_pass_disks = []
cli_rets = []
manual_detection_warn = False
line_break = '\n'
disk_alua_error = ''

def execute(ssh):
    '''
    @summary: Vmware自带多路径双活LUN配置检查
    '''
    global cli_rets
    try:
        exec_result, is_upadmin_designated, echos = \
            common.mark_host_upadmin_hyper_metro_luns(py_java_env,
                                                      ssh, LOGGER)
        cli_rets.append(echos)
        if is_upadmin_designated:
            return cliUtil.RESULT_NOSUPPORT, echos, ''
        # 白名单检查
        py_java_env["logger"] = PY_LOGGER
        py_java_env["ssh"] = ssh
        check_flag, cli_ret, err_msg = \
            preCheck.execute_doradov6(py_java_env)
        cli_rets.append(cli_ret)
        if check_flag is not True:
            return check_flag, line_break.join(cli_rets), err_msg

        # 步骤3 检查是否NMP启用了。
        continue_flag, check_result, error_msg = has_nmp(py_java_env, ssh)
        if continue_flag is not True:
            return check_result, line_break.join(cli_rets), error_msg

        # 步骤4 查询主机上的双活LUN
        execute_status, disk_wwpn_dict = query_huawei_disk(py_java_env, ssh)
        if not execute_status:
            return (cliUtil.RESULT_NOCHECK, line_break.join(cli_rets),
                    common.getMsg(LANG,
                                  "hyper.metro.host.disks.query.failure"))

        if not disk_wwpn_dict:
            return (False, line_break.join(cli_rets),
                    common.
                    getMsg(LANG,
                           "hyper.metro.host.query.multipath.not.take.lun"))

        # 获取阵列侧映射了的双活LUN
        array_wwn_dict = get_array_wwns(py_java_env)
        if not array_wwn_dict:
            return True, line_break.join(cli_rets), ''

        # 检查主机侧的lun wwn是否在存储双活LUN集合中
        valid_disk_wwn_dict = get_valid_disk_dict(array_wwn_dict,
                                                  disk_wwpn_dict)
        LOGGER.logInfo(
            "***[the array_wwn_dict= %s \r\n disk_wwpn_dict = %s]***" % (
                        array_wwn_dict, disk_wwpn_dict))
        LOGGER.logInfo(
            "***[the validDiskWwnDict= %s ]***" % valid_disk_wwn_dict)

        # 如果未查询到和阵列匹配的双活LUN，报不通过
        if not valid_disk_wwn_dict:
            return (False, line_break.join(cli_rets),
                    common.
                    getMsg(LANG,
                           "hyper.metro.host.query.multipath.not.take.lun"))

        continue_flag, check_result, error_msg = check_prerequisite(
            py_java_env, ssh)
        if continue_flag is not True:
            return check_result, line_break.join(cli_rets), error_msg

        LOGGER.logInfo("***[query diskWwpnDict= %s ]***" % disk_wwpn_dict)

        return handle_result_and_error_msg(
            evaluate_disk_alua(valid_disk_wwn_dict, array_wwn_dict, ssh,
                               py_java_env))
    except BaseException, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, line_break.join(cli_rets),
                common.getMsg(LANG, "query.result.abnormal"))


def update_host_alua_status(array_wwn_dict, wwn, status):
    LOGGER.logInfo(
        "***[update the host alua status for the lun wwn: %s is: %s]***" % (
            wwn, status))
    array_wwn_dict[wwn]['hostAluaStatus'] = status


def get_array_wwns(py_java_env):
    array_wwn_dict = py_java_env.get('allStrgHyprMtrLns')
    return array_wwn_dict


def check_prerequisite(context, ssh):
    # 检查源生多路径信息
    continue_flag, check_result, error_msg = check_source_nmp(context, ssh)
    if continue_flag is not True:
        return continue_flag, check_result, error_msg

    # 步骤6 检查settings
    continue_flag, check_result, error_msg = check_vmware_setting(context,
                                                                  ssh)
    if continue_flag is not True:
        return continue_flag, check_result, error_msg
    return True, '', ''


def check_source_nmp(context, ssh):
    global cli_rets
    try:
        # 获取双活阵列访问模式
        cli_rets.append(build_device_access_mode_cli_ret(context))
        cmd = "esxcli storage nmp satp rule list | grep -i HUAWEI"
        execute_status, cli_ret, error_msg = \
            cliUtil.executeHostCmd(context, ssh, cmd)
        cli_rets.append(cli_ret)
        if execute_status is not True:
            LOGGER.logInfo(
                "***[execute cmd: %s failure, errorMsg is: %s]***" % (
                    cmd, error_msg))
            return (False,
                    cliUtil.RESULT_NOCHECK,
                    common.getMsg(
                        LANG, "hyper.metro.host.query.source.nmp.failure"))
        check_flag, check_error = get_hyper_device_access_mode(context,
                                                               cli_ret)
        return check_flag, check_flag, check_error
    except Exception as exception:
        msg = traceback.format_exc()
        LOGGER.logError("hasNMP ==> " + msg + exception)
        return (False, cliUtil.RESULT_NOCHECK,
                common.getMsg(
                    LANG, "hyper.metro.host.query.source.nmp.failure"))


def get_hyper_device_access_mode(context, ultrapath_cli_ret):
    """
    轮询双活阵列，检查阵列访问模式和多路径信息是否匹配
    :param context:
    :param ultrapath_cli_ret:
    :return:
    """
    sn_access_dict = host_common.get_access_mode(context)
    if not bool(sn_access_dict):
        return False, common.getMsg(
                       LANG, "hyper.metro.6.0.ultrapath.host.no.accessmode")
    check_flag = True
    error_msg = ''
    for dev_sn, access_mode in sn_access_dict.items():
        if access_mode != "Asymmetric" and access_mode != "Balanced":
            check_flag = False
            error_msg += common.getMsg(
                LANG, "hyper.metro.6.0.ultrapath.host.accessmode.error",
                dev_sn)
            continue
        if access_mode == "Asymmetric" and not check_ultrapath_cli_ret(
                ultrapath_cli_ret, ASYMMETRIC_ULTRAPATH_KEY_LIST):
            check_flag = False
            error_msg += common.getMsg(
                       LANG, "hyper.metro.6.0.ultrapath.config.error", (
                        dev_sn, access_mode,
                        str(ASYMMETRIC_ULTRAPATH_KEY_LIST)))
            continue
        if access_mode == "Balanced" and not check_ultrapath_cli_ret(
                ultrapath_cli_ret, BALANCED_ULTRAPATH_KEY_LIST):
            check_flag = False
            error_msg += common.getMsg(
                       LANG, "hyper.metro.6.0.ultrapath.config.error", (
                        dev_sn, access_mode,
                        str(BALANCED_ULTRAPATH_KEY_LIST)))
            continue
    return check_flag, error_msg


def check_ultrapath_cli_ret(ultrapath_cli_ret, check_item_list):
    """
    检查ultrapath详情回显中是否包含所有指定关键字
    :param ultrapath_cli_ret:
    :param check_item_list:
    :return:
    """
    if not bool(check_item_list):
        return True
    count = 0
    for check_key in check_item_list:
        if check_key.lower() in ultrapath_cli_ret.lower():
            count += 1
    if count == len(check_item_list):
        return True
    return False


def check_vmware_setting(context, ssh):
    execute_status, version_num, version_type = get_os_version(context, ssh)
    LOGGER.logInfo("***[version number= %s, version type = %s]***" % (
        version_num, version_type))
    if execute_status is not True:
        return (False, cliUtil.RESULT_NOCHECK,
                common.getMsg(LANG, "hyper.metro.os.query.failure"))
    elif version_num == VMWARE_VERSION_5_0 or \
            version_num == VMWARE_VERSION_5_1:
        return check_vmware5(context, ssh)
    elif version_num == VMWARE_VERSION_5_5 or \
            (version_num in VMWARE_VERSION_6_LIST and
             ((version_num == VMWARE_VERSION_6_7 and
               version_type <= "Update 3") or
              version_num != VMWARE_VERSION_6_7)):
        return check_vmware_from55(context, ssh, version_num, version_type)
    else:
        return (False, cliUtil.RESULT_NOCHECK,
                common.getMsg(LANG, "hyper.metro.vmare.os"
                                    ".6.5.method.doradov6",
                              VMWARE_VERSION % (version_num, version_type)))


def check_vmware_from55(context, ssh, version_num, version_type):
    '''
    @summary: version include 5.5 5.5U1 5.5U3,6.0,6.5,6.7
    '''
    global manual_detection_warn
    try:
        terminate_cmd = \
            "esxcli system settings kernel list -o 'terminateVMOnPDL'"
        execute_status, terminate_cmd_ret, error_msg = \
            cliUtil.executeHostCmd(context, ssh, terminate_cmd)
        terminate_ret = common.deal_cli_ret_special_long_split_flag(
            terminate_cmd_ret
        )
        cli_rets.append(terminate_ret)
        if execute_status is not True:
            LOGGER.logInfo(
                "***[execute cmd: %s failure, errorMsg is: %s]***" % (
                    terminate_cmd, error_msg))
            return (False, cliUtil.RESULT_NOCHECK,
                    common.getMsg(
                        LANG,
                        "hyper.metro.host.query.vmware.config.failure"))

        autoremove_cmd = \
            "esxcli system settings advanced " \
            "list -o '/Disk/AutoremoveOnPDL'"
        execute_status, autoremove_cmd_ret, error_msg = \
            cliUtil.executeHostCmd(context, ssh, autoremove_cmd)
        cli_rets.append(autoremove_cmd_ret)
        if execute_status is not True:
            LOGGER.logInfo(
                "***[execute cmd: %s failure, errorMsg is: %s]***" % (
                    autoremove_cmd, error_msg))
            return (False, cliUtil.RESULT_NOCHECK,
                    common.getMsg(
                        LANG,
                        "hyper.metro.host.query.vmware.config.failure"))
        int_value = ''
        configured = ''
        runtime = ''
        # 解析terminate信息
        setting_dicts = cliUtil.getHorizontalCliRet(terminate_cmd_ret)
        for setting in setting_dicts:
            configured = setting.get('Configured', '')
            runtime = setting.get('Runtime', '')
            break

        # 解析autoremove信息
        lineList = autoremove_cmd_ret.splitlines()
        for line in lineList:
            if "Int Value:" in line:
                fields = line.split(":")
                int_value = fields[-1].strip()
                break

        if version_num == VMWARE_VERSION_5_5 \
            or (version_num == VMWARE_VERSION_6_0
                and version_type <= "Update 1"):
            flag = common.check_config_value_before_6U1(configured, runtime,
                                                        int_value)
            err_key = "hyper.metro.host.query.vmware." \
                      "config.notpass.configRunTime"
            return flag, flag, common.getMsg(LANG, err_key,
                                             (configured, runtime))

        if version_num in VMWARE_VERSION_6_LIST:
            manual_detection_warn = True
            flag = common.check_config_value_after_6U1(configured, runtime,
                                                       int_value)
            err_key = "hyper.metro.host.query.vmware." \
                      "config.notpass.configRunTime"
            return flag, flag, common.getMsg(LANG, err_key,
                                             (configured, runtime))

        return True, True, ''
    except Exception as ex:
        msg = traceback.format_exc()
        LOGGER.logError("checkVmwareFrom55To6u3 ==> " + str(msg) + str(ex))
        return (False,
                cliUtil.RESULT_NOCHECK,
                common.getMsg(
                    LANG, "hyper.metro.host.query.vmware.config.failure"))


def check_vmware5(context, ssh):
    '''
    @summary: include 5.0 5.1
    '''
    try:
        cmd = "cat /etc/vmware/settings"
        execute_status, cli_ret, error_msg = \
            cliUtil.executeHostCmd(context, ssh, cmd)
        cli_rets.append(cli_ret)
        if execute_status is not True:
            LOGGER.logInfo(
                "***[execute cmd: %s failure, errorMsg is: %s]***" % (
                    cmd, error_msg))
            return (False, cliUtil.RESULT_NOCHECK,
                    common.getMsg(
                        LANG,
                        "hyper.metro.host.query.vmware.config.failure"))
        for line in cli_ret.splitlines():
            if 'Disk.terminateVMOnPDLDefault' not in line:
                continue
            settings = line.split('=')
            if settings[-1].strip().lower() == 'true':
                return True, '', ''
            else:
                return (False, False,
                        common.getMsg(
                            LANG,
                            "hyper.metro.host.query.vmware."
                            "config.notpass_doradov6"))
        return (False,
                cliUtil.RESULT_NOCHECK,
                common.getMsg(
                    LANG,
                    "hyper.metro.host.query.vmware.config.failure"))
    except Exception as ex:
        msg = traceback.format_exc()
        LOGGER.logError("checkVmware5 ==> " + str(msg) + str(ex))
        return (False,
                cliUtil.RESULT_NOCHECK,
                common.getMsg(
                    LANG,
                    "hyper.metro.host.query.vmware.config.failure"))


def evaluate_disk_alua(disk_wwn_dict, array_wwn_dict, ssh, context):
    global query_alua_failures, evaluate_not_pass_disks
    evaluate_result = True
    for disk_wwn in disk_wwn_dict:
        disk = disk_wwn_dict.get(disk_wwn)
        execute_status, check_result = query_and_check_disk_alua(disk,
                                                                 context,
                                                                 ssh)
        evaluate_result = evaluate_result and check_result
        if not execute_status:
            query_alua_failures.append(disk)
            update_host_alua_status(array_wwn_dict, disk_wwn, -1)
            LOGGER.logInfo(
                "***[query the disk : %s alua info failure]***" % disk)
            continue
        if not check_result:
            LOGGER.logInfo("***[the disk: %s is not pass]***" % disk)
            update_host_alua_status(array_wwn_dict, disk_wwn, -1)
            evaluate_not_pass_disks.append(disk)
            continue
        update_host_alua_status(array_wwn_dict, disk_wwn, 1)
    return evaluate_result


def get_valid_disk_dict(array_wwn_dict, disk_wwn_dict):
    """
    查看主机和双活阵列LUN是否匹配
    :param array_wwn_dict:
    :param disk_wwn_dict:
    :return:
    """
    valid_disk_wwn_dict = {}
    for array_key in array_wwn_dict.keys():
        lower_key = array_key.lower()
        LOGGER.logInfo("***[lower_key : %s disk_wwn_dict.keys() %s]***"
                       % (lower_key, disk_wwn_dict.keys()))
        if lower_key in disk_wwn_dict.keys():
            array_wwn_dict[array_key][
                "hostAluaStatus"] = ALUA_CONFIGURED_PROPERLY
            valid_disk_wwn_dict[array_key] = disk_wwn_dict[lower_key]
    return valid_disk_wwn_dict


def build_device_access_mode_cli_ret(context):
    """
    获取双活阵列配置cli
    :param context:
    :return:
    """
    access_cli_rets = ''
    sn_cli_ret_dict = host_common.get_host_access_cli_ret(context)
    LOGGER.logInfo('sn_cli_ret_dict : %s' % str(sn_cli_ret_dict))
    for sn, cli_ret in sn_cli_ret_dict.items():
        access_cli_rets += 'HyperMetro Device SN[%s]:\r\n%s\r\n' % (
            sn, cli_ret)
    return access_cli_rets


def handle_result_and_error_msg(evaluate_result):
    '''
    @summary: handle result and construct error message
    '''
    global manual_detection_warn, query_alua_failures, \
        evaluate_not_pass_disks, disk_alua_error
    error_msg = ''
    if query_alua_failures:
        evaluate_result = cliUtil.RESULT_NOCHECK
        error_msg += common.getMsg(LANG, "hyper.metro.alua.query.failure",
                                   ','.join(query_alua_failures))
    if evaluate_not_pass_disks:
        evaluate_result = False
        error_msg += disk_alua_error
    if evaluate_result is True and manual_detection_warn:
        evaluate_result = cliUtil.RESULT_WARNING
        error_msg += common.getMsg(LANG, "PDL.config.ui.not.check.v6")
    return evaluate_result, line_break.join(cli_rets), error_msg


def query_and_check_disk_alua(disk, context, ssh,):
    '''
    @summary: query the alua configure
     information of disk and check the information
    @return: (execute status: True or False, check result: True or False)
    '''
    try:
        cmd = 'esxcli storage nmp device list -d=%s' % disk
        execute_status, cli_ret, error_msg = \
            cliUtil.executeHostCmd(context, ssh, cmd)
        cli_rets.append(cli_ret)
        if execute_status is not True:
            LOGGER.logInfo(
                "***[query the disk : %s alua info failure, "
                "the errorMsg is : %s]***" % (
                    disk, error_msg))
            return False, False
        check_result = get_disk_alua(cli_ret, context, disk)
        return True, check_result
    except Exception as ex:
        msg = traceback.format_exc()
        LOGGER.logError("queryAndCheckDiskAlua ==> " + str(msg) + str(ex))
        return False, False


def get_disk_alua(cli_ret, context, disk):
    global disk_alua_error
    storage_array_type = ''
    path_policy = ''
    for line in cli_ret.splitlines():
        strip_line = line.strip().lower()
        split_lines = strip_line.split(':')
        if 'storage array type:' in strip_line:
            storage_array_type = split_lines[-1].strip()
        elif 'path selection policy:' in strip_line:
            path_policy = split_lines[-1].strip()
    check_flag, error_msg = check_disk_alua_access_mode(context,
                                                        storage_array_type,
                                                        path_policy)
    if check_flag is not True:
        disk_alua_error += common.getMsg(
            LANG, "hyper.metro.6.0.ultrapath.disk.alua.error",
            (disk, error_msg))
    return check_flag


def check_disk_alua_access_mode(context, storage_array_type, path_policy):
    """
    当在阵列上查询到的主机访问模式为“Asymmetric”时，
    若步骤7中字段“Storage Array Type”和“Path Selection Policy”的值，
    分别为“VMW_SATP_ALUA”、“VMW_PSP_RR”，
    则检查结果为通过，否则为不通过；
    当在阵列上查询到的主机访问模式为“Balanced”时，
    若步骤7中字段“Storage Array Type”和“Path Selection Policy”的值，
    分别为“VMW_SATP_DEFAULT_AA”和“VMW_PSP_RR”则检查结果为通过，
    否则为不通过。
    :param context:
    :param storage_array_type:
    :param path_policy:
    :return:
    """
    sn_access_dict = host_common.get_access_mode(context)
    if not bool(sn_access_dict):
        return False, common.getMsg(
            LANG, "hyper.metro.6.0.ultrapath.host.no.accessmode")
    check_flag = True
    error_msg = ''
    for dev_sn, access_mode in sn_access_dict.items():
        if access_mode != "Asymmetric" and access_mode != "Balanced":
            check_flag = False
            error_msg += common.getMsg(
                LANG, "hyper.metro.6.0.ultrapath.host.accessmode.error",
                dev_sn)
            continue
        if access_mode == "Asymmetric":
            if storage_array_type != "vmw_satp_alua" or \
                    path_policy != "vmw_psp_rr":
                check_flag = False
                error_msg += \
                    common.getMsg(
                        LANG, "hyper.metro.6.0.ultrapath.host.alua.error",
                        (dev_sn, access_mode,
                         storage_array_type,
                         path_policy))
            continue
        if access_mode == "Balanced":
            if storage_array_type != "vmw_satp_default_aa" or \
                    path_policy != "vmw_psp_rr":
                check_flag = False
                error_msg += \
                    common.getMsg(
                        LANG, "hyper.metro.6.0.ultrapath.host.alua.error",
                        (dev_sn, access_mode,
                         storage_array_type,
                         path_policy))
            continue
    return check_flag, error_msg


def query_huawei_disk(context, ssh):
    '''
    @summary: query the available huawei disks
    '''
    diskWwpnDict = {}
    cmd = "esxcli storage nmp device list"
    execute_status, cli_ret, error_msg = \
        cliUtil.executeHostCmd(context, ssh, cmd)
    cli_rets.append(cli_ret)
    if not execute_status:
        LOGGER.logInfo(
            "***[execute queryHuaweiDisk failure, errorMsg is: %s]***"
            % error_msg)
        return False, diskWwpnDict
    disk_and_wwn_pattern = re.compile(".*\\((naa.([\\d|a-f]{32}))\\).*",
                                      flags=re.IGNORECASE)
    for line in cli_ret.splitlines():
        disk, wwn = get_wwn_and_disk(line, disk_and_wwn_pattern)
        if disk and wwn:
            diskWwpnDict[wwn.lower()] = disk
    LOGGER.logInfo(
        "execute queryHuaweiDisk, diskWwpnDict is : %s" % diskWwpnDict)
    return True, diskWwpnDict


def get_wwn_and_disk(line, pattern):
    match = pattern.search(line)
    if not match:
        return '', ''
    return match.group(1), match.group(INDEX_INT2)


def get_os_version(context, ssh):
    cmd = 'vmware -l'
    execute_status, cli_ret, error_msg = \
        cliUtil.executeHostCmd(context, ssh, cmd)
    cli_rets.append(cli_ret)
    if execute_status is not True:
        LOGGER.logInfo(
            "***[execute getOsVersion errorMsg is : %s]***" % error_msg)
        return False, '', ''
    pattern_version = re.compile('vmware\\sesxi\\s(\\d\\.\\d)\\.\\d\\s(.*)',
                                 flags=re.IGNORECASE)
    for line in cli_ret.splitlines():
        match = pattern_version.search(line.strip())
        if match:
            return True, float(match.group(1)), match.group(INDEX_INT2)
    return False, '', ''


def has_nmp(context, ssh):
    """
    判断是否带有自带多路径
    :param context:
    :param ssh:
    :return:
    """
    nmp_open = False
    regx = ".*\\((.+)\\).*"
    try:
        cmd = "esxcli storage core device list"
        execute_status, cli_ret, error_msg = cliUtil.executeHostCmd(
            context,
            ssh, cmd)
        cli_rets.append(cli_ret)
        if execute_status is not True:
            LOGGER.logInfo(
                "***[execute cmd: %s failure, errorMsg is: %s]***" % (
                    cmd, error_msg))
            return (False, cliUtil.RESULT_NOCHECK,
                    common.getMsg(
                        LANG, "hyper.metro.host.query.nmp.failure"))
        current_path = False
        current_path_name = ''
        has_multipath_plugin = False
        has_transport = False
        for line in cli_ret.splitlines():
            line = line.strip()
            if line.lower().startswith('display name'):
                match = re.match(regx, line)
                if match:
                    current_path_name = match.group(1)
                    LOGGER.logInfo(
                        "[currentPathName= " + current_path_name + "]")
                    current_path = True
                else:
                    current_path = False
            elif line.lower().startswith('multipath plugin:'):
                has_multipath_plugin = True
                if line.lower().split(':')[-1].strip() == 'nmp' \
                        and current_path:
                    has_transport, nmp_open = check_nmp_path_transport(
                        current_path_name, context, ssh)
                    LOGGER.logInfo(
                        "[currentPathName= %s, "
                        "hasTransport= %s, flag= %s]" % (
                            current_path_name, has_transport, nmp_open))
                    if nmp_open:
                        break
                    else:
                        current_path = False
        if not (has_multipath_plugin and has_transport):
            return (False, cliUtil.RESULT_NOCHECK,
                    common.getMsg(
                        LANG, "hyper.metro.host.query.nmp.failure"))

        # 如果未开启自带多路径
        if not nmp_open:
            return (False, False,
                    common.getMsg(
                        LANG, "hyper.metro.host.query.multipath.not.open"))
        return True, '', ''
    except Exception as ex:
        msg = traceback.format_exc()
        LOGGER.logError("hasNMP ==> " + str(msg) + str(ex))
        return (False, cliUtil.RESULT_NOCHECK,
                common.getMsg(LANG, "hyper.metro.host.query.nmp.failure"))


def check_nmp_path_transport(path_name, context, ssh):
    """
    check nmp path transport'value is 'fc' or 'iscsi'
    :param path_name:
    :param context:
    :param ssh:
    :return:
    """
    flag = False
    has_transport = False
    cmd = 'esxcli storage core path list -d %s' % path_name
    try:
        executeStatus, cliRet, errorMsg = cliUtil.executeHostCmd(context,
                                                                 ssh, cmd)
        cli_rets.append(cliRet)
        if executeStatus is not True:
            LOGGER.logInfo(
                "***[execute cmd: %s failure, errorMsg is: %s]***" % (
                    cmd, errorMsg))
            return has_transport, flag
        for line in cliRet.splitlines():
            item = line.strip().lower()
            if not item.startswith('transport:'):
                continue
            has_transport = True
            transport_value = item.split(':')[-1].strip()
            if 'fc' == transport_value or 'iscsi' == transport_value \
                    or 'fcoe' == transport_value:
                flag = True
                break
        return has_transport, flag
    except Exception as ex:
        msg = traceback.format_exc()
        LOGGER.logError("checkNmpPathTransport ==> " + str(msg) + str(ex))
        return has_transport, flag
