# -*- coding: UTF-8 -*-
import re
import sys
import os
import traceback

import com.huawei.ism.tool.obase.db.SqliteManager as SqliteManager
import common
from cbb.frame.context import sqlite_context
from cbb.frame.cli.cli_with_cache import query_one_cmd

import cliUtil

from common import UnCheckException

script_path = os.path.dirname(os.path.abspath(__file__))
common_path = os.path.join(script_path, "..\\..\\HOST_Common")
sys.path.append(common_path)
import host_common

LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ""
PY_JAVA_ENV = py_java_env
LANG = PY_JAVA_ENV.get("lang")
FAULT_STATUS_VLUN_WWN_DICT = {}
ADDED_ARRAY_SN = []
faultVlunPathStatusDict = {}
vlunIdAndWWNMappView = {}
# 是否有端口组
hasPortGroupFlagDict = {}
ALL_HYPER_LUN_DICT = PY_JAVA_ENV.get("allStrgHyprMtrLns")


def execute(ssh):
    """
     双活LUN是否接管检查

    内部检查方法确认是否有端口组，如果存在端口组且不通过则结果报建议优化：
    执行命令：show mapping_view general 获取mapping_view_id。
    执行命令：show mapping_view general mapping_view_id=? 查询"Port Group ID"是否都为“--”，如果都为"--"则不存在端口组，否则存在端口组，如果存在不通过的项，检查结果为建议优化。

    完成日期: 2018.12.16
    下次更新: 下个版本要优化端口组的方案。

    完成日期: 2019.3.7
    完成更新：完成更新端口组场景方案。

    完成日期：2019.12.16
    完成更新：获取伪装LUN信息，如果伪装LUN做双活需要使用
                伪装过后（show lun_takeover general）的
                LUN WWN和主机上的LUN WWN匹配
    :param ssh:
    :return:
    """

    global ALL_CLI_RET
    context = PY_JAVA_ENV
    lang = context.get("lang")
    errVlunStatusMsg = ""
    notPassErrMsg = ""
    errVlunPathStatusMsg = ""
    errLunStatusNotOnMsg = ""
    errLunNotOnHostMsg = ""
    try:
        # 标记双活LUN
        common.mark_host_upadmin_hyper_metro_luns(PY_JAVA_ENV, ssh, LOGGER)

        # 白名单检查
        context["logger"] = PY_LOGGER
        context["ssh"] = ssh

        # 检查多路径版本信息
        flag, cliRet, errMsg = checkUtralPathVersion(ssh)
        if flag != True:
            return flag, cliRet, errMsg

        # 查询path
        pathInfoDict, iscsiPathIdList = getHostPath(ssh)
        LOGGER.logInfo("pathInfoDict:%s, iscsiPathIdList:%s" % (str(pathInfoDict), str(iscsiPathIdList)))

        # 查询lun wwn
        vlunIdDict = getAllVlun(ssh)
        LOGGER.logInfo("vlunIdDict:%s" % str(vlunIdDict))

        # 检查vlun状态是否正确
        errLunStatusNotOnList = checkVlunStatus(ssh, vlunIdDict)

        # 查询详细vlun路径信息
        vlunPathInfoOnHost, errHyperLunMsg, iscsiCheckedVlunWWNList = getVlunDetailInfo(ssh, vlunIdDict,
                                                                                        iscsiPathIdList)

        LOGGER.logInfo(u"vlunInfoDict:%s，errHyperLunMsg:%s, iscsiCheckedVlunWWNList：%s" % (
            str(vlunPathInfoOnHost), errHyperLunMsg, str(iscsiCheckedVlunWWNList)))

        # 获取启动器信息
        initiatorList = getInitiatorInfoOnHost()
        LOGGER.logInfo("initiatorList:%s" % str(initiatorList))

        # 获取阵列各SN的VLUN path路径
        vlunPathInfoOnArray = getPathInfoFromRealArray(vlunPathInfoOnHost, initiatorList)

        # 比较路径数量信息
        NOT_EXIST_LUN_ON_HOST_LIST, \
        NOT_PASS_ERR_MSG_LIST, OTHER_NOT_PASS_MSG_LIST = compareHostAndArrayInfo(vlunPathInfoOnHost,
                                                                                 vlunPathInfoOnArray,
                                                                                 pathInfoDict, iscsiCheckedVlunWWNList)

        # 主机上查的vlun详情，只显示一个阵列的信息，可能是扫LUN的步骤未执行，需报错提示。
        if errHyperLunMsg:
            OTHER_NOT_PASS_MSG_LIST.append(errHyperLunMsg)

        LOGGER.logInfo("FAULT_STATUS_VLUN_WWN_DICT:%s" % str(FAULT_STATUS_VLUN_WWN_DICT))
        LOGGER.logInfo("NOT_PASS_ERR_MSG_LIST:%s" % str(NOT_PASS_ERR_MSG_LIST))
        LOGGER.logInfo("NOT_EXIST_LUN_ON_HOST_LIST:%s" % str(NOT_EXIST_LUN_ON_HOST_LIST))
        LOGGER.logInfo("faultVlunPathStatusDict:%s" % str(faultVlunPathStatusDict))
        if errLunStatusNotOnList:
            errLunStatusNotOnMsg += common.getMsg(LANG, "hyper.lun.accepted.vlun.status.exception.at.step11",
                                                  ",".join(errLunStatusNotOnList))

        if faultVlunPathStatusDict:
            for vlunWWN in faultVlunPathStatusDict:
                arraySnDict = faultVlunPathStatusDict[vlunWWN]
                for arraySn in arraySnDict:

                    # 只检查添加了的阵列的路径状态是否正常，因为可能有其他非双活LUN。
                    if arraySn and arraySn in ADDED_ARRAY_SN:
                        pathDict = arraySnDict[arraySn]
                        for pathId in pathDict:
                            errVlunPathStatusMsg += common.getMsg(LANG, "hyper.lun.accepted.vlun.path.status.exception",
                                                                  (
                                                                      vlunIdAndWWNMappView.get(vlunWWN, vlunWWN),
                                                                      pathId,
                                                                      pathDict[pathId],
                                                                      arraySn))

        if FAULT_STATUS_VLUN_WWN_DICT:
            for vlunWWN in FAULT_STATUS_VLUN_WWN_DICT:
                arraySnDict = FAULT_STATUS_VLUN_WWN_DICT[vlunWWN].get("arraySn")
                for arraySn in arraySnDict:
                    # 只检查添加了的阵列的路径状态是否正常，因为可能有其他非双活LUN。
                    if arraySn and arraySn in ADDED_ARRAY_SN:
                        errVlunStatusMsg += common.getMsg(LANG, "hyper.lun.accepted.vlun.status.exception", (
                            vlunIdAndWWNMappView.get(vlunWWN, vlunWWN),
                            arraySnDict.get(arraySn),
                            arraySn))

        if NOT_EXIST_LUN_ON_HOST_LIST:
            errMsgList = []
            for key in NOT_EXIST_LUN_ON_HOST_LIST:
                errMsgList.append(u"%s:%s" % (key, ",".join(NOT_EXIST_LUN_ON_HOST_LIST[key])))
            errLunNotOnHostMsg += common.getMsg(LANG, "hyper.lun.accepted.vlun.not.mapped.on.host",
                                                ",".join(errMsgList))

        if NOT_PASS_ERR_MSG_LIST or NOT_EXIST_LUN_ON_HOST_LIST or errVlunStatusMsg or errVlunPathStatusMsg or errLunStatusNotOnMsg or OTHER_NOT_PASS_MSG_LIST:
            if NOT_PASS_ERR_MSG_LIST:
                notPassErrMsg += common.getMsg(LANG, "hyper.lun.accepted.vlun.path.smaller.than.array.title") + "".join(
                    NOT_PASS_ERR_MSG_LIST)
            notPassErrMsg += errLunNotOnHostMsg
            notPassErrMsg += errVlunStatusMsg
            notPassErrMsg += errVlunPathStatusMsg
            notPassErrMsg += errLunStatusNotOnMsg
            notPassErrMsg += "".join(OTHER_NOT_PASS_MSG_LIST)
            return False, ALL_CLI_RET, notPassErrMsg

        return True, ALL_CLI_RET, ''
    except UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if unCheckException.flag is None:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, unCheckException.errorMsg

        return unCheckException.flag, ALL_CLI_RET, unCheckException.errorMsg

    except:
        LOGGER.logError(str(traceback.format_exc()))
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(lang, "query.result.abnormal")


def compareHostAndArrayInfo(vlunPathInfoOnHost, vlunPathInfoOnArray, pathInfoDict, iscsiCheckedVlunWWNList):
    """
    比较主机侧和阵列侧路径信息
    :param vlunPathInfoOnHost:
    :param vlunPathInfoOnArray:
    :param pathInfoDict:
    :return:
    """
    NOT_EXIST_LUN_ON_HOST_LIST = {}
    NOT_PASS_ERR_MSG_LIST = []
    OTHER_NOT_PASS_MSG_LIST = []
    for arraySn in vlunPathInfoOnHost:
        vlunInfoOnHostDict = vlunPathInfoOnHost.get(arraySn, {})
        vlunInfoOnArrayDict = vlunPathInfoOnArray.get(arraySn, {})
        lunPathInfoDictOnArray = vlunInfoOnArrayDict.get("lunPathInfoDict", {})
        lunHostDict = vlunInfoOnArrayDict.get("lunHostDict", {})
        notStandardViewList = vlunInfoOnArrayDict.get("notStandardViewList", {})
        if notStandardViewList:
            OTHER_NOT_PASS_MSG_LIST.append(
                common.getMsg(LANG, "hyper.lun.accepted.vlun.path.exist.fc.and.iscsi.initiator",
                              (arraySn, ",".join(notStandardViewList))))
        for vlunWWN in lunPathInfoDictOnArray:
            if vlunWWN not in vlunInfoOnHostDict:
                tmpList = NOT_EXIST_LUN_ON_HOST_LIST.get(arraySn, [])
                tmpList.append(vlunWWN)
                NOT_EXIST_LUN_ON_HOST_LIST[arraySn] = tmpList
                continue

            # iscsi组网已检查。
            if vlunWWN in iscsiCheckedVlunWWNList:
                LOGGER.logInfo("vlunWWN is checked by iscsi : %s" % vlunWWN)
                continue

            pathInfoListOnArray = lunPathInfoDictOnArray.get(vlunWWN, [])
            pathInfoDictOnHost = vlunInfoOnHostDict.get(vlunWWN, {})
            arrayPathNum = len(pathInfoListOnArray)
            hostPathNum = pathInfoDictOnHost.get("totalPathNum", 0)
            hostId = ",".join(lunHostDict.get(vlunWWN, []))
            LOGGER.logInfo(
                "arraySn:%s, vlunWWN:%s, arrayPathNum: %s, hostPathNum:%s, pathInfoListOnArray:%s, pathInfoDictOnHost:%s" % (
                    arraySn, vlunWWN, arrayPathNum, hostPathNum, pathInfoListOnArray, pathInfoDictOnHost))
            if hostPathNum >= arrayPathNum:
                continue

            hostPathIdList = pathInfoDictOnHost.get("pathIdList", [])

            pathDetailOnHost = {}
            for pathId in hostPathIdList:
                initiatorWWN = pathInfoDict.get(pathId, "")
                iniNum = pathDetailOnHost.get(initiatorWWN, 0)
                iniNum += 1
                pathDetailOnHost[initiatorWWN] = iniNum

            tmpArrayErrMsg = []
            tmpHostErrMsg = []
            pathResDict = {}
            for path in pathInfoListOnArray:
                pathNum = pathResDict.get(path[0], 0)
                pathNum += 1
                pathResDict[path[0]] = pathNum

            for key in pathResDict:
                tmpArrayErrMsg.append("%s:%s" % (key, pathResDict[key]))

            for ini in pathDetailOnHost:
                tmpHostErrMsg.append("%s:%s" % (ini, pathDetailOnHost[ini]))

            NOT_PASS_ERR_MSG_LIST.append(
                common.getMsg(LANG, "hyper.lun.accepted.vlun.path.smaller.than.array",
                              (hostId,
                               vlunIdAndWWNMappView.get(vlunWWN, vlunWWN),
                               arraySn,
                               ",".join(tmpArrayErrMsg),
                               ",".join(tmpHostErrMsg))))

    return NOT_EXIST_LUN_ON_HOST_LIST, NOT_PASS_ERR_MSG_LIST, OTHER_NOT_PASS_MSG_LIST


def getInitiatorInfoOnHost():
    """
    获取主机侧全部启动器信息。
    :return:
    """
    iniList = []

    devNode = PY_JAVA_ENV.get("devInfo")

    # 主机侧FC启动器信息
    hostFCLauncherWwns = devNode.getHostFCLauncherWwns()

    if hostFCLauncherWwns:
        iniList.extend(hostFCLauncherWwns)

    # 主机侧ISCSI启动器信息
    hostISCSILauncherWwns = devNode.getHostISCSILauncherWwns()

    if hostISCSILauncherWwns:
        iniList.extend(hostISCSILauncherWwns)

    iniListTemp = [str(ini).lower() for ini in iniList]

    return iniListTemp


def getVlunDetailInfo(ssh, vlunIdList, iscsiPathIdList):
    """
    获取主机侧VLUN路径信息
    :param ssh:
    :param vlunIdList:
    :return:
    """
    global ALL_CLI_RET, FAULT_STATUS_VLUN_WWN_DICT, faultVlunPathStatusDict, vlunIdAndWWNMappView
    vlunInfoDict = {}
    errHyperLunMsg = ""
    iscsiCheckedVlunWWNList = []
    cmd = "esxcli upadm show vlun -l %s -t hypermetro"
    for vlunId in vlunIdList:
        tmpVlunPathDict = {}
        isIscsiPath = False
        cmdStr = cmd % vlunId
        flag, cliRet, errMsg = cliUtil.executeCmdWithTimeout(ssh, cmdStr, LOGGER)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag != True:
            raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET)

        if "Can't find" in cliRet or "Unknown command" in cliRet or "command not found" in cliRet or "command-not-found" in cliRet:
            raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "vlun"), ALL_CLI_RET,
                                   cliUtil.RESULT_NOCHECK)

        segCliRetList = cliRet.split("Aggregation Member#")
        for segCliRet in segCliRetList:
            arraySn = ''
            lunWWN = ''
            numOfPath = 0
            lunStatus = ''
            pathIdList = []
            if "Status" in segCliRet and "LUN WWN" in segCliRet and "Array SN" in segCliRet and "Num of Paths" in segCliRet:
                resLines = segCliRet.splitlines()
                for line in resLines:
                    tmpLine = line.strip()
                    if tmpLine.startswith("Status"):
                        tmpList = tmpLine.split(":")
                        if len(tmpList) != 2:
                            continue

                        lunStatus = tmpList[1].strip()
                        continue

                    if tmpLine.startswith("LUN WWN"):
                        tmpList = tmpLine.split(":")
                        if len(tmpList) != 2:
                            continue

                        lunWWN = tmpList[1].strip()
                        continue

                    if tmpLine.startswith("Array SN"):
                        tmpList = tmpLine.split(":")
                        if len(tmpList) != 2:
                            continue

                        arraySn = tmpList[1].strip()
                        continue

                    if tmpLine.startswith("Num of Paths"):
                        tmpList = tmpLine.split(":")
                        if len(tmpList) != 2:
                            continue

                        numOfPath = tmpList[1].strip()
                        if str(numOfPath).isdigit():
                            numOfPath = int(numOfPath)
                        continue

                    if tmpLine.startswith("Path"):
                        pathId = ''
                        res = re.match(r"Path (\d+)", tmpLine, re.I)
                        if res:
                            pathId = res.group(1)
                            if pathId:
                                if pathId in iscsiPathIdList:
                                    isIscsiPath = True
                                pathIdList.append(pathId)
                        pathStatus = tmpLine.split(":")[-1].strip()
                        LOGGER.logInfo("pathStatus is :%s" % pathStatus)
                        if pathStatus.lower() == "fault":
                            tmpDict = faultVlunPathStatusDict.get(lunWWN, {})
                            tmpArrayDict = tmpDict.get(arraySn, {})
                            tmpArrayDict[pathId] = pathStatus
                            tmpDict[arraySn] = tmpArrayDict
                            faultVlunPathStatusDict[lunWWN] = tmpDict
                            pathIdList.remove(pathId)

                if arraySn and lunWWN and numOfPath and lunStatus:
                    # 使用路径状态正常的逻辑路径和阵列比较数量。
                    numOfPath = len(pathIdList)

                    if cliRet.count("Aggregation Member#") < 2 and lunWWN in ALL_HYPER_LUN_DICT:
                        errHyperLunMsg += common.getMsg(LANG, "hyper.lun.accepted.vlun.path.only.one.array",
                                                        (lunWWN, arraySn))
                    vlunIdAndWWNMappView[lunWWN] = vlunId
                    if lunStatus != "Normal":
                        tmpeDict = FAULT_STATUS_VLUN_WWN_DICT.get(lunWWN, {})
                        arraySnDict = tmpeDict.get("arraySn", {})
                        arraySnDict[arraySn] = lunStatus
                        tmpeDict["arraySn"] = arraySnDict
                        FAULT_STATUS_VLUN_WWN_DICT[lunWWN] = tmpeDict

                    arrayPathInfoDict = vlunInfoDict.get(arraySn, {})
                    arrayPathInfoDict[lunWWN] = {"totalPathNum": numOfPath,
                                                 "pathIdList": pathIdList,
                                                 "lunStatus": lunStatus
                                                 }

                    tmpDictPath = tmpVlunPathDict.get(lunWWN, {})
                    tmpDictPath[arraySn] = pathIdList
                    tmpVlunPathDict[lunWWN] = tmpDictPath

                    vlunInfoDict[arraySn] = arrayPathInfoDict
                    arraySn = ''
                    lunWWN = ''
                    numOfPath = ''
                    lunStatus = ''
                    pathIdList = ''

        LOGGER.logInfo(u"isIscsiPath：%s, tmpVlunPathDict:%s" % (isIscsiPath, tmpVlunPathDict))
        if isIscsiPath:
            for lunWWN in tmpVlunPathDict:
                iscsiCheckedVlunWWNList.append(lunWWN)
                snList = tmpVlunPathDict[lunWWN].keys()
                if len(snList) >= 2:
                    pathListA = tmpVlunPathDict[lunWWN][snList[0]]
                    pathListB = tmpVlunPathDict[lunWWN][snList[1]]
                    if len(pathListA) != len(pathListB):
                        errHyperLunMsg += common.getMsg(LANG, "hyper.lun.accepted.vlun.path.not.same.on.array", (
                            vlunId, snList[0], len(pathListA), snList[1], len(pathListB)
                        ))
    return vlunInfoDict, errHyperLunMsg, iscsiCheckedVlunWWNList


def checkVlunStatus(ssh, vlunIdDict):
    """
    检查VLUN 状态是否为on
    :param ssh:
    :param vlunIdDict:
    :return:
    """
    global ALL_CLI_RET
    errLunStatusNotOnList = []
    for vlunId in vlunIdDict:
        wwn = vlunIdDict[vlunId]

        cmd = "esxcfg-scsidevs -l |  grep -A13  '^naa.%s'" % wwn
        flag, cliRet, errMsg = cliUtil.executeCmdWithTimeout(ssh, cmd, LOGGER)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag != True:
            raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "vlun"), ALL_CLI_RET)

        if "Can't find" in cliRet or "Unknown command" in cliRet or "command not found" in cliRet or "command-not-found" in cliRet:
            raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET,
                                   cliUtil.RESULT_NOSUPPORT)

        if "Status: on" not in cliRet:
            errLunStatusNotOnList.append(vlunId)

    return list(set(errLunStatusNotOnList))


def getAllVlun(ssh):
    """
    获取主机侧VLUN 信息
    :param ssh:
    :return:
    """
    global ALL_CLI_RET
    vlunIdDict = {}
    cmd = "esxcli upadm show vlun -t hypermetro"
    flag, cliRet, errMsg = cliUtil.executeCmdWithTimeout(ssh, cmd, LOGGER)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET)

    if "Can't find" in cliRet or "Unknown command" in cliRet or "command not found" in cliRet or "command-not-found" in cliRet:
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET,
                               cliUtil.RESULT_NOSUPPORT)

    resLines = cliRet.splitlines()
    isStart = False
    for line in resLines:
        vlunWWN = ''
        if "Vlun ID" in line:
            isStart = True
            continue

        if not isStart:
            continue

        vlunId = ''
        tmpList = line.split()
        if len(tmpList) >= 8:
            vlunId = tmpList[0].strip()

        res = re.search("\s([\d|a-f]{32})\s", line, flags=re.IGNORECASE)
        if res:
            vlunWWN = res.group(0)
        if vlunId and vlunWWN:
            vlunIdDict[vlunId] = vlunWWN.strip()

    return vlunIdDict


def getArrayPathInfo(ssh, arrayList):
    """
    获取每个阵列的path信息
    :param ssh:
    :param arrayList:
    :return:
    """
    global ALL_CLI_RET
    arrayPathInfoDict = {}
    cmd = "esxcli upadm show diskarray -a %s"
    for arrayId in arrayList:
        cmdStr = cmd % arrayId
        flag, cliRet, errMsg = cliUtil.executeCmdWithTimeout(ssh, cmdStr, LOGGER)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag != True:
            raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET)

        if "Can't lookup" in cliRet or "Unknown command" in cliRet or "command not found" in cliRet or "command-not-found" in cliRet:
            raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET,
                                   cliUtil.RESULT_NOSUPPORT)

        resLines = cliRet.splitlines()
        arraySn = ''
        pathDict = {}
        for line in resLines:
            tmpLine = line.strip()
            if tmpLine.startswith("Array SN"):
                tmpList = tmpLine.split(":")
                if len(tmpList) == 2:
                    arraySn = tmpList[1]
            if tmpLine.startswith("Path") and not "PathInfo" in tmpLine:
                res = re.match(r"Path(\d+):(.*)", tmpLine, re.I)
                if res:
                    pathId = res.group(1).strip()
                    pathStatus = res.group(2).strip()
                    pathDict[pathId] = pathStatus
        if arraySn:
            arrayPathInfoDict[arraySn] = pathDict

    return arrayPathInfoDict


def getHostPath(ssh):
    """
    获取主机path信息
    :param ssh:
    :return:
    """
    global ALL_CLI_RET
    pathInfoDict = {}
    iscsiPathIdList = []
    cmd = "esxcli upadm show path"
    flag, cliRet, errMsg = cliUtil.executeCmdWithTimeout(ssh, cmd, LOGGER)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "path"), ALL_CLI_RET)

    if "Can't find" in cliRet or "Unknown command" in cliRet or "command not found" in cliRet or "command-not-found" in cliRet:
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "path"), ALL_CLI_RET, cliUtil.RESULT_NOSUPPORT)

    resLines = cliRet.splitlines()
    for line in resLines:
        tmpList = line.strip().split()
        if len(tmpList) == 9 and "Path ID" not in line:
            pathId = tmpList[0].strip()
            targetPortInitiator = tmpList[1].strip()
            pathInfoDict[pathId] = targetPortInitiator
            if tmpList[7] != "FC":
                iscsiPathIdList.append(pathId)

    return pathInfoDict, iscsiPathIdList


def checkUtralPathVersion(ssh):
    """
    检查utralpath版本信息
    :param ssh:
    :return:
    """
    try:
        # 判断upadm版本信息
        softVer = getHostMutipathVersion(ssh)

        if not softVer:
            return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''

        # 如果是老版本则检查不通过
        if checkSoftVersion(softVer):
            return False, ALL_CLI_RET, common.getMsg(LANG, "hypermetro.mutipath.version.lower", softVer)

        return True, ALL_CLI_RET, ''

    except UnCheckException, unCheckException:
        LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if unCheckException.flag is None:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, unCheckException.errorMsg

        return unCheckException.flag, ALL_CLI_RET, unCheckException.errorMsg

    except:
        LOGGER.logException()
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal")


def checkSoftVersion(softVer):
    """
    判断版本是否是老版本
    :param softVer:
    :return:
    """
    if softVer.startswith("8") and softVer < "8.03.028":
        return True
    elif int(softVer.split(".")[0]) < 8:
        return True

    return False


def getHostMutipathVersion(ssh):
    """
    获取主机上多路径版本
    :param ssh:
    :return: flag, softVer
            flag:True 获取成功，False 获取失败
            softVer: 版本信息
    """
    global ALL_CLI_RET
    cmd = "esxcli upadm show version"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3 * 60)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if "Error" in cliRet or "Unknown command" in cliRet or "command not found" in cliRet or \
            "command-not-found" in cliRet or "Software Version" not in cliRet:
        return ''

    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x: x in cliRet.lower(), regx):
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "UltraPath Software Version"), ALL_CLI_RET)

    cliRetLines = cliRet.splitlines()
    softVer = ''
    driverVer = ''
    for line in cliRetLines:
        if "Software Version" in line:
            lineList = line.split(":")
            if len(lineList) == 2:
                softVer = lineList[1].strip()
            continue

        if "Driver   Version" in line:
            lineList = line.split(":")
            if len(lineList) == 2:
                driverVer = lineList[1].strip()

    if softVer and driverVer and softVer == driverVer:
        return softVer

    if not softVer:
        return softVer

    if softVer != driverVer:
        raise UnCheckException(common.getMsg(LANG, "multipath.softwareVersion.not.equal.driverVersion"), ALL_CLI_RET,
                               False)

    return softVer


def getArrayInfo(ssh):
    """
    获取阵列信息
    :param ssh:
    :return:
    """
    global ALL_CLI_RET
    arrayIdList = []
    cmd = "esxcli upadm show diskarray"
    cliRet = ssh.execCmdNoLogTimout(cmd, 3 * 60)
    if not cliRet:
        return arrayIdList
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if "Error" in cliRet or "Unknown command" in cliRet or "command not found" in cliRet or "command-not-found" in cliRet:
        return arrayIdList

    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x: x in cliRet.lower(), regx):
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "array"), ALL_CLI_RET)

    cliRetLines = cliRet.splitlines()
    isTitleLine = False
    for line in cliRetLines:
        if not isTitleLine and "Array ID" and "WWN" in line:
            isTitleLine = True
            continue

        if isTitleLine:
            lineList = line.split()
            if not len(lineList) >= 3:
                continue

            arrayId = lineList[0].strip()
            if arrayId:
                arrayIdList.append(arrayId)
    return arrayIdList


def getPathInfoFromRealArray(arrayDict, initiatorList):
    global ALL_CLI_RET, ADDED_ARRAY_SN, hasPortGroupFlagDict
    arrayInfoDict = {}
    objectForPy = PY_JAVA_ENV.get("objectForPy")
    sqlite_manager = SqliteManager()
    for arraySn in arrayDict:
        sqlite_conn = sqlite_context.get_sqlite_conn_from_context(
            objectForPy, arraySn, LOGGER
        )
        # 主机侧有，但未关联的阵列
        if not host_common.need_check_array(PY_JAVA_ENV, arraySn):
            LOGGER.logInfo(
                "array sn is:{} do not check.".format(arraySn)
            )
            continue

        # 获取当前存储SN对应的版本
        p_version = host_common.get_product_version_from_mem(
            objectForPy,
            arraySn)

        ADDED_ARRAY_SN.append(arraySn)
        ret = "\n\n----------------Array SN Echo({})" \
              "----------------\n".format(arraySn)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
        hyperLunDict = getHyperLunDictOnArray(
            sqlite_manager, sqlite_conn, arraySn
        )
        LOGGER.logInfo("sn is:%s, hyper Lun:%s" % (arraySn, hyperLunDict))
        initiatorPortLinkDict, cli_ret = host_common.getPortInfo(
            sqlite_manager, sqlite_conn, arraySn, LANG
        )
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        # 如果没有则使用命令查询和require保持一致的查询策略
        cmd = "show initiator initiator_type=FC"
        host_fc_ini_dict = host_common.get_host_ini_info(
            sqlite_manager, sqlite_conn, arraySn, LANG, cmd, "WWN"
        )
        # 获取主机ISCSI启动器信息
        cmd = "show initiator initiator_type=iSCSI"
        host_iscsi_ini_dict = host_common.get_host_ini_info(
            sqlite_manager, sqlite_conn, arraySn, LANG, cmd, "iSCSI IQN"
        )

        # 从config中获取信息，如果获取失败，则使用命令查询
        running_data_dict = host_common.get_running_data(objectForPy,
                                                         p_version,
                                                         arraySn)
        param_dict = {}
        param_dict["mem_obj"] = objectForPy
        param_dict["p_version"] = p_version
        param_dict["hyper_lun_dict"] = hyperLunDict
        param_dict["ini_port_dict"] = initiatorPortLinkDict
        param_dict["ini_on_host_list"] = initiatorList
        param_dict["host_fc_ini_dict"] = host_fc_ini_dict
        param_dict["host_iscsi_ini_dict"] = host_iscsi_ini_dict
        param_dict["sqlite_manager"] = sqlite_manager
        param_dict["sqlite_conn"] = sqlite_conn
        param_dict["sn"] = arraySn
        param_dict["lang"] = LANG
        param_dict["logger"] = LOGGER
        if running_data_dict:
            (
                ns_view_list,
                os_view_list,
                path_list,
                lun_host_dict,
            ) = host_common.get_mapping_view_initiator_from_config_ocean(
                param_dict
            )
            cli_ret = host_common.CONFIG_CLI_RET.format(str(path_list))
            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        else:
            (
                ns_view_list,
                os_view_list,
                path_list,
                lun_host_dict,
                all_ret,
            ) = host_common.get_mapping_view_initiator_ocean(param_dict)
            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, all_ret)
        LOGGER.logInfo(
            "arraySn:%s,\nns_view_list:%s, "
            "\nos_view_list:%s, \npath_list:%s, "
            "\nlun_host_dict:%s" % (
                arraySn, ns_view_list, os_view_list,
                path_list, lun_host_dict))

        arrayInfoDict[arraySn] = {
            "notStandardViewList": ns_view_list,
            "onlyIscsiViewLunWWNList": os_view_list,
            "lunPathInfoDict": path_list,
            "lunHostDict": lun_host_dict
        }

    return arrayInfoDict


def getCmdRes(sqlite_manager, sqlite_conn, cmd, sn):
    """
    从内存中获取命令回显API
    :param sqlite_manager: 防止每次创建数据库管理
    :param sqlite_conn: 数据库连接
    :param cmd: 命令
    :param sn: 设备SN
    :return:
    """
    return host_common.get_cmd_res(sqlite_manager, sqlite_conn, cmd, sn, LANG)


def getHyperLunDictOnArray(sqlite_manager, sqlite_conn, sn):
    """
    获取阵列侧的双活LUN
    :param sqlite_manager:
    :param sqlite_conn:
    :param sn:
    :return:
    """
    global ALL_CLI_RET
    hyperLunDict = {}
    cmd = "show hyper_metro_pair general |filterRow column=Type " \
          "predict=equal_to value=LUN |filterColumn include " \
          r"columnList=Local\sID,WWN"
    flag, cliRet, errMsg = getCmdRes(sqlite_manager, sqlite_conn, cmd, sn)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag is not True:
        raise UnCheckException(errMsg, ALL_CLI_RET, flag)

    # 获取伪装LUN信息
    take_lun_info_dict = get_take_lun(sqlite_manager, sqlite_conn, sn)
    hyperLunDictList = common.getHorizontalCliRet(cliRet)
    for info in hyperLunDictList:
        lunId = info.get("Local ID", "")
        lunWWN = info.get("WWN", "")
        if lunId and lunWWN:
            if take_lun_info_dict and lunWWN in take_lun_info_dict:
                lunWWN = take_lun_info_dict.get(lunWWN)
            hyperLunDict[lunId] = lunWWN

    return hyperLunDict


def get_take_lun(sqlite_manager, sqlite_conn, sn):
    """
    获取伪装LUN信息，如果伪装LUN做双活需要使用伪装过后的LUN WWN和主机上的
    LUN WWN匹配
    :param sqlite_manager: 数据库管理对象
    :param sqlite_conn: 当前阵列数据库连接
    :param sn: 当前阵列SN
    :return: {常规LUN WWN : 伪装LUN WWN}
    """
    take_lun_dict = {}
    cmd_str = "show lun_takeover general"
    flag, cli_ret, err_msg = getCmdRes(
        sqlite_manager, sqlite_conn, cmd_str, sn
    )
    if flag is not True:
        msg = common.getMsg(LANG, "hyper.lun.accepted.take.lun.error")
        raise UnCheckException(msg, ALL_CLI_RET)

    take_lun_info_list = common.get_horizontal_nostandard_cli_ret(cli_ret)
    for take_lun_info in take_lun_info_list:
        local_wwn = take_lun_info.get("WWN", "")
        t_lun_wwn = take_lun_info.get("Takeover LUN WWN", "")
        take_lun_dict[local_wwn] = t_lun_wwn

    return take_lun_dict


def hasPortGroup(sqlite_manager, sqlite_conn, sn):
    """
    判断是否有端口组
    :param sqlite_manager: 数据库管理对象
    :param sqlite_conn: 当前阵列数据库连接
    :param sn: 当前阵列SN
    :return:
    """
    global ALL_CLI_RET
    hasPortGroupFlag = False
    mappingViewList = []
    cmd = "show mapping_view general"
    flag, cliRet, errMsg = getCmdRes(sqlite_manager, sqlite_conn, cmd, sn)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    tmpResDict = common.getHorizontalCliRet(cliRet)
    for tmpDict in tmpResDict:
        mappId = tmpDict.get("Mapping View ID", '')
        if mappId:
            mappingViewList.append(mappId)

    cmdStr = "show mapping_view general mapping_view_id=%s"
    for mappId in mappingViewList:
        cmd = cmdStr % mappId
        flag, cliRet, errMsg = getCmdRes(sqlite_manager, sqlite_conn, cmd, sn)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        tmpResDict = common.getVerticalCliRet(cliRet)
        for tmpDict in tmpResDict:
            protGroupId = tmpDict.get("Port Group ID", '')
            if protGroupId and protGroupId != "--":
                hasPortGroupFlag = True
                return hasPortGroupFlag

    return hasPortGroupFlag
